/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Objects;
import java.util.Set;

public abstract class AnnotatedPredicate<P extends IPredicate, A>
implements IPredicate {
    protected final P mUnderlying;
    protected final A mAnnotation;

    protected AnnotatedPredicate(P underlying, A annotation) {
        this.mUnderlying = (IPredicate)Objects.requireNonNull(underlying);
        this.mAnnotation = annotation;
    }

    @Override
    public String[] getProcedures() {
        return this.mUnderlying.getProcedures();
    }

    @Override
    public Set<IProgramVar> getVars() {
        return this.mUnderlying.getVars();
    }

    @Override
    public Term getFormula() {
        return this.mUnderlying.getFormula();
    }

    @Override
    public Term getClosedFormula() {
        return this.mUnderlying.getClosedFormula();
    }

    public P getUnderlying() {
        return this.mUnderlying;
    }

    public int hashCode() {
        return Objects.hash(this.mAnnotation, this.mUnderlying);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotatedPredicate other = (AnnotatedPredicate)obj;
        return Objects.equals(this.mAnnotation, other.mAnnotation) && Objects.equals(this.mUnderlying, other.mUnderlying);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [underlying: " + this.mUnderlying + ", annotation: " + this.mAnnotation + "]";
    }
}

