/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.Set;

public class BasicPredicate
extends ModernAnnotations
implements IPredicate {
    private static final long serialVersionUID = -2257982001512157622L;
    protected final String[] mProcedures;
    protected Term mFormula;
    protected final Term mClosedFormula;
    protected final Set<IProgramVar> mVars;
    protected final int mSerialNumber;

    public BasicPredicate(int serialNumber, String[] procedures, Term term, Set<IProgramVar> vars, Term closedFormula) {
        this.mFormula = term;
        this.mClosedFormula = closedFormula;
        this.mProcedures = procedures;
        this.mVars = vars;
        this.mSerialNumber = serialNumber;
    }

    @Override
    @Visualizable
    public String[] getProcedures() {
        return this.mProcedures;
    }

    @Override
    @Visualizable
    public Term getFormula() {
        return this.mFormula;
    }

    @Override
    public Term getClosedFormula() {
        return this.mClosedFormula;
    }

    @Override
    @Visualizable
    public Set<IProgramVar> getVars() {
        return this.mVars;
    }

    public String toString() {
        return String.valueOf(this.mSerialNumber) + "#" + this.mFormula.toStringDirect();
    }

    public boolean isUnknown() {
        return false;
    }

    public final int hashCode() {
        return HashUtils.hashJenkins((int)31, (Object)this.mSerialNumber);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BasicPredicate)) {
            return false;
        }
        BasicPredicate other = (BasicPredicate)obj;
        return this.mSerialNumber == other.mSerialNumber;
    }
}

