/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.ModelCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BuchiPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.SmtFreePredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsProc;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.UltimateNormalFormUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class BasicPredicateFactory
extends SmtFreePredicateFactory {
    protected static final Set<IProgramVar> EMPTY_VARS = Collections.emptySet();
    protected static final String[] NO_PROCEDURE = new String[0];
    protected final IIcfgSymbolTable mSymbolTable;
    protected final Script mScript;
    protected final IUltimateServiceProvider mServices;
    protected final ManagedScript mMgdScript;
    protected final ILogger mLogger;

    public BasicPredicateFactory(IUltimateServiceProvider services, ManagedScript mgdScript, IIcfgSymbolTable symbolTable) {
        this.mServices = services;
        this.mLogger = this.mServices.getLoggingService().getLogger(ModelCheckerUtils.PLUGIN_ID);
        this.mSymbolTable = symbolTable;
        this.mMgdScript = mgdScript;
        this.mScript = mgdScript.getScript();
    }

    public BasicPredicate newPredicate(Term term) {
        assert (term == this.mDontCareTerm || UltimateNormalFormUtils.respectsUltimateNormalForm((Term)term)) : "Term not in UltimateNormalForm";
        TermVarsProc termVarsProc = this.constructTermVarsProc(term);
        BasicPredicate predicate = new BasicPredicate(this.constructFreshSerialNumber(), termVarsProc.getProcedures(), termVarsProc.getFormula(), termVarsProc.getVars(), termVarsProc.getClosedFormula());
        return predicate;
    }

    protected TermVarsProc constructTermVarsProc(Term term) {
        TermVarsProc termVarsProc = term == this.mDontCareTerm ? this.constructDontCare() : TermVarsProc.computeTermVarsProc(term, this.mMgdScript, this.mSymbolTable);
        return termVarsProc;
    }

    private TermVarsProc constructDontCare() {
        return new TermVarsProc(this.mDontCareTerm, EMPTY_VARS, NO_PROCEDURE, this.mDontCareTerm);
    }

    public IPredicate newBuchiPredicate(Set<IPredicate> inputPreds) {
        Term conjunction = this.andTermFromPreds(inputPreds, SmtUtils.SimplificationTechnique.NONE);
        TermVarsProc tvp = TermVarsProc.computeTermVarsProc(conjunction, this.mMgdScript, this.mSymbolTable);
        return new BuchiPredicate(this.constructFreshSerialNumber(), tvp.getProcedures(), tvp.getFormula(), tvp.getVars(), tvp.getClosedFormula(), inputPreds);
    }

    public IPredicate and(IPredicate ... preds) {
        return this.and(Arrays.asList(preds));
    }

    public IPredicate and(SmtUtils.SimplificationTechnique st, IPredicate ... preds) {
        return this.and(st, Arrays.asList(preds));
    }

    public IPredicate and(Collection<IPredicate> preds) {
        return this.and(SmtUtils.SimplificationTechnique.NONE, preds);
    }

    public IPredicate and(SmtUtils.SimplificationTechnique st, Collection<IPredicate> preds) {
        return this.newPredicate(this.andTermFromPreds(preds, st));
    }

    public IPredicate or(IPredicate ... preds) {
        return this.or(Arrays.asList(preds));
    }

    public IPredicate or(SmtUtils.SimplificationTechnique st, IPredicate ... preds) {
        return this.or(st, Arrays.asList(preds));
    }

    public IPredicate or(Collection<IPredicate> preds) {
        return this.or(SmtUtils.SimplificationTechnique.NONE, preds);
    }

    public IPredicate or(SmtUtils.SimplificationTechnique st, Collection<IPredicate> preds) {
        return this.newPredicate(this.orTermFromPreds(preds, st));
    }

    public IPredicate not(IPredicate p) {
        return this.newPredicate(this.notTerm(p));
    }

    public IPredicate andT(Term ... terms) {
        return this.andT(Arrays.asList(terms));
    }

    public IPredicate andT(SmtUtils.SimplificationTechnique st, Term ... terms) {
        return this.andT(st, Arrays.asList(terms));
    }

    public IPredicate andT(Collection<Term> terms) {
        return this.andT(SmtUtils.SimplificationTechnique.NONE, terms);
    }

    public IPredicate andT(SmtUtils.SimplificationTechnique st, Collection<Term> terms) {
        return this.newPredicate(this.andTerm(terms, st));
    }

    public IPredicate orT(Term ... terms) {
        return this.orT(Arrays.asList(terms));
    }

    public IPredicate orT(SmtUtils.SimplificationTechnique st, Term ... terms) {
        return this.orT(st, Arrays.asList(terms));
    }

    public IPredicate orT(Collection<Term> terms) {
        return this.orT(SmtUtils.SimplificationTechnique.NONE, terms);
    }

    public IPredicate orT(SmtUtils.SimplificationTechnique st, Collection<Term> terms) {
        return this.newPredicate(this.orTerm(terms, st));
    }

    private Term orTermFromPreds(Collection<IPredicate> preds, SmtUtils.SimplificationTechnique st) {
        return this.xJunctTermFromPreds(preds, st, SmtUtils::or, this::getFalse);
    }

    private Term andTermFromPreds(Collection<IPredicate> preds, SmtUtils.SimplificationTechnique st) {
        return this.xJunctTermFromPreds(preds, st, SmtUtils::and, this::getTrue);
    }

    private Term xJunctTermFromPreds(Collection<IPredicate> preds, SmtUtils.SimplificationTechnique st, BiFunction<Script, Collection<Term>, Term> funCreateXJunct, Supplier<Term> funGetNeutralElement) {
        List<Term> terms = preds.stream().map(IPredicate::getFormula).collect(Collectors.toList());
        return this.xJunctTerm(terms, st, funCreateXJunct, funGetNeutralElement);
    }

    private Term orTerm(Collection<Term> preds, SmtUtils.SimplificationTechnique st) {
        return this.xJunctTerm(preds, st, SmtUtils::or, this::getFalse);
    }

    private Term andTerm(Collection<Term> preds, SmtUtils.SimplificationTechnique st) {
        return this.xJunctTerm(preds, st, SmtUtils::and, this::getTrue);
    }

    private Term xJunctTerm(Collection<Term> terms, SmtUtils.SimplificationTechnique st, BiFunction<Script, Collection<Term>, Term> funCreateXJunct, Supplier<Term> funGetNeutralElement) {
        if (terms.stream().anyMatch(this::isDontCare)) {
            return this.mDontCareTerm;
        }
        if (terms.isEmpty()) {
            return funGetNeutralElement.get();
        }
        Term xJunct = funCreateXJunct.apply(this.mScript, terms);
        if (st != SmtUtils.SimplificationTechnique.NONE) {
            return SmtUtils.simplify((ManagedScript)this.mMgdScript, (Term)xJunct, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)st);
        }
        return xJunct;
    }

    private Term notTerm(IPredicate p) {
        if (this.isDontCare(p)) {
            return this.mDontCareTerm;
        }
        return SmtUtils.not((Script)this.mScript, (Term)p.getFormula());
    }

    private Term getTrue() {
        return this.mScript.term("true", new Term[0]);
    }

    private Term getFalse() {
        return this.mScript.term("false", new Term[0]);
    }

    public <T extends IPredicate> T construct(PredicateConstructorFunction<T> funPredicateConstructor) {
        return funPredicateConstructor.construct(this.constructFreshSerialNumber(), this.mScript);
    }

    public static interface PredicateConstructorFunction<T extends IPredicate> {
        public T construct(int var1, Script var2);
    }
}

