/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class CallReturnPyramideInstanceProvider {
    private final ManagedScript mMgdScript;
    private final BeforeCallCoincidingInstancesClassifier mBeforeCallCoincidingInstancesClassifier;
    private final AfterCallCoincidingInstancesClassifier mAfterCallCoincidingInstancesClassifier;
    private final BeforeReturnCoincidingInstancesClassifier mBeforeReturnCoincidingInstancesClassifier;
    private final AfterReturnCoincidingInstancesClassifier mAfterReturnCoincidingInstancesClassifier;
    private final FourWayInstanceProvider mInstanceProvider;
    private final Set<IProgramVar> mVarsAssignedOnReturn;
    private final Set<IProgramVar> mCalleeInParams;
    private final Set<IProgramNonOldVar> mModifiableGlobals;
    private final Set<TermVariable> mFreshTermVariables = new HashSet<TermVariable>();

    public CallReturnPyramideInstanceProvider(ManagedScript mgdScript, Set<IProgramVar> varsAssignedOnReturn, Set<IProgramVar> calleeInParams, Set<IProgramNonOldVar> modifiableGlobals, Instance nonAuxVarInstance) {
        this.mMgdScript = mgdScript;
        this.mVarsAssignedOnReturn = varsAssignedOnReturn;
        this.mCalleeInParams = calleeInParams;
        this.mModifiableGlobals = modifiableGlobals;
        this.mBeforeCallCoincidingInstancesClassifier = new BeforeCallCoincidingInstancesClassifier();
        this.mAfterCallCoincidingInstancesClassifier = new AfterCallCoincidingInstancesClassifier();
        this.mBeforeReturnCoincidingInstancesClassifier = new BeforeReturnCoincidingInstancesClassifier();
        this.mAfterReturnCoincidingInstancesClassifier = new AfterReturnCoincidingInstancesClassifier();
        this.mInstanceProvider = new FourWayInstanceProvider(nonAuxVarInstance);
    }

    public Term getInstance(IProgramVar pv, Instance instance) {
        switch (instance) {
            case BEFORE_CALL: {
                return this.mInstanceProvider.getInstance(pv, this.mBeforeCallCoincidingInstancesClassifier.getInstances(pv));
            }
            case AFTER_CALL: {
                return this.mInstanceProvider.getInstance(pv, this.mAfterCallCoincidingInstancesClassifier.getInstances(pv));
            }
            case BEFORE_RETURN: {
                return this.mInstanceProvider.getInstance(pv, this.mBeforeReturnCoincidingInstancesClassifier.getInstances(pv));
            }
            case AFTER_RETURN: {
                return this.mInstanceProvider.getInstance(pv, this.mAfterReturnCoincidingInstancesClassifier.getInstances(pv));
            }
        }
        throw new AssertionError((Object)("unknown value " + (Object)((Object)instance)));
    }

    public boolean isWrittenOnReturn(IProgramVar pv) {
        return this.mVarsAssignedOnReturn.contains(pv);
    }

    public boolean isModifiableByCallee(IProgramNonOldVar pv) {
        return this.mModifiableGlobals.contains(pv);
    }

    public boolean inInParam(ILocalProgramVar pv) {
        return this.mCalleeInParams.contains(pv);
    }

    public Set<TermVariable> getFreshTermVariables() {
        return this.mFreshTermVariables;
    }

    private class AfterCallCoincidingInstancesClassifier
    extends CoincidingInstancesClassifier {
        private AfterCallCoincidingInstancesClassifier() {
        }

        @Override
        public EnumSet<Instance> getInstancesLocal(ILocalProgramVar pv) {
            if (CallReturnPyramideInstanceProvider.this.inInParam(pv)) {
                return EnumSet.of(Instance.AFTER_CALL, Instance.BEFORE_RETURN);
            }
            return EnumSet.of(Instance.AFTER_CALL);
        }

        @Override
        public EnumSet<Instance> getInstancesGlobalNonOld(IProgramNonOldVar pv) {
            if (CallReturnPyramideInstanceProvider.this.isModifiableByCallee(pv)) {
                return EnumSet.of(Instance.AFTER_CALL);
            }
            if (CallReturnPyramideInstanceProvider.this.isWrittenOnReturn(pv)) {
                return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_CALL, Instance.BEFORE_RETURN);
            }
            return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_CALL, Instance.BEFORE_RETURN, Instance.AFTER_RETURN);
        }

        @Override
        public EnumSet<Instance> getInstancesGlobalOld(IProgramOldVar pv) {
            return EnumSet.of(Instance.AFTER_CALL, Instance.BEFORE_RETURN);
        }
    }

    private class AfterReturnCoincidingInstancesClassifier
    extends CoincidingInstancesClassifier {
        private AfterReturnCoincidingInstancesClassifier() {
        }

        @Override
        public EnumSet<Instance> getInstancesLocal(ILocalProgramVar pv) {
            if (CallReturnPyramideInstanceProvider.this.isWrittenOnReturn(pv)) {
                return EnumSet.of(Instance.AFTER_RETURN);
            }
            return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_RETURN);
        }

        @Override
        public EnumSet<Instance> getInstancesGlobalNonOld(IProgramNonOldVar pv) {
            if (CallReturnPyramideInstanceProvider.this.isModifiableByCallee(pv)) {
                if (CallReturnPyramideInstanceProvider.this.isWrittenOnReturn(pv)) {
                    return EnumSet.of(Instance.AFTER_RETURN);
                }
                return EnumSet.of(Instance.BEFORE_RETURN, Instance.AFTER_RETURN);
            }
            if (CallReturnPyramideInstanceProvider.this.isWrittenOnReturn(pv)) {
                return EnumSet.of(Instance.AFTER_RETURN);
            }
            return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_CALL, Instance.BEFORE_RETURN, Instance.AFTER_RETURN);
        }

        @Override
        public EnumSet<Instance> getInstancesGlobalOld(IProgramOldVar pv) {
            return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_RETURN);
        }
    }

    private class BeforeCallCoincidingInstancesClassifier
    extends CoincidingInstancesClassifier {
        private BeforeCallCoincidingInstancesClassifier() {
        }

        @Override
        public EnumSet<Instance> getInstancesLocal(ILocalProgramVar pv) {
            if (CallReturnPyramideInstanceProvider.this.isWrittenOnReturn(pv)) {
                return EnumSet.of(Instance.BEFORE_CALL);
            }
            return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_RETURN);
        }

        @Override
        public EnumSet<Instance> getInstancesGlobalNonOld(IProgramNonOldVar pv) {
            if (CallReturnPyramideInstanceProvider.this.isModifiableByCallee(pv)) {
                return EnumSet.of(Instance.BEFORE_CALL);
            }
            if (CallReturnPyramideInstanceProvider.this.isWrittenOnReturn(pv)) {
                return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_CALL, Instance.BEFORE_RETURN);
            }
            return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_CALL, Instance.BEFORE_RETURN, Instance.AFTER_RETURN);
        }

        @Override
        public EnumSet<Instance> getInstancesGlobalOld(IProgramOldVar pv) {
            return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_RETURN);
        }
    }

    private class BeforeReturnCoincidingInstancesClassifier
    extends CoincidingInstancesClassifier {
        private BeforeReturnCoincidingInstancesClassifier() {
        }

        @Override
        public EnumSet<Instance> getInstancesLocal(ILocalProgramVar pv) {
            if (CallReturnPyramideInstanceProvider.this.inInParam(pv)) {
                return EnumSet.of(Instance.AFTER_CALL, Instance.BEFORE_RETURN);
            }
            return EnumSet.of(Instance.BEFORE_RETURN);
        }

        @Override
        public EnumSet<Instance> getInstancesGlobalNonOld(IProgramNonOldVar pv) {
            if (CallReturnPyramideInstanceProvider.this.isModifiableByCallee(pv)) {
                if (CallReturnPyramideInstanceProvider.this.isWrittenOnReturn(pv)) {
                    return EnumSet.of(Instance.BEFORE_RETURN);
                }
                return EnumSet.of(Instance.BEFORE_RETURN, Instance.AFTER_RETURN);
            }
            if (CallReturnPyramideInstanceProvider.this.isWrittenOnReturn(pv)) {
                return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_CALL, Instance.BEFORE_RETURN);
            }
            return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_CALL, Instance.BEFORE_RETURN, Instance.AFTER_RETURN);
        }

        @Override
        public EnumSet<Instance> getInstancesGlobalOld(IProgramOldVar pv) {
            return EnumSet.of(Instance.AFTER_CALL, Instance.BEFORE_RETURN);
        }
    }

    private abstract class CoincidingInstancesClassifier {
        private CoincidingInstancesClassifier() {
        }

        public EnumSet<Instance> getInstances(IProgramVar pv) {
            if (pv instanceof ILocalProgramVar) {
                return this.getInstancesLocal((ILocalProgramVar)pv);
            }
            if (pv instanceof IProgramNonOldVar) {
                return this.getInstancesGlobalNonOld((IProgramNonOldVar)pv);
            }
            if (pv instanceof IProgramOldVar) {
                return this.getInstancesGlobalOld((IProgramOldVar)pv);
            }
            throw new AssertionError((Object)"unknown kind of variable");
        }

        public abstract EnumSet<Instance> getInstancesLocal(ILocalProgramVar var1);

        public abstract EnumSet<Instance> getInstancesGlobalNonOld(IProgramNonOldVar var1);

        public abstract EnumSet<Instance> getInstancesGlobalOld(IProgramOldVar var1);
    }

    private class DefaultTermVariableProvider
    implements ConstructionCache.IValueConstruction<IProgramVar, TermVariable> {
        private DefaultTermVariableProvider() {
        }

        public TermVariable constructValue(IProgramVar key) {
            return key.getTermVariable();
        }
    }

    private class FourWayInstanceProvider {
        private final Instance mPriorityInstance;
        private final EnumMap<Instance, ConstructionCache<IProgramVar, TermVariable>> mInstanceProviders = new EnumMap(Instance.class);

        public FourWayInstanceProvider(Instance priorityInstance) {
            this.mPriorityInstance = priorityInstance;
            Instance[] instanceArray = Instance.values();
            int n = instanceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Instance instance = instanceArray[n2];
                if (instance == this.mPriorityInstance) {
                    this.mInstanceProviders.put(instance, (ConstructionCache<IProgramVar, TermVariable>)new ConstructionCache((ConstructionCache.IValueConstruction)new DefaultTermVariableProvider()));
                } else {
                    this.mInstanceProviders.put(instance, (ConstructionCache<IProgramVar, TermVariable>)new ConstructionCache((ConstructionCache.IValueConstruction)new FreshTermVariableProvider(instance)));
                }
                ++n2;
            }
        }

        private TermVariable getInstance(IProgramVar pv, EnumSet<Instance> allInstances) {
            if (allInstances.contains((Object)this.mPriorityInstance)) {
                return (TermVariable)this.mInstanceProviders.get((Object)this.mPriorityInstance).getOrConstruct((Object)pv);
            }
            return (TermVariable)this.mInstanceProviders.get(allInstances.iterator().next()).getOrConstruct((Object)pv);
        }
    }

    private class FreshTermVariableProvider
    implements ConstructionCache.IValueConstruction<IProgramVar, TermVariable> {
        private final Instance mInstance;

        public FreshTermVariableProvider(Instance instance) {
            this.mInstance = instance;
        }

        public TermVariable constructValue(IProgramVar key) {
            String name = String.valueOf(key.getGloballyUniqueId()) + "_" + this.mInstance.toString();
            TermVariable freshTv = CallReturnPyramideInstanceProvider.this.mMgdScript.constructFreshTermVariable(name, key.getTermVariable().getSort());
            CallReturnPyramideInstanceProvider.this.mFreshTermVariables.add(freshTv);
            return freshTv;
        }
    }

    public static enum Instance {
        BEFORE_CALL,
        AFTER_CALL,
        BEFORE_RETURN,
        AFTER_RETURN;

    }
}

