/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.SPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class HoareAnnotation
extends SPredicate {
    private static final String KEY = HoareAnnotation.class.getSimpleName();
    private static final long serialVersionUID = 72852101509650437L;
    private final ManagedScript mMgdScript;
    @Visualizable
    private final boolean mIsUnknown = false;
    private final List<Term> mInvariants = new ArrayList<Term>();

    public HoareAnnotation(IcfgLocation programPoint, int serialNumber, PredicateFactory predicateFactory, ManagedScript mgdScript) {
        super(programPoint, serialNumber, new String[]{programPoint.getProcedure()}, mgdScript.getScript().term("true", new Term[0]), new HashSet<IProgramVar>(), null);
        this.mMgdScript = mgdScript;
    }

    public void addInvariant(IPredicate pred) {
        this.mVars.addAll(pred.getVars());
        this.mInvariants.add(pred.getFormula());
    }

    @Override
    public Term getFormula() {
        return SmtUtils.and((Script)this.mMgdScript.getScript(), this.mInvariants);
    }

    @Override
    public Term getClosedFormula() {
        return PredicateUtils.computeClosedFormula(this.getFormula(), this.mVars, this.mMgdScript);
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    public void annotate(IElement node) {
        if (node == null) {
            return;
        }
        node.getPayload().getAnnotations().put(KEY, this);
    }

    public static HoareAnnotation getAnnotation(IElement node) {
        IAnnotations annot;
        IPayload payload;
        if (node != null && node.hasPayload() && (payload = node.getPayload()).hasAnnotation() && (annot = (IAnnotations)payload.getAnnotations().get(KEY)) != null) {
            return (HoareAnnotation)annot;
        }
        return null;
    }
}

