/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.HoareAnnotation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.MLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateWithHistory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ProdState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.SPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsProc;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PredicateFactory
extends BasicPredicateFactory {
    public PredicateFactory(IUltimateServiceProvider services, ManagedScript mgdScript, IIcfgSymbolTable symbolTable) {
        super(services, mgdScript, symbolTable);
    }

    public PredicateWithHistory newPredicateWithHistory(IcfgLocation pp, Term term, Map<Integer, Term> history) {
        TermVarsProc tvp = this.constructTermVarsProc(term);
        PredicateWithHistory pred = new PredicateWithHistory(pp, this.constructFreshSerialNumber(), tvp.getProcedures(), tvp.getFormula(), tvp.getVars(), tvp.getClosedFormula(), history);
        return pred;
    }

    public SPredicate newSPredicate(IcfgLocation pp, Term term) {
        TermVarsProc termVarsProc = this.constructTermVarsProc(term);
        return this.newSPredicate(pp, termVarsProc);
    }

    SPredicate newSPredicate(IcfgLocation pp, TermVarsProc termVarsProc) {
        SPredicate pred = new SPredicate(pp, this.constructFreshSerialNumber(), termVarsProc.getProcedures(), termVarsProc.getFormula(), termVarsProc.getVars(), termVarsProc.getClosedFormula());
        return pred;
    }

    public ISLPredicate newEmptyStackPredicate() {
        IcfgLocation pp = new IcfgLocation(NoCallerDebugIdentifier.INSTANCE, "noCaller");
        return this.newSPredicate(pp, new TermVarsProc(this.mEmptyStackTerm, EMPTY_VARS, NO_PROCEDURE, this.mEmptyStackTerm));
    }

    public MLPredicate newMLPredicate(IcfgLocation[] programPoints, Term term) {
        TermVarsProc termVarsProc = this.constructTermVarsProc(term);
        MLPredicate predicate = new MLPredicate(programPoints, this.constructFreshSerialNumber(), termVarsProc.getProcedures(), termVarsProc.getFormula(), termVarsProc.getVars(), termVarsProc.getClosedFormula());
        return predicate;
    }

    public IPredicate newMLPredicate(IcfgLocation[] programPoints, ArrayList<Term> terms) {
        IPredicate conjunction = this.andT(terms);
        return this.newMLPredicate(programPoints, conjunction.getFormula());
    }

    public MLPredicate newMLDontCarePredicate(IcfgLocation[] programPoints) {
        return this.newMLPredicate(programPoints, this.mDontCareTerm);
    }

    public ProdState getNewProdState(List<IPredicate> programPoints) {
        return new ProdState(this.constructFreshSerialNumber(), programPoints, this.mScript.term("true", new Term[0]), new HashSet<IProgramVar>(0));
    }

    public HoareAnnotation getNewHoareAnnotation(IcfgLocation pp, ModifiableGlobalsTable modifiableGlobalsTable) {
        return new HoareAnnotation(pp, this.constructFreshSerialNumber(), this, this.mMgdScript);
    }

    private static final class NoCallerDebugIdentifier
    extends DebugIdentifier {
        public static final NoCallerDebugIdentifier INSTANCE = new NoCallerDebugIdentifier();

        private NoCallerDebugIdentifier() {
        }

        @Override
        public String toString() {
            return "noCaller";
        }
    }
}

