/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ITransitionRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.CallReturnPyramideInstanceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IAbstractPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IDomainSpecificOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PredicateTransformer<C, P extends IAbstractPredicate, R extends ITransitionRelation> {
    private final ManagedScript mMgdScript;
    private final IDomainSpecificOperationProvider<C, P, R> mOperationProvider;

    public PredicateTransformer(ManagedScript mgdScript, IDomainSpecificOperationProvider<C, P, R> operationProvider) {
        this.mMgdScript = mgdScript;
        this.mOperationProvider = operationProvider;
    }

    public C strongestPostcondition(P p, R transRel) {
        C constraint = this.mOperationProvider.getConstraint(p);
        if (this.mOperationProvider.isConstraintUnsatisfiable(constraint)) {
            return constraint;
        }
        HashSet<TermVariable> varsToProject = new HashSet<TermVariable>();
        ConstructionCache.IValueConstruction substituentConstruction = pv -> {
            TermVariable result = PredicateTransformer.constructFreshTermVariable(this.mMgdScript, pv);
            varsToProject.add(result);
            return result;
        };
        ConstructionCache termVariablesForPredecessor = new ConstructionCache(substituentConstruction);
        HashMap<Term, Term> substitutionForTransFormula = new HashMap<Term, Term>();
        HashMap<Term, Term> substitutionForPredecessor = new HashMap<Term, Term>();
        for (Map.Entry<IProgramVar, TermVariable> entry : transRel.getInVars().entrySet()) {
            IProgramVar pv2 = entry.getKey();
            if (entry.getValue() == transRel.getOutVars().get(pv2)) continue;
            TermVariable substituent = (TermVariable)termVariablesForPredecessor.getOrConstruct((Object)pv2);
            substitutionForTransFormula.put((Term)entry.getValue(), (Term)substituent);
            if (!p.getVars().contains(pv2)) continue;
            substitutionForPredecessor.put((Term)pv2.getTermVariable(), (Term)substituent);
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : transRel.getOutVars().entrySet()) {
            substitutionForTransFormula.put((Term)entry.getValue(), (Term)entry.getKey().getTermVariable());
            if (transRel.getInVars().containsKey(entry.getKey()) || !p.getVars().contains(entry.getKey())) continue;
            TermVariable substituent = (TermVariable)termVariablesForPredecessor.getOrConstruct((Object)entry.getKey());
            substitutionForPredecessor.put((Term)entry.getKey().getTermVariable(), (Term)substituent);
        }
        C renamedRelationConstraint = this.mOperationProvider.renameVariables(substitutionForTransFormula, this.mOperationProvider.getConstraintFromTransitionRelation(transRel));
        C renamedPredecessor = this.mOperationProvider.renameVariables(substitutionForPredecessor, constraint);
        Object conjunction = this.mOperationProvider.constructConjunction(PredicateTransformer.toList(renamedRelationConstraint, renamedPredecessor));
        varsToProject.addAll(transRel.getAuxVars());
        return (C)this.mOperationProvider.projectExistentially(varsToProject, conjunction);
    }

    public C strongestPostconditionCall(P callPred, R localVarAssignments, R globalVarAssignments, R oldVarAssignments, Set<IProgramNonOldVar> modifiableGlobalsOfCalledProcedure) {
        if (!globalVarAssignments.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"globalVarsAssignments must not contain auxVars");
        }
        if (!oldVarAssignments.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"oldVarAssignments must not contain auxVars");
        }
        CallReturnPyramideInstanceProvider crpip = new CallReturnPyramideInstanceProvider(this.mMgdScript, Collections.emptySet(), localVarAssignments.getAssignedVars(), modifiableGlobalsOfCalledProcedure, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL);
        C callPredTerm = this.renamePredicateToInstance(callPred, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, crpip);
        C localVarAssignmentsTerm = this.renameRelationToInstances(localVarAssignments, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, crpip);
        C oldVarsAssignmentTerm = this.renameRelationToInstances(oldVarAssignments, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, crpip);
        C globalVarsAssignmentTerm = this.renameRelationToInstances(globalVarAssignments, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, crpip);
        Object result = this.mOperationProvider.constructConjunction(PredicateTransformer.toList(localVarAssignmentsTerm, oldVarsAssignmentTerm, globalVarsAssignmentTerm, callPredTerm));
        return (C)this.mOperationProvider.projectExistentially(this.addAuxVarsOfCall(localVarAssignments, crpip.getFreshTermVariables()), result);
    }

    public C modularPostconditionCall(P callPred, R globalVarAssignments, Set<IProgramNonOldVar> modifiableGlobalsOfCalledProcedure) {
        if (!globalVarAssignments.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"globalVarsAssignments must not contain auxVars");
        }
        CallReturnPyramideInstanceProvider crpip = new CallReturnPyramideInstanceProvider(this.mMgdScript, Collections.emptySet(), Collections.emptySet(), modifiableGlobalsOfCalledProcedure, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL);
        C callPredTerm = this.renamePredicateToInstance(callPred, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, crpip);
        C globalVarsAssignmentTerm = this.renameRelationToInstances(globalVarAssignments, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, crpip);
        Object result = this.mOperationProvider.constructConjunction(PredicateTransformer.toList(globalVarsAssignmentTerm, callPredTerm));
        return (C)this.mOperationProvider.projectExistentially(crpip.getFreshTermVariables(), result);
    }

    public C strongestPostconditionReturn(P returnPred, P callPred, R returnTF, R callTF, R oldVarAssignments, Set<IProgramNonOldVar> modifiableGlobals) {
        if (!returnTF.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"TransFormula of return must not contain auxVars");
        }
        if (!oldVarAssignments.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"oldVarAssignments must not contain auxVars");
        }
        CallReturnPyramideInstanceProvider crpip = new CallReturnPyramideInstanceProvider(this.mMgdScript, returnTF.getAssignedVars(), callTF.getAssignedVars(), modifiableGlobals, CallReturnPyramideInstanceProvider.Instance.AFTER_RETURN);
        C callPredTerm = this.renamePredicateToInstance(callPred, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, crpip);
        C returnPredTerm = this.renamePredicateToInstance(returnPred, CallReturnPyramideInstanceProvider.Instance.BEFORE_RETURN, crpip);
        C callTfTerm = this.renameRelationToInstances(callTF, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, crpip);
        C oldVarsAssignmentTerm = this.renameRelationToInstances(oldVarAssignments, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, crpip);
        C returnTfTerm = this.renameRelationToInstances(returnTF, CallReturnPyramideInstanceProvider.Instance.BEFORE_RETURN, CallReturnPyramideInstanceProvider.Instance.AFTER_RETURN, crpip);
        Object result = this.mOperationProvider.constructConjunction(PredicateTransformer.toList(callTfTerm, oldVarsAssignmentTerm, returnTfTerm, callPredTerm, returnPredTerm));
        return (C)this.mOperationProvider.projectExistentially(this.addAuxVarsOfCall(callTF, crpip.getFreshTermVariables()), result);
    }

    public C weakestPrecondition(P p, R tf) {
        C constraint = this.mOperationProvider.getConstraint(p);
        if (this.mOperationProvider.isConstraintValid(constraint)) {
            return constraint;
        }
        PreRenaming pRename = new PreRenaming(this, p, tf);
        C renamedRelationConstraint = this.mOperationProvider.renameVariables(pRename.getSubstitutionForRelation(), this.mOperationProvider.getConstraintFromTransitionRelation(tf));
        C renamedPredecessor = this.mOperationProvider.renameVariables(pRename.getSubstitutionForSuccessor(), constraint);
        Object disjunction = this.mOperationProvider.constructDisjunction(PredicateTransformer.toList(this.mOperationProvider.constructNegation(renamedRelationConstraint), renamedPredecessor));
        return (C)this.mOperationProvider.projectUniversally(pRename.getVarsToProject(), disjunction);
    }

    public C weakestPreconditionCall(P callSucc, R callTF, R globalVarsAssignments, R oldVarAssignments, Set<IProgramNonOldVar> modifiableGlobals) {
        if (!globalVarsAssignments.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"globalVarsAssignments must not contain auxVars");
        }
        if (!oldVarAssignments.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"oldVarAssignments must not contain auxVars");
        }
        CallReturnPyramideInstanceProvider crpip = new CallReturnPyramideInstanceProvider(this.mMgdScript, Collections.emptySet(), callTF.getAssignedVars(), modifiableGlobals, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL);
        C callSuccTerm = this.renamePredicateToInstance(callSucc, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, crpip);
        C callTfTerm = this.renameRelationToInstances(callTF, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, crpip);
        C oldVarsAssignmentTerm = this.renameRelationToInstances(oldVarAssignments, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, crpip);
        C globalVarsAssignmentTerm = this.renameRelationToInstances(globalVarsAssignments, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, crpip);
        Object result = this.mOperationProvider.constructDisjunction(PredicateTransformer.toList(this.mOperationProvider.constructNegation(callTfTerm), this.mOperationProvider.constructNegation(oldVarsAssignmentTerm), this.mOperationProvider.constructNegation(globalVarsAssignmentTerm), callSuccTerm));
        return (C)this.mOperationProvider.projectUniversally(this.addAuxVarsOfCall(callTF, crpip.getFreshTermVariables()), result);
    }

    public C weakestPreconditionReturn(P returnSucc, P callPred, R returnTF, R callTF, R oldVarAssignments, Set<IProgramNonOldVar> modifiableGlobals) {
        if (!returnTF.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"TransFormula of return must not contain auxVars");
        }
        if (!oldVarAssignments.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"oldVarAssignments must not contain auxVars");
        }
        CallReturnPyramideInstanceProvider crpip = new CallReturnPyramideInstanceProvider(this.mMgdScript, returnTF.getAssignedVars(), callTF.getAssignedVars(), modifiableGlobals, CallReturnPyramideInstanceProvider.Instance.BEFORE_RETURN);
        C callPredTerm = this.renamePredicateToInstance(callPred, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, crpip);
        C returnSuccTerm = this.renamePredicateToInstance(returnSucc, CallReturnPyramideInstanceProvider.Instance.AFTER_RETURN, crpip);
        C callTfTerm = this.renameRelationToInstances(callTF, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, crpip);
        C oldVarsAssignmentTerm = this.renameRelationToInstances(oldVarAssignments, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, crpip);
        C returnTfTerm = this.renameRelationToInstances(returnTF, CallReturnPyramideInstanceProvider.Instance.BEFORE_RETURN, CallReturnPyramideInstanceProvider.Instance.AFTER_RETURN, crpip);
        Object result = this.mOperationProvider.constructDisjunction(PredicateTransformer.toList(this.mOperationProvider.constructNegation(callTfTerm), this.mOperationProvider.constructNegation(oldVarsAssignmentTerm), this.mOperationProvider.constructNegation(returnTfTerm), this.mOperationProvider.constructNegation(callPredTerm), returnSuccTerm));
        return (C)this.mOperationProvider.projectUniversally(this.addAuxVarsOfCall(callTF, crpip.getFreshTermVariables()), result);
    }

    public C pre(P p, R tf) {
        C constraint = this.mOperationProvider.getConstraint(p);
        if (this.mOperationProvider.isConstraintUnsatisfiable(constraint)) {
            return constraint;
        }
        PreRenaming pRename = new PreRenaming(this, p, tf);
        C renamedRelationConstraint = this.mOperationProvider.renameVariables(pRename.getSubstitutionForRelation(), this.mOperationProvider.getConstraintFromTransitionRelation(tf));
        C renamedPredecessor = this.mOperationProvider.renameVariables(pRename.getSubstitutionForSuccessor(), constraint);
        Object conjunction = this.mOperationProvider.constructConjunction(PredicateTransformer.toList(renamedRelationConstraint, renamedPredecessor));
        return (C)this.mOperationProvider.projectExistentially(pRename.getVarsToProject(), conjunction);
    }

    public C preCall(P callSucc, R callTF, R globalVarsAssignments, R oldVarAssignments, Set<IProgramNonOldVar> modifiableGlobals) {
        if (!globalVarsAssignments.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"globalVarsAssignments must not contain auxVars");
        }
        if (!oldVarAssignments.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"oldVarAssignments must not contain auxVars");
        }
        CallReturnPyramideInstanceProvider crpip = new CallReturnPyramideInstanceProvider(this.mMgdScript, Collections.emptySet(), callTF.getAssignedVars(), modifiableGlobals, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL);
        C callSuccTerm = this.renamePredicateToInstance(callSucc, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, crpip);
        C callTfTerm = this.renameRelationToInstances(callTF, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, crpip);
        C oldVarsAssignmentTerm = this.renameRelationToInstances(oldVarAssignments, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, crpip);
        C globalVarsAssignmentTerm = this.renameRelationToInstances(globalVarsAssignments, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, crpip);
        Object result = this.mOperationProvider.constructConjunction(PredicateTransformer.toList(callTfTerm, oldVarsAssignmentTerm, globalVarsAssignmentTerm, callSuccTerm));
        return (C)this.mOperationProvider.projectExistentially(this.addAuxVarsOfCall(callTF, crpip.getFreshTermVariables()), result);
    }

    public C preReturn(P returnSucc, P callPred, R returnTF, R callTF, R oldVarAssignments, Set<IProgramNonOldVar> modifiableGlobals) {
        if (!returnTF.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"TransFormula of return must not contain auxVars");
        }
        if (!oldVarAssignments.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"oldVarAssignments must not contain auxVars");
        }
        CallReturnPyramideInstanceProvider crpip = new CallReturnPyramideInstanceProvider(this.mMgdScript, returnTF.getAssignedVars(), callTF.getAssignedVars(), modifiableGlobals, CallReturnPyramideInstanceProvider.Instance.BEFORE_RETURN);
        C callPredTerm = this.renamePredicateToInstance(callPred, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, crpip);
        C returnSuccTerm = this.renamePredicateToInstance(returnSucc, CallReturnPyramideInstanceProvider.Instance.AFTER_RETURN, crpip);
        C callTfTerm = this.renameRelationToInstances(callTF, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, crpip);
        C oldVarsAssignmentTerm = this.renameRelationToInstances(oldVarAssignments, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, crpip);
        C returnTfTerm = this.renameRelationToInstances(returnTF, CallReturnPyramideInstanceProvider.Instance.BEFORE_RETURN, CallReturnPyramideInstanceProvider.Instance.AFTER_RETURN, crpip);
        Object result = this.mOperationProvider.constructConjunction(PredicateTransformer.toList(callTfTerm, oldVarsAssignmentTerm, returnTfTerm, callPredTerm, returnSuccTerm));
        return (C)this.mOperationProvider.projectExistentially(this.addAuxVarsOfCall(callTF, crpip.getFreshTermVariables()), result);
    }

    private C renamePredicateToInstance(P p, CallReturnPyramideInstanceProvider.Instance instance, CallReturnPyramideInstanceProvider crpip) {
        HashMap<Term, Term> substitution = new HashMap<Term, Term>();
        for (IProgramVar pv : p.getVars()) {
            substitution.put((Term)pv.getTermVariable(), crpip.getInstance(pv, instance));
        }
        C result = this.mOperationProvider.renameVariables(substitution, this.mOperationProvider.getConstraint(p));
        return result;
    }

    private C renameRelationToInstances(R tf, CallReturnPyramideInstanceProvider.Instance preInstance, CallReturnPyramideInstanceProvider.Instance succInstance, CallReturnPyramideInstanceProvider crpip) {
        HashMap<Term, Term> substitutionMapping = new HashMap<Term, Term>();
        for (Map.Entry<IProgramVar, TermVariable> entry : tf.getOutVars().entrySet()) {
            substitutionMapping.put((Term)entry.getValue(), crpip.getInstance(entry.getKey(), succInstance));
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : tf.getInVars().entrySet()) {
            substitutionMapping.put((Term)entry.getValue(), crpip.getInstance(entry.getKey(), preInstance));
        }
        C result = this.mOperationProvider.renameVariables(substitutionMapping, this.mOperationProvider.getConstraintFromTransitionRelation(tf));
        return result;
    }

    private Set<TermVariable> addAuxVarsOfCall(R callTF, Set<TermVariable> inputVarsToProjectAway) {
        Set<TermVariable> resultingVarsToProjectAway;
        if (callTF.getAuxVars().isEmpty()) {
            resultingVarsToProjectAway = inputVarsToProjectAway;
        } else {
            resultingVarsToProjectAway = new HashSet<TermVariable>(inputVarsToProjectAway);
            resultingVarsToProjectAway.addAll(callTF.getAuxVars());
        }
        return resultingVarsToProjectAway;
    }

    @SafeVarargs
    private static <E> List<E> toList(E ... elems) {
        return Arrays.asList(elems);
    }

    private static TermVariable constructFreshTermVariable(ManagedScript freshVarConstructor, IProgramVar pv) {
        return freshVarConstructor.constructFreshTermVariable(pv.getGloballyUniqueId(), pv.getTermVariable().getSort());
    }

    private static final class PreRenaming {
        private final Set<TermVariable> mVarsToProject = new HashSet<TermVariable>();
        private final Map<Term, Term> mSubstitutionForRelation;
        private final Map<Term, Term> mSubstitutionForSuccessor;
        final /* synthetic */ PredicateTransformer this$0;

        private PreRenaming(P p, R tf) {
            this.this$0 = var1_1;
            ConstructionCache.IValueConstruction substituentConstruction = pv -> {
                TermVariable result = PredicateTransformer.constructFreshTermVariable(this.this$0.mMgdScript, pv);
                this.mVarsToProject.add(result);
                return result;
            };
            ConstructionCache termVariablesForSuccessor = new ConstructionCache(substituentConstruction);
            this.mSubstitutionForRelation = new HashMap<Term, Term>();
            this.mSubstitutionForSuccessor = new HashMap<Term, Term>();
            for (Map.Entry<IProgramVar, TermVariable> entry : tf.getOutVars().entrySet()) {
                IProgramVar pv2 = entry.getKey();
                if (entry.getValue() == tf.getInVars().get(pv2)) continue;
                TermVariable substituent = (TermVariable)termVariablesForSuccessor.getOrConstruct((Object)pv2);
                this.mSubstitutionForRelation.put((Term)entry.getValue(), (Term)substituent);
                if (!p.getVars().contains(pv2)) continue;
                this.mSubstitutionForSuccessor.put((Term)pv2.getTermVariable(), (Term)substituent);
            }
            for (Map.Entry<IProgramVar, TermVariable> entry : tf.getInVars().entrySet()) {
                this.mSubstitutionForRelation.put((Term)entry.getValue(), (Term)entry.getKey().getTermVariable());
                if (tf.getOutVars().containsKey(entry.getKey()) || !p.getVars().contains(entry.getKey())) continue;
                TermVariable substituent = (TermVariable)termVariablesForSuccessor.getOrConstruct((Object)entry.getKey());
                this.mSubstitutionForSuccessor.put((Term)entry.getKey().getTermVariable(), (Term)substituent);
            }
            this.mVarsToProject.addAll(tf.getAuxVars());
        }

        public Set<TermVariable> getVarsToProject() {
            return this.mVarsToProject;
        }

        public Map<Term, Term> getSubstitutionForRelation() {
            return this.mSubstitutionForRelation;
        }

        public Map<Term, Term> getSubstitutionForSuccessor() {
            return this.mSubstitutionForSuccessor;
        }
    }
}

