/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PredicateTree<T extends IPredicate> {
    private final Term mTrue;
    private final Term mFalse;
    private final ManagedScript mScript;
    private INode<T> mRoot;

    public PredicateTree(ManagedScript script) {
        this(script, script.getScript().term("true", new Term[0]), script.getScript().term("false", new Term[0]));
    }

    public PredicateTree(ManagedScript script, Term trueTerm, Term falseTerm) {
        assert (script != null);
        this.mScript = script;
        this.mTrue = trueTerm;
        this.mFalse = falseTerm;
        this.mRoot = null;
    }

    public T unifyPredicate(T predicate) {
        INode<T> current;
        if (predicate == null) {
            return null;
        }
        if (this.mRoot == null) {
            this.mRoot = new Leaf(this, predicate);
            return predicate;
        }
        if (this.mRoot instanceof Leaf) {
            return this.unifyAndUpdate((Leaf)this.mRoot, null, predicate);
        }
        INode<T> last = current = this.mRoot;
        while (current != null) {
            INode<T> next = current.next(predicate);
            if (next != null) {
                last = current;
                current = next;
                continue;
            }
            return this.unifyAndUpdate((Leaf)current, (InnerNode)last, predicate);
        }
        throw new AssertionError((Object)"Should be unreachable");
    }

    public String toLogString() {
        if (this.mRoot == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        ArrayDeque<Pair> worklist = new ArrayDeque<Pair>();
        worklist.addFirst(new Pair((Object)"", this.mRoot));
        while (!worklist.isEmpty()) {
            Pair currentP = (Pair)worklist.removeFirst();
            INode current = (INode)currentP.getSecond();
            if (current instanceof Leaf) {
                sb.append((String)currentP.getFirst());
                sb.append(current.toString());
                sb.append("\n");
                continue;
            }
            InnerNode inner = (InnerNode)current;
            sb.append((String)currentP.getFirst());
            sb.append(inner.toString());
            sb.append("\n");
            String newId = String.valueOf((String)currentP.getFirst()) + " ";
            worklist.addFirst(new Pair((Object)newId, inner.mLeftChild));
            worklist.addFirst(new Pair((Object)newId, inner.mRightChild));
        }
        return sb.toString();
    }

    private T unifyAndUpdate(Leaf leaf, InnerNode parent, T predicate) {
        Pair unificationResult = this.unify(leaf.mPredicate, predicate);
        if (unificationResult.getFirst() == leaf.mPredicate) {
            return leaf.mPredicate;
        }
        InnerNode subtree = this.newSubTree(leaf, predicate, (Map)unificationResult.getSecond());
        if (parent == null) {
            this.mRoot = subtree;
        } else {
            boolean isLeftLeaf;
            boolean bl = isLeftLeaf = parent.mLeftChild == leaf;
            if (isLeftLeaf) {
                parent.mLeftChild = subtree;
            } else {
                parent.mRightChild = subtree;
            }
        }
        return predicate;
    }

    private Pair<T, Map<Term, Term>> unify(T leafPredicate, T predicateToUnify) {
        T localPred = leafPredicate;
        Term local = localPred.getClosedFormula();
        Term other = predicateToUnify.getClosedFormula();
        this.mScript.lock((Object)this);
        Term isEqual = this.mScript.term((Object)this, "distinct", new Term[]{local, other});
        this.mScript.push((Object)this, 1);
        try {
            this.mScript.assertTerm((Object)this, isEqual);
            Script.LBool result = this.mScript.checkSat((Object)this);
            if (result == Script.LBool.UNSAT) {
                Pair pair = new Pair(localPred, null);
                return pair;
            }
            if (result == Script.LBool.SAT) {
                HashSet<IProgramVar> vars = new HashSet<IProgramVar>();
                vars.addAll(predicateToUnify.getVars());
                vars.addAll(localPred.getVars());
                Set<Term> terms = vars.stream().map(IProgramVar::getDefaultConstant).collect(Collectors.toSet());
                Map witness = this.mScript.getScript().getValue(terms.toArray(new Term[terms.size()]));
                Pair pair = new Pair(predicateToUnify, (Object)witness);
                return pair;
            }
            throw new UnsupportedOperationException("Cannot handle case were solver cannot decide equality of predicates");
        }
        finally {
            this.mScript.pop((Object)this, 1);
            this.mScript.unlock((Object)this);
        }
    }

    private InnerNode newSubTree(Leaf oldLeaf, T newPredicate, Map<Term, Term> witness) {
        Leaf newLeaf = new Leaf(this, newPredicate);
        if (this.goLeft(witness, newPredicate)) {
            return new InnerNode(newLeaf, oldLeaf, witness);
        }
        return new InnerNode(oldLeaf, newLeaf, witness);
    }

    private boolean goLeft(Map<Term, Term> witness, T predicate) {
        Term result = Substitution.apply((ManagedScript)this.mScript, witness, (Term)predicate.getClosedFormula());
        return this.mTrue.equals(result);
    }

    @FunctionalInterface
    private static interface INode<T> {
        public INode<T> next(T var1);
    }

    private final class InnerNode
    implements INode<T> {
        private final Map<Term, Term> mWitness;
        private INode<T> mLeftChild;
        private INode<T> mRightChild;

        private InnerNode(INode<T> left, INode<T> right, Map<Term, Term> witness) {
            assert (witness != null && !witness.isEmpty());
            assert (left != null);
            assert (right != null);
            this.mWitness = witness;
            this.mLeftChild = left;
            this.mRightChild = right;
        }

        @Override
        public INode<T> next(T predicate) {
            if (PredicateTree.this.goLeft(this.mWitness, predicate)) {
                return this.mLeftChild;
            }
            return this.mRightChild;
        }

        public String toString() {
            return this.mWitness.toString();
        }
    }

    private static final class Leaf
    implements INode<T> {
        private final T mPredicate;
        final /* synthetic */ PredicateTree this$0;

        private Leaf(T pred) {
            this.this$0 = var1_1;
            assert (pred != null);
            this.mPredicate = pred;
        }

        @Override
        public INode<T> next(T predicate) {
            return null;
        }

        public String toString() {
            return this.mPredicate.toString();
        }
    }
}

