/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.MonolithicImplicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateCoverageChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifierStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsProc;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.ContainsQuantifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PrenexNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierSequence;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.CheckClosedTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.DebugMessage;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.PosetUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PredicateUnifier
implements IPredicateUnifier {
    protected final ManagedScript mMgdScript;
    private final BasicPredicateFactory mPredicateFactory;
    private final Map<Term, IPredicate> mTerm2Predicates;
    private final LinkedHashSet<IPredicate> mKnownPredicates = new LinkedHashSet();
    private final Map<IPredicate, IPredicate> mDeprecatedPredicates = new HashMap<IPredicate, IPredicate>();
    private final CoverageRelation mCoverageRelation = new CoverageRelation();
    protected final ILogger mLogger;
    protected final IUltimateServiceProvider mServices;
    private final Script mScript;
    private final MonolithicImplicationChecker mImplicationChecker;
    private final IIcfgSymbolTable mSymbolTable;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final SmtUtils.XnfConversionTechnique mXnfConversionTechnique;
    private final IPredicate mTruePredicate;
    private final IPredicate mFalsePredicate;
    private final PredicateUnifierStatisticsGenerator mPredicateUnifierBenchmarkGenerator = new PredicateUnifierStatisticsGenerator();

    public PredicateUnifier(ILogger logger, IUltimateServiceProvider services, ManagedScript mgdScript, BasicPredicateFactory predicateFactory, IIcfgSymbolTable symbolTable, SmtUtils.SimplificationTechnique simplificationTechnique, SmtUtils.XnfConversionTechnique xnfConversionTechnique, IPredicate ... initialPredicates) {
        IPredicate pred;
        this.mSimplificationTechnique = simplificationTechnique;
        this.mXnfConversionTechnique = xnfConversionTechnique;
        this.mMgdScript = mgdScript;
        this.mPredicateFactory = predicateFactory;
        this.mScript = mgdScript.getScript();
        this.mSymbolTable = symbolTable;
        this.mServices = services;
        this.mLogger = logger;
        this.mImplicationChecker = new MonolithicImplicationChecker(this.mServices, this.mMgdScript);
        this.mTerm2Predicates = new HashMap<Term, IPredicate>();
        Term trueTerm = this.mScript.term("true", new Term[0]);
        IPredicate truePredicate = null;
        Term falseTerm = this.mScript.term("false", new Term[0]);
        IPredicate falsePredicate = null;
        IPredicate[] iPredicateArray = initialPredicates;
        int n = initialPredicates.length;
        int n2 = 0;
        while (n2 < n) {
            pred = iPredicateArray[n2];
            if (pred.getFormula().equals(trueTerm)) {
                truePredicate = pred;
            } else if (pred.getFormula().equals(falseTerm)) {
                falsePredicate = pred;
            }
            ++n2;
        }
        this.mTruePredicate = truePredicate == null ? this.constructNewPredicate(this.mScript.term("true", new Term[0]), null) : truePredicate;
        this.mFalsePredicate = falsePredicate == null ? this.constructNewPredicate(this.mScript.term("false", new Term[0]), null) : falsePredicate;
        this.declareTruePredicateAndFalsePredicate();
        iPredicateArray = initialPredicates;
        n = initialPredicates.length;
        n2 = 0;
        while (n2 < n) {
            pred = iPredicateArray[n2];
            if (pred != this.mFalsePredicate && pred != this.mTruePredicate) {
                this.declarePredicate(pred);
            }
            ++n2;
        }
        logger.info((Object)"Initialized classic predicate unifier");
    }

    @Override
    public IPredicate getTruePredicate() {
        return this.mTruePredicate;
    }

    @Override
    public IPredicate getFalsePredicate() {
        return this.mFalsePredicate;
    }

    private void declareTruePredicateAndFalsePredicate() {
        Map<IPredicate, IncrementalPlicationChecker.Validity> impliedByTrue = Collections.emptyMap();
        Map<IPredicate, IncrementalPlicationChecker.Validity> expliedByTrue = Collections.emptyMap();
        this.addNewPredicate(this.mTruePredicate, this.mTruePredicate.getFormula(), this.mTruePredicate.getFormula(), impliedByTrue, expliedByTrue);
        Map<IPredicate, IncrementalPlicationChecker.Validity> impliedByFalse = Collections.singletonMap(this.mTruePredicate, IncrementalPlicationChecker.Validity.VALID);
        Map<IPredicate, IncrementalPlicationChecker.Validity> expliedByFalse = Collections.singletonMap(this.mTruePredicate, IncrementalPlicationChecker.Validity.INVALID);
        this.addNewPredicate(this.mFalsePredicate, this.mFalsePredicate.getFormula(), this.mFalsePredicate.getFormula(), impliedByFalse, expliedByFalse);
    }

    @Override
    public boolean isRepresentative(IPredicate pred) {
        IPredicate representative = this.mTerm2Predicates.get(pred.getFormula());
        return pred == representative;
    }

    void declarePredicate(IPredicate predicate) {
        PredicateComparison pc = new PredicateComparison(predicate.getFormula(), predicate.getVars(), null, null);
        if (pc.isEquivalentToExistingPredicateWithLeqQuantifiers()) {
            IPredicate other = pc.getEquivalantLeqQuantifiedPredicate();
            if (other != predicate) {
                this.mLogger.fatal((Object)("Have " + other));
                this.mLogger.fatal((Object)("Want " + predicate));
                throw new AssertionError((Object)"There is already an equivalent predicate");
            }
        } else if (pc.isEquivalentToExistingPredicateWithGtQuantifiers()) {
            if (pc.getEquivalantGtQuantifiedPredicate() != predicate) {
                throw new AssertionError((Object)"There is already an equivalent predicate");
            }
        } else {
            this.addNewPredicate(predicate, predicate.getFormula(), predicate.getFormula(), pc.getImpliedPredicates(), pc.getExpliedPredicates());
        }
        this.mPredicateUnifierBenchmarkGenerator.incrementDeclaredPredicates();
    }

    @Override
    public IPredicate getOrConstructPredicateForConjunction(Collection<IPredicate> conjunction) {
        Set<IPredicate> minimalSubset = PosetUtils.filterMinimalElements(conjunction, this.mCoverageRelation.getPartialComparator()).collect(Collectors.toSet());
        if (minimalSubset.size() == 1) {
            return (IPredicate)minimalSubset.iterator().next();
        }
        HashMap<IPredicate, IncrementalPlicationChecker.Validity> impliedPredicates = new HashMap<IPredicate, IncrementalPlicationChecker.Validity>();
        HashMap<IPredicate, IncrementalPlicationChecker.Validity> expliedPredicates = new HashMap<IPredicate, IncrementalPlicationChecker.Validity>();
        for (IPredicate conjunct : minimalSubset) {
            for (IPredicate coverer : this.getCoverageRelation().getCoveringPredicates(conjunct)) {
                impliedPredicates.put(coverer, IncrementalPlicationChecker.Validity.VALID);
            }
            for (IPredicate noncoverer : ((CoverageRelation)this.getCoverageRelation()).getNonCoveredPredicates(conjunct)) {
                expliedPredicates.put(noncoverer, IncrementalPlicationChecker.Validity.INVALID);
            }
        }
        return this.getOrConstructPredicateForConjunction(minimalSubset, impliedPredicates, expliedPredicates);
    }

    @Override
    public IPredicate getOrConstructPredicateForDisjunction(Collection<IPredicate> disjunction) {
        Set<IPredicate> minimalSubset = PosetUtils.filterMaximalElements(disjunction, this.mCoverageRelation.getPartialComparator()).collect(Collectors.toSet());
        if (minimalSubset.size() == 1) {
            return (IPredicate)minimalSubset.iterator().next();
        }
        HashMap<IPredicate, IncrementalPlicationChecker.Validity> impliedPredicates = new HashMap<IPredicate, IncrementalPlicationChecker.Validity>();
        HashMap<IPredicate, IncrementalPlicationChecker.Validity> expliedPredicates = new HashMap<IPredicate, IncrementalPlicationChecker.Validity>();
        for (IPredicate disjunct : minimalSubset) {
            for (IPredicate knownPredicate : this.mKnownPredicates) {
                IncrementalPlicationChecker.Validity validity = this.getCoverageRelation().isCovered(knownPredicate, disjunct);
                if (validity == IncrementalPlicationChecker.Validity.VALID) {
                    expliedPredicates.put(knownPredicate, IncrementalPlicationChecker.Validity.VALID);
                }
                if ((validity = this.getCoverageRelation().isCovered(disjunct, knownPredicate)) != IncrementalPlicationChecker.Validity.INVALID) continue;
                impliedPredicates.put(knownPredicate, IncrementalPlicationChecker.Validity.INVALID);
            }
        }
        return this.getOrConstructPredicateForDisjunction(minimalSubset, impliedPredicates, expliedPredicates);
    }

    private boolean varsIsSupersetOfFreeTermVariables(Term term, Set<IProgramVar> vars) {
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable tv = termVariableArray[n2];
            IProgramVar bv = this.mSymbolTable.getProgramVar(tv);
            if (bv == null) {
                throw new AssertionError((Object)("Variable " + tv + " has no corresponding BoogieVar, hence seems " + "to be some auxiliary variable and may not " + "occur unquantified in the formula of a predicate"));
            }
            if (!vars.contains(bv)) {
                throw new AssertionError((Object)("Variable " + tv + " does not occur in vars"));
            }
            ++n2;
        }
        return true;
    }

    @Override
    public IPredicate getOrConstructPredicate(IPredicate predicate) {
        if (this.mKnownPredicates.contains(predicate)) {
            return predicate;
        }
        return this.getOrConstructPredicate(predicate.getFormula(), null, null, predicate);
    }

    @Override
    public IPredicate getOrConstructPredicate(Term term) {
        return this.getOrConstructPredicate(term, null, null, null);
    }

    private IPredicate getOrConstructPredicate(Term term, HashMap<IPredicate, IncrementalPlicationChecker.Validity> impliedPredicates, HashMap<IPredicate, IncrementalPlicationChecker.Validity> expliedPredicates, IPredicate originalPredicate) {
        Term simplifiedTerm;
        TermVarsProc tvp = TermVarsProc.computeTermVarsProc(term, this.mMgdScript, this.mSymbolTable);
        this.mPredicateUnifierBenchmarkGenerator.continueTime();
        this.mPredicateUnifierBenchmarkGenerator.incrementGetRequests();
        assert (this.varsIsSupersetOfFreeTermVariables(term, tvp.getVars()));
        Term withoutAnnotation = PredicateUnifier.stripAnnotation(term);
        IPredicate p = this.mTerm2Predicates.get(withoutAnnotation);
        if (p != null) {
            if (this.mDeprecatedPredicates.containsKey(p)) {
                p = this.mDeprecatedPredicates.get(p);
            }
            this.mPredicateUnifierBenchmarkGenerator.incrementSyntacticMatches();
            this.mPredicateUnifierBenchmarkGenerator.stopTime();
            return p;
        }
        Term commuNF = new CommuhashNormalForm(this.mServices, this.mScript).transform(withoutAnnotation);
        IPredicate p2 = this.mTerm2Predicates.get(commuNF);
        if (p2 != null) {
            if (this.mDeprecatedPredicates.containsKey(p2)) {
                p2 = this.mDeprecatedPredicates.get(p2);
            }
            this.mPredicateUnifierBenchmarkGenerator.incrementSyntacticMatches();
            this.mPredicateUnifierBenchmarkGenerator.stopTime();
            return p2;
        }
        PredicateComparison pc = new PredicateComparison(commuNF, tvp.getVars(), impliedPredicates, expliedPredicates);
        if (pc.isEquivalentToExistingPredicateWithLeqQuantifiers()) {
            this.mPredicateUnifierBenchmarkGenerator.incrementSemanticMatches();
            this.mPredicateUnifierBenchmarkGenerator.stopTime();
            return pc.getEquivalantLeqQuantifiedPredicate();
        }
        assert (!SmtUtils.isTrueLiteral((Term)commuNF)) : "illegal predicate: true";
        assert (!SmtUtils.isFalseLiteral((Term)commuNF)) : "illegal predicate: false";
        assert (!this.mTerm2Predicates.containsKey(commuNF));
        if (pc.isIntricatePredicate()) {
            simplifiedTerm = commuNF;
        } else {
            try {
                Term tmp = SmtUtils.simplify((ManagedScript)this.mMgdScript, (Term)commuNF, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique);
                simplifiedTerm = new CommuhashNormalForm(this.mServices, this.mScript).transform(tmp);
            }
            catch (ToolchainCanceledException tce) {
                tce.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), "unifying predicates"));
                throw tce;
            }
        }
        IPredicate result = this.constructNewPredicate(simplifiedTerm, originalPredicate);
        if (pc.isEquivalentToExistingPredicateWithGtQuantifiers()) {
            this.mDeprecatedPredicates.put(pc.getEquivalantGtQuantifiedPredicate(), result);
            this.mPredicateUnifierBenchmarkGenerator.incrementDeprecatedPredicates();
        }
        this.addNewPredicate(result, term, simplifiedTerm, pc.getImpliedPredicates(), pc.getExpliedPredicates());
        assert (new CheckClosedTerm().isClosed(result.getClosedFormula()));
        assert (this.varsIsSupersetOfFreeTermVariables(result.getFormula(), result.getVars()));
        this.mPredicateUnifierBenchmarkGenerator.incrementConstructedPredicates();
        this.mPredicateUnifierBenchmarkGenerator.stopTime();
        return result;
    }

    protected IPredicate constructNewPredicate(Term term, IPredicate originalPredicate) {
        return this.mPredicateFactory.newPredicate(term);
    }

    protected IPredicate getOrConstructPredicateForConjunction(Set<IPredicate> minimalSubset, HashMap<IPredicate, IncrementalPlicationChecker.Validity> impliedPredicates, HashMap<IPredicate, IncrementalPlicationChecker.Validity> expliedPredicates) {
        IPredicate and = this.mPredicateFactory.and(minimalSubset);
        return this.getOrConstructPredicate(and.getFormula(), impliedPredicates, expliedPredicates, and);
    }

    protected IPredicate getOrConstructPredicateForDisjunction(Set<IPredicate> minimalSubset, HashMap<IPredicate, IncrementalPlicationChecker.Validity> impliedPredicates, HashMap<IPredicate, IncrementalPlicationChecker.Validity> expliedPredicates) {
        IPredicate or = this.mPredicateFactory.or(minimalSubset);
        return this.getOrConstructPredicate(or.getFormula(), impliedPredicates, expliedPredicates, or);
    }

    private static Term stripAnnotation(Term term) {
        Term withoutAnnotation;
        if (term instanceof AnnotatedTerm) {
            AnnotatedTerm annotatedTerm = (AnnotatedTerm)term;
            Annotation[] annotations = annotatedTerm.getAnnotations();
            if (annotations.length != 1 || !":quoted".equals(annotations[0].getKey())) {
                throw new UnsupportedOperationException();
            }
            withoutAnnotation = annotatedTerm.getSubterm();
        } else {
            withoutAnnotation = term;
        }
        return withoutAnnotation;
    }

    private void addNewPredicate(IPredicate pred, Term term, Term simplifiedTerm, Map<IPredicate, IncrementalPlicationChecker.Validity> implied, Map<IPredicate, IncrementalPlicationChecker.Validity> explied) {
        this.mTerm2Predicates.put(term, pred);
        this.mTerm2Predicates.put(simplifiedTerm, pred);
        this.mCoverageRelation.addPredicate(pred, implied, explied);
        assert (!this.mKnownPredicates.contains(pred)) : "predicate already known";
        this.mKnownPredicates.add(pred);
    }

    private static boolean thisIsLessQuantifiedThanOther(Term thisTerm, Term otherTerm) {
        ContainsQuantifier thisQuantifierCheck = new ContainsQuantifier();
        thisQuantifierCheck.containsQuantifier(thisTerm);
        ContainsQuantifier otherQuantifierCheck = new ContainsQuantifier();
        otherQuantifierCheck.containsQuantifier(otherTerm);
        return thisQuantifierCheck.getFirstQuantifierFound() == 1 && otherQuantifierCheck.getFirstQuantifierFound() == 0;
    }

    @Override
    public String collectPredicateUnifierStatistics() {
        StringBuilder builder = new StringBuilder();
        builder.append(PredicateUnifierStatisticsGenerator.PredicateUnifierStatisticsType.getInstance().prettyprintBenchmarkData(this.mPredicateUnifierBenchmarkGenerator));
        builder.append(this.mCoverageRelation.getCoverageRelationStatistics());
        return builder.toString();
    }

    @Override
    public boolean isIntricatePredicate(IPredicate pred) {
        IncrementalPlicationChecker.Validity equivalentToTrue = this.getCoverageRelation().isCovered(this.mTruePredicate, pred);
        IncrementalPlicationChecker.Validity equivalentToFalse = this.getCoverageRelation().isCovered(pred, this.mFalsePredicate);
        return equivalentToTrue == IncrementalPlicationChecker.Validity.UNKNOWN || equivalentToFalse == IncrementalPlicationChecker.Validity.UNKNOWN;
    }

    @Override
    public Set<IPredicate> cannibalize(boolean splitNumericEqualities, Term term) {
        Term[] conjuncts = SmtUtils.cannibalize((ManagedScript)this.mMgdScript, (IUltimateServiceProvider)this.mServices, (boolean)splitNumericEqualities, (Term)term);
        HashSet<IPredicate> result = new HashSet<IPredicate>();
        Term[] termArray = conjuncts;
        int n = conjuncts.length;
        int n2 = 0;
        while (n2 < n) {
            Term conjunct = termArray[n2];
            IPredicate predicate = this.getOrConstructPredicate(conjunct);
            result.add(predicate);
            ++n2;
        }
        return result;
    }

    @Override
    public Set<IPredicate> cannibalizeAll(boolean splitNumericEqualities, Collection<IPredicate> predicates) {
        HashSet<IPredicate> result = new HashSet<IPredicate>();
        for (IPredicate pred : predicates) {
            result.addAll(this.cannibalize(splitNumericEqualities, pred.getFormula()));
        }
        return result;
    }

    @Override
    public IPredicateCoverageChecker getCoverageRelation() {
        return this.mCoverageRelation;
    }

    @Override
    public IStatisticsDataProvider getPredicateUnifierBenchmark() {
        return this.mPredicateUnifierBenchmarkGenerator;
    }

    @Override
    public BasicPredicateFactory getPredicateFactory() {
        return this.mPredicateFactory;
    }

    @Override
    public IPredicate constructNewPredicate(Term term, Map<IPredicate, IncrementalPlicationChecker.Validity> impliedPredicates, Map<IPredicate, IncrementalPlicationChecker.Validity> expliedPredicates) {
        if (this.mTerm2Predicates.get(term) != null) {
            throw new AssertionError((Object)("PredicateUnifier already knows a predicate for " + term));
        }
        if (impliedPredicates.size() != this.mKnownPredicates.size()) {
            throw new AssertionError((Object)"Inconsistent number of IPredicates known by PredicateUnifier and number of provided implications");
        }
        if (expliedPredicates.size() != this.mKnownPredicates.size()) {
            throw new AssertionError((Object)"Inconsistent number of IPredicates known by PredicateUnifier and number of provided explications");
        }
        IPredicate predicate = this.constructNewPredicate(term, null);
        this.addNewPredicate(predicate, term, term, impliedPredicates, expliedPredicates);
        this.mPredicateUnifierBenchmarkGenerator.incrementDeclaredPredicates();
        return predicate;
    }

    public class CoverageRelation
    implements IPredicateCoverageChecker {
        private final NestedMap2<IPredicate, IPredicate, IncrementalPlicationChecker.Validity> mLhs2RhsValidity = new NestedMap2();
        private final HashRelation<IPredicate, IPredicate> mImpliedPredicates = new HashRelation();
        private final HashRelation<IPredicate, IPredicate> mExpliedPredicates = new HashRelation();
        private final HashRelation<IPredicate, IPredicate> mNotImpliedPredicates = new HashRelation();
        private final HashRelation<IPredicate, IPredicate> mNotExpliedPredicates = new HashRelation();

        void addPredicate(IPredicate pred, Map<IPredicate, IncrementalPlicationChecker.Validity> implied, Map<IPredicate, IncrementalPlicationChecker.Validity> explied) {
            assert (!PredicateUnifier.this.mKnownPredicates.contains(pred)) : "predicate already known";
            assert (this.coverageMapIsComplete());
            for (IPredicate known : PredicateUnifier.this.mKnownPredicates) {
                IncrementalPlicationChecker.Validity implies = implied.get(known);
                assert (implies != null) : "unknown implies for " + known;
                IncrementalPlicationChecker.Validity explies = explied.get(known);
                assert (explies != null) : "unknown explies for " + known;
                IncrementalPlicationChecker.Validity oldimpl = (IncrementalPlicationChecker.Validity)this.mLhs2RhsValidity.put((Object)pred, (Object)known, (Object)implies);
                assert (oldimpl == null) : "entry existed !";
                IncrementalPlicationChecker.Validity oldexpl = (IncrementalPlicationChecker.Validity)this.mLhs2RhsValidity.put((Object)known, (Object)pred, (Object)explies);
                assert (oldexpl == null) : "entry existed !";
                if (implies == IncrementalPlicationChecker.Validity.VALID) {
                    this.mImpliedPredicates.addPair((Object)pred, (Object)known);
                    this.mExpliedPredicates.addPair((Object)known, (Object)pred);
                } else if (implies == IncrementalPlicationChecker.Validity.INVALID) {
                    this.mNotImpliedPredicates.addPair((Object)pred, (Object)known);
                    this.mNotExpliedPredicates.addPair((Object)known, (Object)pred);
                }
                if (explies == IncrementalPlicationChecker.Validity.VALID) {
                    this.mImpliedPredicates.addPair((Object)known, (Object)pred);
                    this.mExpliedPredicates.addPair((Object)pred, (Object)known);
                    continue;
                }
                if (implies != IncrementalPlicationChecker.Validity.INVALID) continue;
                this.mNotImpliedPredicates.addPair((Object)known, (Object)pred);
                this.mNotExpliedPredicates.addPair((Object)pred, (Object)known);
            }
            this.mImpliedPredicates.addPair((Object)pred, (Object)pred);
            this.mExpliedPredicates.addPair((Object)pred, (Object)pred);
            assert (this.coverageMapIsComplete());
        }

        @Override
        public IncrementalPlicationChecker.Validity isCovered(IPredicate lhs, IPredicate rhs) {
            if (lhs.equals(rhs)) {
                return IncrementalPlicationChecker.Validity.VALID;
            }
            IncrementalPlicationChecker.Validity result = (IncrementalPlicationChecker.Validity)this.mLhs2RhsValidity.get((Object)lhs, (Object)rhs);
            if (result == null) {
                throw new AssertionError((Object)("at least one of both input predicates is unknown: " + lhs + " or " + rhs));
            }
            return result;
        }

        @Override
        public Set<IPredicate> getCoveringPredicates(IPredicate pred) {
            return this.mImpliedPredicates.getImage((Object)pred);
        }

        public Set<IPredicate> getNonCoveringPredicates(IPredicate pred) {
            return this.mNotImpliedPredicates.getImage((Object)pred);
        }

        @Override
        public Set<IPredicate> getCoveredPredicates(IPredicate pred) {
            return this.mExpliedPredicates.getImage((Object)pred);
        }

        public Set<IPredicate> getNonCoveredPredicates(IPredicate pred) {
            return this.mNotExpliedPredicates.getImage((Object)pred);
        }

        public CoverageRelationStatistics getCoverageRelationStatistics() {
            return new CoverageRelationStatistics(this.mLhs2RhsValidity);
        }

        private boolean coverageMapIsComplete() {
            boolean nothingMissing = true;
            for (IPredicate p1 : PredicateUnifier.this.mKnownPredicates) {
                for (IPredicate p2 : PredicateUnifier.this.mKnownPredicates) {
                    if (p1 == p2) continue;
                    IncrementalPlicationChecker.Validity validity = (IncrementalPlicationChecker.Validity)this.mLhs2RhsValidity.get((Object)p1, (Object)p2);
                    assert (validity != null) : "value missing for pair " + p1 + ", " + p2;
                    if (validity != null) continue;
                    nothingMissing = false;
                }
            }
            return nothingMissing;
        }

        @Override
        public IPartialComparator<IPredicate> getPartialComparator() {
            return (o1, o2) -> {
                IncrementalPlicationChecker.Validity explies;
                if (o1.equals(o2)) {
                    return IPartialComparator.ComparisonResult.EQUAL;
                }
                IncrementalPlicationChecker.Validity implies = (IncrementalPlicationChecker.Validity)this.mLhs2RhsValidity.get(o1, o2);
                if (implies == null) {
                    this.throwAssertionErrorWithMessage((IPredicate)o1, (IPredicate)o2);
                }
                if ((explies = (IncrementalPlicationChecker.Validity)this.mLhs2RhsValidity.get(o2, o1)) == null) {
                    this.throwAssertionErrorWithMessage((IPredicate)o1, (IPredicate)o2);
                }
                if (implies == IncrementalPlicationChecker.Validity.VALID) {
                    if (explies == IncrementalPlicationChecker.Validity.VALID) {
                        return IPartialComparator.ComparisonResult.EQUAL;
                    }
                    return IPartialComparator.ComparisonResult.STRICTLY_SMALLER;
                }
                if (explies == IncrementalPlicationChecker.Validity.VALID) {
                    return IPartialComparator.ComparisonResult.STRICTLY_GREATER;
                }
                return IPartialComparator.ComparisonResult.INCOMPARABLE;
            };
        }

        private void throwAssertionErrorWithMessage(IPredicate o1, IPredicate o2) throws AssertionError {
            if (!this.mLhs2RhsValidity.keySet().contains(o1)) {
                throw new AssertionError((Object)("PredicateUnifier does not know the following predicate " + String.valueOf(o1)));
            }
            if (!this.mLhs2RhsValidity.keySet().contains(o2)) {
                throw new AssertionError((Object)("PredicateUnifier does not know the following predicate " + String.valueOf(o2)));
            }
            throw new AssertionError((Object)"PredicateUnifier is in inconsistent state");
        }

        @Override
        public HashRelation<IPredicate, IPredicate> getCopyOfImplicationRelation() {
            return new HashRelation(this.mImpliedPredicates);
        }
    }

    public static class CoverageRelationStatistics {
        private final int mValidCoverageRelations;
        private final int mInvalidCoverageRelations;
        private final int mUnknownCoverageRelations;
        private final int mNotCheckedCoverageRelations;

        public CoverageRelationStatistics(NestedMap2<IPredicate, IPredicate, IncrementalPlicationChecker.Validity> lhs2RhsValidity) {
            int invalid = 0;
            int valid = 0;
            int unknown = 0;
            int notChecked = 0;
            for (Triple entry : lhs2RhsValidity.entrySet()) {
                switch ((IncrementalPlicationChecker.Validity)entry.getThird()) {
                    case INVALID: {
                        ++invalid;
                        break;
                    }
                    case NOT_CHECKED: {
                        ++notChecked;
                        break;
                    }
                    case UNKNOWN: {
                        ++unknown;
                        break;
                    }
                    case VALID: {
                        ++valid;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            this.mValidCoverageRelations = valid;
            this.mInvalidCoverageRelations = invalid;
            this.mUnknownCoverageRelations = unknown;
            this.mNotCheckedCoverageRelations = notChecked;
        }

        public String toString() {
            return String.format("CoverageRelationStatistics Valid=%s, Invalid=%s, Unknown=%s, NotChecked=%s, Total=%s", this.mValidCoverageRelations, this.mInvalidCoverageRelations, this.mUnknownCoverageRelations, this.mNotCheckedCoverageRelations, this.mValidCoverageRelations + this.mInvalidCoverageRelations + this.mUnknownCoverageRelations + this.mNotCheckedCoverageRelations);
        }
    }

    private final class PredicateComparison {
        private final Term mTerm;
        private final Term mClosedTerm;
        private final boolean mTermContainsQuantifiers;
        private final HashMap<IPredicate, IncrementalPlicationChecker.Validity> mImpliedPredicates;
        private final HashMap<IPredicate, IncrementalPlicationChecker.Validity> mExpliedPredicates;
        private final IPredicate mEquivalentLeqQuantifiedPredicate;
        private IPredicate mEquivalentGtQuantifiedPredicate;
        private boolean mIsIntricatePredicate;

        PredicateComparison(Term term, Set<IProgramVar> vars, HashMap<IPredicate, IncrementalPlicationChecker.Validity> impliedPredicates, HashMap<IPredicate, IncrementalPlicationChecker.Validity> expliedPredicates) {
            if (impliedPredicates == null) {
                if (expliedPredicates != null) {
                    throw new IllegalArgumentException("both or none null");
                }
                this.mImpliedPredicates = new HashMap();
                this.mExpliedPredicates = new HashMap();
            } else {
                this.mImpliedPredicates = impliedPredicates;
                this.mExpliedPredicates = expliedPredicates;
            }
            this.mTerm = term;
            this.mClosedTerm = PredicateUtils.computeClosedFormula(term, vars, PredicateUnifier.this.mMgdScript);
            this.mTermContainsQuantifiers = new ContainsQuantifier().containsQuantifier(term);
            PredicateUnifier.this.mScript.echo(new QuotedObject("begin unification"));
            this.mEquivalentLeqQuantifiedPredicate = this.compare();
            PredicateUnifier.this.mScript.echo(new QuotedObject("end unification"));
        }

        public Term getClosedTerm() {
            if (this.mEquivalentLeqQuantifiedPredicate != null) {
                throw new IllegalAccessError("not accessible, we found an equivalent predicate");
            }
            return this.mClosedTerm;
        }

        public HashMap<IPredicate, IncrementalPlicationChecker.Validity> getImpliedPredicates() {
            if (this.mEquivalentLeqQuantifiedPredicate != null) {
                throw new IllegalAccessError("not accessible, we found an equivalent predicate");
            }
            return this.mImpliedPredicates;
        }

        public HashMap<IPredicate, IncrementalPlicationChecker.Validity> getExpliedPredicates() {
            if (this.mEquivalentLeqQuantifiedPredicate != null) {
                throw new IllegalAccessError("not accessible, we found an equivalent predicate");
            }
            return this.mExpliedPredicates;
        }

        public IPredicate getEquivalantLeqQuantifiedPredicate() {
            if (this.mEquivalentLeqQuantifiedPredicate == null) {
                throw new IllegalAccessError("accessible only if equivalent to existing predicate");
            }
            return this.mEquivalentLeqQuantifiedPredicate;
        }

        public IPredicate getEquivalantGtQuantifiedPredicate() {
            if (this.mEquivalentGtQuantifiedPredicate == null) {
                throw new IllegalAccessError("accessible only if equivalent to existing predicate");
            }
            return this.mEquivalentGtQuantifiedPredicate;
        }

        public boolean isIntricatePredicate() {
            if (this.mEquivalentLeqQuantifiedPredicate != null) {
                throw new IllegalAccessError("not accessible, we found an equivalent predicate");
            }
            return this.mIsIntricatePredicate;
        }

        public boolean isEquivalentToExistingPredicateWithLeqQuantifiers() {
            return this.mEquivalentLeqQuantifiedPredicate != null;
        }

        public boolean isEquivalentToExistingPredicateWithGtQuantifiers() {
            return this.mEquivalentGtQuantifiedPredicate != null;
        }

        private IPredicate compare() {
            IncrementalPlicationChecker.Validity impliesFalse = PredicateUnifier.this.mImplicationChecker.checkImplication(this.mTerm, this.mClosedTerm, false, PredicateUnifier.this.mFalsePredicate.getFormula(), PredicateUnifier.this.mFalsePredicate.getClosedFormula(), false);
            switch (impliesFalse) {
                case VALID: {
                    return PredicateUnifier.this.mFalsePredicate;
                }
                case INVALID: {
                    this.mImpliedPredicates.put(PredicateUnifier.this.mFalsePredicate, IncrementalPlicationChecker.Validity.INVALID);
                    break;
                }
                case UNKNOWN: {
                    PredicateUnifier.this.mLogger.warn((Object)new DebugMessage("unable to prove that {0} is different from false", new Object[]{this.mClosedTerm}));
                    this.mImpliedPredicates.put(PredicateUnifier.this.mFalsePredicate, IncrementalPlicationChecker.Validity.UNKNOWN);
                    this.mIsIntricatePredicate = true;
                    break;
                }
                case NOT_CHECKED: {
                    throw new AssertionError((Object)"we wanted it checked");
                }
                default: {
                    throw new AssertionError((Object)"unknown case");
                }
            }
            this.mExpliedPredicates.put(PredicateUnifier.this.mFalsePredicate, IncrementalPlicationChecker.Validity.VALID);
            IncrementalPlicationChecker.Validity impliedByTrue = PredicateUnifier.this.mImplicationChecker.checkImplication(PredicateUnifier.this.mTruePredicate.getFormula(), PredicateUnifier.this.mTruePredicate.getClosedFormula(), false, this.mTerm, this.mClosedTerm, false);
            switch (impliedByTrue) {
                case VALID: {
                    return PredicateUnifier.this.mTruePredicate;
                }
                case INVALID: {
                    this.mExpliedPredicates.put(PredicateUnifier.this.mTruePredicate, IncrementalPlicationChecker.Validity.INVALID);
                    break;
                }
                case UNKNOWN: {
                    PredicateUnifier.this.mLogger.warn((Object)new DebugMessage("unable to prove that {0} is different from true", new Object[]{this.mClosedTerm}));
                    this.mExpliedPredicates.put(PredicateUnifier.this.mTruePredicate, IncrementalPlicationChecker.Validity.UNKNOWN);
                    this.mIsIntricatePredicate = true;
                    break;
                }
                case NOT_CHECKED: {
                    throw new AssertionError((Object)"we wanted it checked");
                }
                default: {
                    throw new AssertionError((Object)"unknown case");
                }
            }
            this.mImpliedPredicates.put(PredicateUnifier.this.mTruePredicate, IncrementalPlicationChecker.Validity.VALID);
            if (this.mIsIntricatePredicate) {
                for (IPredicate other : PredicateUnifier.this.mKnownPredicates) {
                    if (other == PredicateUnifier.this.mTruePredicate || other == PredicateUnifier.this.mFalsePredicate) continue;
                    this.mImpliedPredicates.put(other, IncrementalPlicationChecker.Validity.NOT_CHECKED);
                    this.mExpliedPredicates.put(other, IncrementalPlicationChecker.Validity.NOT_CHECKED);
                }
                PredicateUnifier.this.mPredicateUnifierBenchmarkGenerator.incrementIntricatePredicates();
                return null;
            }
            for (IPredicate other : PredicateUnifier.this.mKnownPredicates) {
                IncrementalPlicationChecker.Validity explies;
                if (other == PredicateUnifier.this.mTruePredicate || other == PredicateUnifier.this.mFalsePredicate) continue;
                if (PredicateUnifier.this.isIntricatePredicate(other)) {
                    this.mImpliedPredicates.put(other, IncrementalPlicationChecker.Validity.NOT_CHECKED);
                    this.mExpliedPredicates.put(other, IncrementalPlicationChecker.Validity.NOT_CHECKED);
                    continue;
                }
                this.checkTimeout(this.mClosedTerm);
                Term otherClosedTerm = other.getClosedFormula();
                IncrementalPlicationChecker.Validity implies = this.mImpliedPredicates.get(other);
                if (implies == null) {
                    IncrementalPlicationChecker.Validity oldValue;
                    implies = PredicateUnifier.this.mImplicationChecker.checkImplication(this.mTerm, this.mClosedTerm, false, other.getFormula(), other.getClosedFormula(), false);
                    if (implies == IncrementalPlicationChecker.Validity.VALID) {
                        for (IPredicate impliedByOther : PredicateUnifier.this.getCoverageRelation().getCoveringPredicates(other)) {
                            if (impliedByOther == other) continue;
                            oldValue = this.mImpliedPredicates.put(impliedByOther, IncrementalPlicationChecker.Validity.VALID);
                            if (oldValue == null || oldValue == IncrementalPlicationChecker.Validity.UNKNOWN) {
                                PredicateUnifier.this.mPredicateUnifierBenchmarkGenerator.incrementImplicationChecksByTransitivity();
                                continue;
                            }
                            assert (oldValue == IncrementalPlicationChecker.Validity.VALID) : "implication result by transitivity: " + IncrementalPlicationChecker.Validity.VALID + " old implication result: " + oldValue;
                        }
                    } else if (implies == IncrementalPlicationChecker.Validity.INVALID) {
                        for (IPredicate expliedByOther : PredicateUnifier.this.getCoverageRelation().getCoveredPredicates(other)) {
                            if (expliedByOther == other) continue;
                            oldValue = this.mImpliedPredicates.put(expliedByOther, IncrementalPlicationChecker.Validity.INVALID);
                            if (oldValue == null || oldValue == IncrementalPlicationChecker.Validity.UNKNOWN) {
                                PredicateUnifier.this.mPredicateUnifierBenchmarkGenerator.incrementImplicationChecksByTransitivity();
                                continue;
                            }
                            assert (oldValue == IncrementalPlicationChecker.Validity.INVALID) : "implication result by transitivity: " + IncrementalPlicationChecker.Validity.INVALID + " old implication result: " + oldValue;
                        }
                    }
                    this.mImpliedPredicates.put(other, implies);
                }
                if ((explies = this.mExpliedPredicates.get(other)) == null) {
                    IncrementalPlicationChecker.Validity oldValue;
                    explies = PredicateUnifier.this.mImplicationChecker.checkImplication(other.getFormula(), other.getClosedFormula(), false, this.mTerm, this.mClosedTerm, false);
                    if (explies == IncrementalPlicationChecker.Validity.VALID) {
                        for (IPredicate expliedByOther : PredicateUnifier.this.getCoverageRelation().getCoveredPredicates(other)) {
                            if (expliedByOther == other) continue;
                            oldValue = this.mExpliedPredicates.put(expliedByOther, IncrementalPlicationChecker.Validity.VALID);
                            if (oldValue == null || oldValue == IncrementalPlicationChecker.Validity.UNKNOWN) {
                                PredicateUnifier.this.mPredicateUnifierBenchmarkGenerator.incrementImplicationChecksByTransitivity();
                                continue;
                            }
                            assert (oldValue == IncrementalPlicationChecker.Validity.VALID) : "explication result by transitivity: " + IncrementalPlicationChecker.Validity.VALID + " old explication result: " + oldValue;
                        }
                    } else if (explies == IncrementalPlicationChecker.Validity.INVALID) {
                        for (IPredicate impliedByOther : PredicateUnifier.this.getCoverageRelation().getCoveringPredicates(other)) {
                            if (impliedByOther == other) continue;
                            oldValue = this.mExpliedPredicates.put(impliedByOther, IncrementalPlicationChecker.Validity.INVALID);
                            if (oldValue == null || oldValue == IncrementalPlicationChecker.Validity.UNKNOWN) {
                                PredicateUnifier.this.mPredicateUnifierBenchmarkGenerator.incrementImplicationChecksByTransitivity();
                                continue;
                            }
                            assert (oldValue == IncrementalPlicationChecker.Validity.INVALID) : "explication result by transitivity: " + IncrementalPlicationChecker.Validity.INVALID + " old explication result: " + oldValue;
                        }
                    }
                    this.mExpliedPredicates.put(other, explies);
                }
                if (implies != IncrementalPlicationChecker.Validity.VALID || explies != IncrementalPlicationChecker.Validity.VALID) continue;
                if (PredicateUnifier.this.mDeprecatedPredicates.containsKey(other)) {
                    return PredicateUnifier.this.mDeprecatedPredicates.get(other);
                }
                boolean otherContainsQuantifiers = new ContainsQuantifier().containsQuantifier(other.getFormula());
                if (!otherContainsQuantifiers || this.mTermContainsQuantifiers && !PredicateUnifier.thisIsLessQuantifiedThanOther(this.mClosedTerm, otherClosedTerm)) {
                    return other;
                }
                if (this.mEquivalentGtQuantifiedPredicate != null) {
                    throw new AssertionError((Object)"at most one deprecated predicate");
                }
                this.mEquivalentGtQuantifiedPredicate = other;
            }
            return null;
        }

        private void checkTimeout(Term closedTerm) {
            if (!PredicateUnifier.this.mServices.getProgressMonitorService().continueProcessing()) {
                String quantifierInformation = this.generateQuantifierInformation(closedTerm);
                throw new ToolchainCanceledException(this.getClass(), "comparing new predicate (" + quantifierInformation + ") to " + PredicateUnifier.this.mKnownPredicates.size() + " known predicates");
            }
        }

        private String generateQuantifierInformation(Term closedTerm) {
            String result;
            Term pnf = new PrenexNormalForm(PredicateUnifier.this.mMgdScript).transform(closedTerm);
            if (pnf instanceof QuantifiedFormula) {
                QuantifierSequence qs = new QuantifierSequence(PredicateUnifier.this.mMgdScript, pnf);
                result = "quantified with " + (qs.getNumberOfQuantifierBlocks() - 1) + "quantifier alternations";
            } else {
                result = "quantifier-free";
            }
            return result;
        }
    }
}

