/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PureSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PredicateUtils {
    public static long computeDagSizeOfPredicate(IPredicate p, FormulaSize size) {
        switch (size) {
            case DAGSIZE: {
                return new DAGSize().size(p.getFormula());
            }
            case TREESIZE: {
                return new DAGSize().treesize(p.getFormula());
            }
        }
        throw new AssertionError((Object)("unknown " + (Object)((Object)size)));
    }

    public static long[] computeDagSizeOfPredicates(List<IPredicate> predicates, FormulaSize size) {
        long[] sizeOfPredicates = new long[predicates.size()];
        int i = 0;
        while (i < predicates.size()) {
            sizeOfPredicates[i] = PredicateUtils.computeDagSizeOfPredicate(predicates.get(i), size);
            ++i;
        }
        return sizeOfPredicates;
    }

    public static Term computeClosedFormula(Term formula, Set<IProgramVar> boogieVars, ManagedScript mgdScript) {
        HashMap<TermVariable, ApplicationTerm> substitutionMapping = new HashMap<TermVariable, ApplicationTerm>();
        for (IProgramVar bv : boogieVars) {
            substitutionMapping.put(bv.getTermVariable(), bv.getDefaultConstant());
        }
        Term closedTerm = Substitution.apply((ManagedScript)mgdScript, substitutionMapping, (Term)formula);
        assert (closedTerm.getFreeVars().length == 0);
        return closedTerm;
    }

    public static Term formulaWithIndexedVars(IPredicate ps, Set<IProgramVar> varsWithSpecialIdx, int specialIdx, int defaultIdx, int oldVarIdx, Set<IProgramNonOldVar> modifiableGlobalsCallee, int globSpecialIdx, int globDefaultIdx, Map<String, Term> indexedConstants, Script script, Set<IProgramNonOldVar> modifiableGlobalsCaller) {
        Term psTerm = ps.getFormula();
        if (ps.getVars() == null) {
            return psTerm;
        }
        HashMap<TermVariable, Term> substitution = new HashMap<TermVariable, Term>();
        for (IProgramVar var : ps.getVars()) {
            IProgramNonOldVar bnov;
            Object cIndex = varsWithSpecialIdx.contains(var) ? PredicateUtils.getIndexedConstant(var, specialIdx, indexedConstants, script) : (var.isOldvar() ? (modifiableGlobalsCaller.contains(bnov = ((IProgramOldVar)var).getNonOldVar()) ? (oldVarIdx == Integer.MIN_VALUE ? var.getDefaultConstant() : PredicateUtils.getIndexedConstant(((IProgramOldVar)var).getNonOldVar(), oldVarIdx, indexedConstants, script)) : PredicateUtils.getIndexedConstant(bnov, globDefaultIdx, indexedConstants, script)) : (var.isGlobal() ? (modifiableGlobalsCallee != null && modifiableGlobalsCallee.contains(var) ? PredicateUtils.getIndexedConstant(var, globSpecialIdx, indexedConstants, script) : PredicateUtils.getIndexedConstant(var, globDefaultIdx, indexedConstants, script)) : PredicateUtils.getIndexedConstant(var, defaultIdx, indexedConstants, script)));
            TermVariable c = var.getTermVariable();
            substitution.put(c, (Term)cIndex);
        }
        TermVariable[] vars = new TermVariable[substitution.size()];
        Term[] values = new Term[substitution.size()];
        int i = 0;
        for (Map.Entry entry : substitution.entrySet()) {
            vars[i] = (TermVariable)entry.getKey();
            values[i] = (Term)entry.getValue();
            ++i;
        }
        Term result = script.let(vars, values, psTerm);
        return result;
    }

    public static Term formulaWithIndexedVars(UnmodifiableTransFormula tf, int idxInVar, int idxOutVar, Set<IProgramVar> assignedVars, Map<String, Term> indexedConstants, Script script) {
        Term[] values;
        TermVariable[] vars;
        Object cIndex;
        TermVariable tv;
        assert (assignedVars != null && assignedVars.isEmpty());
        HashSet<TermVariable> notYetSubst = new HashSet<TermVariable>();
        notYetSubst.addAll(Arrays.asList(tf.getFormula().getFreeVars()));
        Term fTrans = tf.getFormula();
        HashMap<TermVariable, IProgramVar> reverseMapping = new HashMap<TermVariable, IProgramVar>();
        for (IProgramVar inVar : tf.getInVars().keySet()) {
            tv = tf.getInVars().get(inVar);
            reverseMapping.put(tv, inVar);
            cIndex = inVar.isOldvar() ? inVar.getDefaultConstant() : PredicateUtils.getIndexedConstant(inVar, idxInVar, indexedConstants, script);
            vars = new TermVariable[]{tv};
            values = new Term[]{cIndex};
            fTrans = script.let(vars, values, fTrans);
            notYetSubst.remove(tv);
        }
        for (IProgramVar outVar : tf.getOutVars().keySet()) {
            tv = tf.getOutVars().get(outVar);
            reverseMapping.put(tv, outVar);
            if (tf.getInVars().get(outVar) == tv) continue;
            assignedVars.add(outVar);
            cIndex = outVar.isOldvar() && !tf.getAssignedVars().contains(outVar) ? outVar.getDefaultConstant() : PredicateUtils.getIndexedConstant(outVar, idxOutVar, indexedConstants, script);
            vars = new TermVariable[]{tv};
            values = new Term[]{cIndex};
            fTrans = script.let(vars, values, fTrans);
            notYetSubst.remove(tv);
        }
        for (TermVariable tv2 : notYetSubst) {
            Object cIndex2 = tf.getAuxVars().contains(tv2) ? script.term(ProgramVarUtils.generateConstantIdentifierForAuxVar(tv2), new Term[0]) : ((IProgramVar)reverseMapping.get(tv2)).getDefaultConstant();
            TermVariable[] vars2 = new TermVariable[]{tv2};
            Term[] values2 = new Term[]{cIndex2};
            fTrans = script.let(vars2, values2, fTrans);
        }
        return fTrans;
    }

    public static Term getIndexedConstant(IProgramVar bv, int index, Map<String, Term> indexedConstants, Script script) {
        return PredicateUtils.getIndexedConstant(bv.getGloballyUniqueId(), bv.getTermVariable().getSort(), index, indexedConstants, script);
    }

    public static Term getIndexedConstant(String id, Sort sort, int index, Map<String, Term> indexedConstants, Script script) {
        String indexString = String.valueOf(index);
        String name = String.valueOf(id) + "_" + indexString;
        Term constant = indexedConstants.get(name);
        if (constant == null) {
            Sort[] emptySorts = new Sort[]{};
            script.declareFun(name, emptySorts, sort);
            Term[] emptyTerms = new Term[]{};
            constant = script.term(name, emptyTerms);
            indexedConstants.put(name, constant);
        }
        return constant;
    }

    public static Script.LBool isInductiveHelper(Script script, IPredicate precond, IPredicate postcond, UnmodifiableTransFormula tf, Set<IProgramNonOldVar> modifiableGlobalsPred, Set<IProgramNonOldVar> modifiableGlobalsSucc) {
        script.push(1);
        ArrayList<Term> conjuncts = new ArrayList<Term>();
        HashSet<IProgramNonOldVar> unprimedOldVarEqualities = new HashSet<IProgramNonOldVar>();
        HashSet<IProgramNonOldVar> primedOldVarEqualities = new HashSet<IProgramNonOldVar>();
        PredicateUtils.findNonModifiablesGlobals(precond.getVars(), modifiableGlobalsPred, Collections.emptySet(), unprimedOldVarEqualities, primedOldVarEqualities);
        PredicateUtils.findNonModifiablesGlobals(tf.getInVars().keySet(), modifiableGlobalsPred, Collections.emptySet(), unprimedOldVarEqualities, primedOldVarEqualities);
        PredicateUtils.findNonModifiablesGlobals(tf.getOutVars().keySet(), modifiableGlobalsSucc, tf.getAssignedVars(), unprimedOldVarEqualities, primedOldVarEqualities);
        for (IProgramNonOldVar bv : unprimedOldVarEqualities) {
            conjuncts.add(ModifiableGlobalsTable.constructConstantOldVarEquality(bv, false, script));
        }
        for (IProgramNonOldVar bv : primedOldVarEqualities) {
            conjuncts.add(ModifiableGlobalsTable.constructConstantOldVarEquality(bv, true, script));
        }
        Term precondRenamed = precond.getClosedFormula();
        assert (precondRenamed != null);
        conjuncts.add(precondRenamed);
        Term tfRenamed = tf.getClosedFormula();
        assert (tfRenamed != null);
        conjuncts.add(tfRenamed);
        unprimedOldVarEqualities = new HashSet();
        primedOldVarEqualities = new HashSet();
        PredicateUtils.findNonModifiablesGlobals(postcond.getVars(), modifiableGlobalsSucc, tf.getAssignedVars(), unprimedOldVarEqualities, primedOldVarEqualities);
        for (IProgramNonOldVar bv : unprimedOldVarEqualities) {
            conjuncts.add(ModifiableGlobalsTable.constructConstantOldVarEquality(bv, false, script));
        }
        for (IProgramNonOldVar bv : primedOldVarEqualities) {
            conjuncts.add(ModifiableGlobalsTable.constructConstantOldVarEquality(bv, true, script));
        }
        Term postcondRenamed = PredicateUtils.rename(script, postcond, tf.getAssignedVars());
        conjuncts.add(SmtUtils.not((Script)script, (Term)postcondRenamed));
        script.assertTerm(SmtUtils.and((Script)script, conjuncts));
        Script.LBool result = script.checkSat();
        script.pop(1);
        return result;
    }

    private static void findNonModifiablesGlobals(Set<IProgramVar> vars, Set<IProgramNonOldVar> modifiableGlobalsPred, Set<IProgramVar> primedRequired, Set<IProgramNonOldVar> nonModifiableGlobalsUnprimed, Set<IProgramNonOldVar> nonModifiableGlobalsPrimed) {
        for (IProgramVar bv : vars) {
            IProgramNonOldVar nonOldVar;
            if (!(bv instanceof IProgramOldVar) || modifiableGlobalsPred.contains(nonOldVar = ((IProgramOldVar)bv).getNonOldVar())) continue;
            if (primedRequired.contains(bv)) {
                nonModifiableGlobalsPrimed.add(nonOldVar);
                continue;
            }
            nonModifiableGlobalsUnprimed.add(nonOldVar);
        }
    }

    private static Term rename(Script script, IPredicate postcond, Set<IProgramVar> assignedVars) {
        HashMap<TermVariable, ApplicationTerm> substitutionMapping = new HashMap<TermVariable, ApplicationTerm>();
        for (IProgramVar bv : postcond.getVars()) {
            ApplicationTerm constant = assignedVars.contains(bv) ? bv.getPrimedConstant() : bv.getDefaultConstant();
            substitutionMapping.put(bv.getTermVariable(), constant);
        }
        Term result = new PureSubstitution(script, substitutionMapping).transform(postcond.getFormula());
        assert (result.getFreeVars().length == 0) : "there are free vars";
        return result;
    }

    public static enum FormulaSize {
        TREESIZE,
        DAGSIZE;

    }
}

