/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableList;
import java.util.Set;

public class PredicateWithConjuncts
implements IPredicate {
    protected final int mSerial;
    protected final ImmutableList<IPredicate> mConjuncts;

    public PredicateWithConjuncts(int serialNumber, ImmutableList<IPredicate> conjuncts) {
        this.mSerial = serialNumber;
        this.mConjuncts = conjuncts;
    }

    public PredicateWithConjuncts(int serialNumber, IPredicate old, IPredicate newConjunct) {
        this.mSerial = serialNumber;
        ImmutableList<IPredicate> oldConjuncts = old instanceof PredicateWithConjuncts ? ((PredicateWithConjuncts)old).mConjuncts : ImmutableList.singleton((Object)old);
        this.mConjuncts = new ImmutableList((Object)newConjunct, oldConjuncts);
    }

    public ImmutableList<IPredicate> getConjuncts() {
        return this.mConjuncts;
    }

    public int hashCode() {
        return HashUtils.hashJenkins((int)31, (Object)this.mSerial);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            PredicateWithConjuncts other = (PredicateWithConjuncts)obj;
            return this.mSerial == other.mSerial;
        }
        return false;
    }

    @Override
    public Term getFormula() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Term getClosedFormula() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] getProcedures() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<IProgramVar> getVars() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.valueOf(this.mSerial) + "#" + this.mConjuncts.toString();
    }
}

