/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IDomainSpecificOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TermDomainOperationProvider
implements IDomainSpecificOperationProvider<Term, IPredicate, TransFormula> {
    protected final ManagedScript mMgdScript;
    protected final IUltimateServiceProvider mServices;

    public TermDomainOperationProvider(IUltimateServiceProvider services, ManagedScript mgdScript) {
        this.mServices = services;
        this.mMgdScript = mgdScript;
    }

    @Override
    public Term getConstraint(IPredicate p) {
        return p.getFormula();
    }

    @Override
    public boolean isConstraintUnsatisfiable(Term constraint) {
        return SmtUtils.isFalseLiteral((Term)constraint);
    }

    @Override
    public boolean isConstraintValid(Term constraint) {
        return SmtUtils.isTrueLiteral((Term)constraint);
    }

    @Override
    public Term getConstraintFromTransitionRelation(TransFormula tf) {
        return tf.getFormula();
    }

    @Override
    public Term renameVariables(Map<Term, Term> substitutionForTransFormula, Term constraint) {
        Term renamedTransFormula = Substitution.apply((ManagedScript)this.mMgdScript, substitutionForTransFormula, (Term)constraint);
        return renamedTransFormula;
    }

    @Override
    public Term constructConjunction(List<Term> conjuncts) {
        return SmtUtils.and((Script)this.mMgdScript.getScript(), conjuncts);
    }

    @Override
    public Term constructDisjunction(List<Term> disjuncts) {
        return SmtUtils.or((Script)this.mMgdScript.getScript(), disjuncts);
    }

    @Override
    public Term constructNegation(Term operand) {
        return SmtUtils.not((Script)this.mMgdScript.getScript(), (Term)operand);
    }

    @Override
    public Term projectExistentially(Set<TermVariable> varsToProjectAway, Term constraint) {
        return this.constructQuantifiedFormula(0, varsToProjectAway, constraint);
    }

    @Override
    public Term projectUniversally(Set<TermVariable> varsToProjectAway, Term constraint) {
        return this.constructQuantifiedFormula(1, varsToProjectAway, constraint);
    }

    private Term constructQuantifiedFormula(int quantifier, Set<TermVariable> varsToQuantify, Term term) {
        Term quantified = SmtUtils.quantifier((Script)this.mMgdScript.getScript(), (int)quantifier, varsToQuantify, (Term)term);
        Term pushed = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (boolean)false, (QuantifierPusher.PqeTechniques)QuantifierPusher.PqeTechniques.ONLY_DER, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, (Term)quantified);
        return pushed;
    }
}

