/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

public class TermVarsProc {
    private final Term mTerm;
    private final Set<IProgramVar> mVars;
    private final String[] mProcedures;
    private final Term mClosedTerm;

    public TermVarsProc(Term term, Set<IProgramVar> vars, String[] procedures, Term closedTerm) {
        this.mTerm = term;
        this.mVars = vars;
        this.mProcedures = procedures;
        this.mClosedTerm = closedTerm;
    }

    public String[] getProcedures() {
        return this.mProcedures;
    }

    public Term getFormula() {
        return this.mTerm;
    }

    public Term getClosedFormula() {
        return this.mClosedTerm;
    }

    public Set<IProgramVar> getVars() {
        return this.mVars;
    }

    public static TermVarsProc computeTermVarsProc(Term term, ManagedScript mgdScript, IIcfgSymbolTable symbolTable) {
        return TermVarsProc.computeTermVarsProc(term, mgdScript, symbolTable::getProgramVar);
    }

    public static TermVarsProc computeTermVarsProc(Term term, ManagedScript mgdScript, Function<TermVariable, IProgramVar> funTermVar2ProgVar) {
        HashSet<IProgramVar> vars = new HashSet<IProgramVar>();
        HashSet<String> procs = new HashSet<String>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable tv = termVariableArray[n2];
            IProgramVar bv = funTermVar2ProgVar.apply(tv);
            if (bv == null) {
                throw new AssertionError((Object)("No corresponding IProgramVar for " + tv));
            }
            vars.add(bv);
            if (bv.getProcedure() != null) {
                procs.add(bv.getProcedure());
            }
            ++n2;
        }
        Term closedTerm = PredicateUtils.computeClosedFormula(term, vars, mgdScript);
        return new TermVarsProc(term, vars, procs.toArray(new String[procs.size()]), closedTerm);
    }
}

