/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateCoverageChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableList;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class UnionPredicateCoverageChecker
implements IPredicateCoverageChecker {
    private final ImmutableList<Pair<IPredicateCoverageChecker, Predicate<IPredicate>>> mComponents;

    private UnionPredicateCoverageChecker(ImmutableList<Pair<IPredicateCoverageChecker, Predicate<IPredicate>>> components) {
        this.mComponents = components;
    }

    public static UnionPredicateCoverageChecker empty() {
        return new UnionPredicateCoverageChecker((ImmutableList<Pair<IPredicateCoverageChecker, Predicate<IPredicate>>>)ImmutableList.empty());
    }

    public UnionPredicateCoverageChecker with(IPredicateCoverageChecker checker, Predicate<IPredicate> protection) {
        return new UnionPredicateCoverageChecker((ImmutableList<Pair<IPredicateCoverageChecker, Predicate<IPredicate>>>)new ImmutableList((Object)new Pair((Object)checker, protection), this.mComponents));
    }

    @Override
    public IncrementalPlicationChecker.Validity isCovered(IPredicate lhs, IPredicate rhs) {
        for (Pair pair : this.mComponents) {
            IncrementalPlicationChecker.Validity result;
            Predicate protection = (Predicate)pair.getSecond();
            if (protection != null && (protection.test(lhs) || protection.test(rhs)) || (result = ((IPredicateCoverageChecker)pair.getFirst()).isCovered(lhs, rhs)) != IncrementalPlicationChecker.Validity.VALID && result != IncrementalPlicationChecker.Validity.INVALID) continue;
            return result;
        }
        return IncrementalPlicationChecker.Validity.UNKNOWN;
    }

    @Override
    public Set<IPredicate> getCoveredPredicates(IPredicate pred) {
        return this.mComponents.stream().flatMap(p -> p.getSecond() == null || ((Predicate)p.getSecond()).test(pred) ? ((IPredicateCoverageChecker)p.getFirst()).getCoveredPredicates(pred).stream() : Stream.empty()).collect(Collectors.toSet());
    }

    @Override
    public Set<IPredicate> getCoveringPredicates(IPredicate pred) {
        return this.mComponents.stream().flatMap(p -> p.getSecond() == null || ((Predicate)p.getSecond()).test(pred) ? ((IPredicateCoverageChecker)p.getFirst()).getCoveringPredicates(pred).stream() : Stream.empty()).collect(Collectors.toSet());
    }

    @Override
    public IPartialComparator<IPredicate> getPartialComparator() {
        return (p1, p2) -> {
            if (Objects.equals(p1, p2)) {
                return IPartialComparator.ComparisonResult.EQUAL;
            }
            if (this.getCoveredPredicates((IPredicate)p1).contains(p2)) {
                return IPartialComparator.ComparisonResult.STRICTLY_GREATER;
            }
            if (this.getCoveringPredicates((IPredicate)p1).contains(p1)) {
                return IPartialComparator.ComparisonResult.STRICTLY_SMALLER;
            }
            return IPartialComparator.ComparisonResult.INCOMPARABLE;
        };
    }

    @Override
    public HashRelation<IPredicate, IPredicate> getCopyOfImplicationRelation() {
        HashRelation relation = new HashRelation();
        for (Pair pair : this.mComponents) {
            relation.addAll(((IPredicateCoverageChecker)pair.getFirst()).getCopyOfImplicationRelation());
        }
        return relation;
    }
}

