/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;

public class TraceCheckReasonUnknown {
    private static final String SMTINTERPOL_NONLINEAR_ARITHMETIC_MESSAGE = "Unsupported non-linear arithmetic";
    private static final String CVC4_NONLINEAR_ARITHMETIC_MESSAGE_PREFIX = "A non-linear fact";
    private static final String CVC4_CONST_ARRAY_WRITE_CHAIN_CONNECTION_MESSAGE = "Array theory solver does not yet support write-chains connecting two different constant arrays";
    private final Reason mReason;
    private final Exception mException;
    private final ExceptionHandlingCategory mExceptionHandlingCategory;

    public TraceCheckReasonUnknown(Reason reason, Exception exception, ExceptionHandlingCategory category) {
        this.mReason = reason;
        this.mException = exception;
        this.mExceptionHandlingCategory = category;
    }

    public Reason getReason() {
        return this.mReason;
    }

    public Exception getException() {
        return this.mException;
    }

    public ExceptionHandlingCategory getExceptionHandlingCategory() {
        return this.mExceptionHandlingCategory;
    }

    public static TraceCheckReasonUnknown constructReasonUnknown(SMTLIBException e) {
        ExceptionHandlingCategory exceptionCategory;
        Reason reason;
        String message = e.getMessage();
        if (message == null) {
            reason = Reason.SOLVER_CRASH_OTHER;
            exceptionCategory = ExceptionHandlingCategory.UNKNOWN;
        } else if (message.equals(SMTINTERPOL_NONLINEAR_ARITHMETIC_MESSAGE)) {
            reason = Reason.UNSUPPORTED_NON_LINEAR_ARITHMETIC;
            exceptionCategory = ExceptionHandlingCategory.KNOWN_IGNORE;
        } else if (message.equals(CVC4_CONST_ARRAY_WRITE_CHAIN_CONNECTION_MESSAGE)) {
            reason = Reason.UNSUPPORTED_CONST_ARRAY_WRITE_CHAINS;
            exceptionCategory = ExceptionHandlingCategory.KNOWN_IGNORE;
        } else if (message.startsWith("Cannot handle literal")) {
            reason = Reason.UNSUPPORTED_QUANTIFIERS;
            exceptionCategory = ExceptionHandlingCategory.KNOWN_DEPENDING;
        } else if (message.startsWith(CVC4_NONLINEAR_ARITHMETIC_MESSAGE_PREFIX)) {
            reason = Reason.UNSUPPORTED_NON_LINEAR_ARITHMETIC;
            exceptionCategory = ExceptionHandlingCategory.KNOWN_IGNORE;
        } else if (message.endsWith("Connection to SMT solver broken")) {
            reason = Reason.SOLVER_CRASH_OTHER;
            exceptionCategory = ExceptionHandlingCategory.KNOWN_DEPENDING;
        } else if (message.endsWith("Received EOF on stdin. No stderr output.")) {
            reason = Reason.SOLVER_CRASH_OTHER;
            exceptionCategory = ExceptionHandlingCategory.KNOWN_DEPENDING;
        } else if (message.contains("Received EOF on stdin. stderr output:")) {
            reason = Reason.SOLVER_CRASH_OTHER;
            exceptionCategory = ExceptionHandlingCategory.KNOWN_THROW;
        } else if (message.startsWith("Logic does not allow numerals")) {
            reason = Reason.SOLVER_CRASH_WRONG_USAGE;
            exceptionCategory = ExceptionHandlingCategory.KNOWN_IGNORE;
        } else if (message.startsWith("Timeout exceeded")) {
            reason = Reason.SOLVER_RESPONSE_TIMEOUT;
            exceptionCategory = ExceptionHandlingCategory.KNOWN_IGNORE;
        } else if (message.startsWith("ERROR: bvadd takes exactly 2 arguments")) {
            reason = Reason.ULTIMATE_VIOLATES_SMT_LIB_STANDARD_AND_SOLVER_COMPLAINS;
            exceptionCategory = ExceptionHandlingCategory.KNOWN_IGNORE;
        } else {
            reason = Reason.SOLVER_CRASH_OTHER;
            exceptionCategory = ExceptionHandlingCategory.UNKNOWN;
        }
        return new TraceCheckReasonUnknown(reason, (Exception)((Object)e), exceptionCategory);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append((Object)this.getReason());
        if (this.getException() != null) {
            sb.append(": ").append(this.getException().getMessage());
        }
        return sb.toString();
    }

    public static enum ExceptionHandlingCategory {
        KNOWN_IGNORE,
        KNOWN_DEPENDING,
        KNOWN_THROW,
        UNKNOWN;


        public boolean throwException(RefinementStrategyExceptionBlacklist throwSpecification) {
            switch (throwSpecification) {
                case ALL: {
                    return true;
                }
                case DEPENDING: {
                    return this == UNKNOWN || this == KNOWN_THROW || this == KNOWN_DEPENDING;
                }
                case UNKNOWN: {
                    return this == UNKNOWN || this == KNOWN_THROW;
                }
                case NONE: {
                    return false;
                }
            }
            throw new IllegalArgumentException("Unknown category specification: " + (Object)((Object)throwSpecification));
        }
    }

    public static enum Reason {
        SOLVER_RESPONSE_TIMEOUT,
        SOLVER_RESPONSE_OTHER,
        ULTIMATE_TIMEOUT,
        UNSUPPORTED_NON_LINEAR_ARITHMETIC,
        UNSUPPORTED_CONST_ARRAY_WRITE_CHAINS,
        UNSUPPORTED_QUANTIFIERS,
        SOLVER_CRASH_WRONG_USAGE,
        SOLVER_CRASH_OTHER,
        ULTIMATE_VIOLATES_SMT_LIB_STANDARD_AND_SOLVER_COMPLAINS;

    }

    public static enum RefinementStrategyExceptionBlacklist {
        NONE,
        UNKNOWN,
        DEPENDING,
        ALL;

    }
}

