/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.InterpolantComputationStatus;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.QualifiedTracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.TraceCheckReasonUnknown;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IIpgStrategyModule;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementEngine;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementEngineResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.ITraceCheckStrategyModule;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.RefinementEngineStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.Lazy;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public final class AutomatonFreeRefinementEngine<L extends IIcfgTransition<?>>
implements IRefinementEngine<L, Collection<QualifiedTracePredicates>> {
    private final ILogger mLogger;
    private final IRefinementStrategy<L> mStrategy;
    private final RefinementEngineStatisticsGenerator mRefinementEngineStatistics;
    private final Script.LBool mFeasibility;
    private IProgramExecution<L, Term> mIcfgProgramExecution;
    private List<QualifiedTracePredicates> mUsedTracePredicates;
    private boolean mSomePerfectSequenceFound;
    private List<QualifiedTracePredicates> mQualifiedTracePredicates;
    private String mUsedTraceCheckFingerprint;
    private final IUltimateServiceProvider mServices;

    public AutomatonFreeRefinementEngine(IUltimateServiceProvider services, ILogger logger, IRefinementStrategy<L> strategy) {
        this.mServices = services;
        this.mLogger = logger;
        this.mStrategy = strategy;
        this.mRefinementEngineStatistics = new RefinementEngineStatisticsGenerator();
        this.mFeasibility = this.executeStrategy();
        this.mRefinementEngineStatistics.finishRefinementEngineRun();
    }

    private IHoareTripleChecker getHoareTripleChecker() {
        IHoareTripleChecker strategyHtc = this.mStrategy.getHoareTripleChecker(this);
        if (strategyHtc != null) {
            this.mLogger.info("Using hoare triple checker %s provided by strategy", new Object[]{strategyHtc.getClass().getSimpleName()});
        }
        return strategyHtc;
    }

    private IPredicateUnifier getPredicateUnifier() {
        IPredicateUnifier strategyUnifier = this.mStrategy.getPredicateUnifier(this);
        assert (strategyUnifier != null);
        this.mLogger.info("Using predicate unifier %s provided by strategy %s", new Object[]{strategyUnifier.getClass().getSimpleName(), this.mStrategy.getName()});
        return strategyUnifier;
    }

    @Override
    public RefinementEngineStatisticsGenerator getRefinementEngineStatistics() {
        return this.mRefinementEngineStatistics;
    }

    private Script.LBool executeStrategy() {
        this.mLogger.info("Executing refinement strategy %s", new Object[]{this.mStrategy.getName()});
        Script.LBool feasibilityResult = this.checkFeasibility();
        if (feasibilityResult == Script.LBool.UNKNOWN) {
            this.abortIfTimeout(String.format("Timeout during %s", this.mStrategy.getName()));
            this.mLogger.warn("Strategy %s was unsuccessful and could not determine trace feasibility", new Object[]{this.mStrategy.getName()});
            return feasibilityResult;
        }
        if (feasibilityResult == Script.LBool.SAT) {
            this.mLogger.info("Strategy %s found a feasible trace", new Object[]{this.mStrategy.getName()});
            return feasibilityResult;
        }
        if (feasibilityResult == Script.LBool.UNSAT) {
            this.mLogger.info("Strategy %s found an infeasible trace", new Object[]{this.mStrategy.getName()});
            return this.generateProof();
        }
        throw new UnsupportedOperationException("Unknown LBool: " + feasibilityResult);
    }

    private Script.LBool generateProof() {
        ArrayList<QualifiedTracePredicates> perfectIpps = new ArrayList<QualifiedTracePredicates>();
        ArrayList<QualifiedTracePredicates> imperfectIpps = new ArrayList<QualifiedTracePredicates>();
        while (this.mStrategy.hasNextInterpolantGenerator(perfectIpps, imperfectIpps)) {
            IIpgStrategyModule<?, L> interpolantGenerator = this.tryExecuteInterpolantGenerator();
            if (interpolantGenerator == null) continue;
            Collection<QualifiedTracePredicates> newPeIpSeq = interpolantGenerator.getPerfectInterpolantSequences();
            perfectIpps.addAll(newPeIpSeq);
            Collection<QualifiedTracePredicates> newImIpSeq = interpolantGenerator.getImperfectInterpolantSequences();
            imperfectIpps.addAll(newImIpSeq);
            this.mLogger.info("%s provided %s perfect and %s imperfect interpolant sequences", new Object[]{AutomatonFreeRefinementEngine.getModuleFingerprintString(interpolantGenerator), newPeIpSeq.size(), newImIpSeq.size()});
            interpolantGenerator.aggregateStatistics(this.mRefinementEngineStatistics);
        }
        this.logStats(perfectIpps, imperfectIpps);
        if (!perfectIpps.isEmpty()) {
            this.mSomePerfectSequenceFound = true;
        }
        if (perfectIpps.isEmpty() && imperfectIpps.isEmpty()) {
            this.mLogger.error("Strategy %s failed to provide any proof altough trace is infeasible", new Object[]{this.mStrategy.getName()});
            this.mQualifiedTracePredicates = null;
            return Script.LBool.UNKNOWN;
        }
        this.mQualifiedTracePredicates = DataStructureUtils.concat(perfectIpps, imperfectIpps);
        this.mUsedTracePredicates = this.mQualifiedTracePredicates;
        return Script.LBool.UNSAT;
    }

    private void logStats(List<QualifiedTracePredicates> perfectIpps, List<QualifiedTracePredicates> imperfectIpps) {
        if (!this.mLogger.isInfoEnabled()) {
            return;
        }
        this.mLogger.info("Found %s perfect and %s imperfect interpolant sequences.", new Object[]{perfectIpps.size(), imperfectIpps.size()});
        ArrayList<Integer> numberInterpolantsPerfect = new ArrayList<Integer>();
        HashSet<IPredicate> allInterpolants = new HashSet<IPredicate>();
        for (QualifiedTracePredicates qtp : perfectIpps) {
            numberInterpolantsPerfect.add(new HashSet<IPredicate>(qtp.getPredicates()).size());
            allInterpolants.addAll(qtp.getPredicates());
        }
        ArrayList<Integer> numberInterpolantsImperfect = new ArrayList<Integer>();
        for (QualifiedTracePredicates qtp : imperfectIpps) {
            numberInterpolantsImperfect.add(new HashSet<IPredicate>(qtp.getPredicates()).size());
            allInterpolants.addAll(qtp.getPredicates());
        }
        this.mLogger.info((Object)("Number of different interpolants: perfect sequences " + numberInterpolantsPerfect + " imperfect sequences " + numberInterpolantsImperfect + " total " + allInterpolants.size()));
    }

    private Script.LBool checkFeasibility() {
        while (this.mStrategy.hasNextFeasilibityCheck()) {
            ITraceCheckStrategyModule<L, ?> currentTraceCheck = this.mStrategy.nextFeasibilityCheck();
            this.abortIfTimeout("Timeout during feasibility check between " + this.mUsedTraceCheckFingerprint + " and " + AutomatonFreeRefinementEngine.getModuleFingerprintString(currentTraceCheck));
            this.mUsedTraceCheckFingerprint = AutomatonFreeRefinementEngine.getModuleFingerprintString(currentTraceCheck);
            this.logModule("Using trace check", currentTraceCheck);
            Script.LBool feasibilityResult = currentTraceCheck.isCorrect();
            if (feasibilityResult == Script.LBool.SAT) {
                if (currentTraceCheck.providesRcfgProgramExecution()) {
                    this.mIcfgProgramExecution = currentTraceCheck.getRcfgProgramExecution();
                }
                currentTraceCheck.aggregateStatistics(this.mRefinementEngineStatistics);
                return feasibilityResult;
            }
            if (feasibilityResult == Script.LBool.UNSAT) {
                currentTraceCheck.aggregateStatistics(this.mRefinementEngineStatistics);
                return feasibilityResult;
            }
            this.abortIfNecessaryOnUnknown(currentTraceCheck.getTraceCheckReasonUnknown());
            currentTraceCheck.aggregateStatistics(this.mRefinementEngineStatistics);
        }
        return Script.LBool.UNKNOWN;
    }

    private void abortIfTimeout(String taskDesc) {
        if (!this.mServices.getProgressMonitorService().continueProcessing()) {
            throw new ToolchainCanceledException(this.getClass(), taskDesc);
        }
    }

    private void abortIfNecessaryOnUnknown(TraceCheckReasonUnknown tcra) {
        if (tcra.getException() == null) {
            return;
        }
        TraceCheckReasonUnknown.ExceptionHandlingCategory exceptionCategory = tcra.getExceptionHandlingCategory();
        switch (exceptionCategory) {
            case KNOWN_IGNORE: 
            case KNOWN_DEPENDING: 
            case KNOWN_THROW: {
                if (!this.mLogger.isErrorEnabled()) break;
                this.mLogger.error((Object)("Caught known exception: " + tcra.getException().getMessage()));
                break;
            }
            case UNKNOWN: {
                if (!this.mLogger.isErrorEnabled()) break;
                this.mLogger.error((Object)("Caught unknown exception: " + tcra.getException().getMessage()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown exception category: " + (Object)((Object)exceptionCategory));
            }
        }
        this.throwIfNecessary(tcra.getExceptionHandlingCategory(), tcra.getException());
    }

    private IIpgStrategyModule<?, L> tryExecuteInterpolantGenerator() {
        TraceCheckReasonUnknown.ExceptionHandlingCategory category;
        InterpolantComputationStatus status;
        IIpgStrategyModule<?, L> interpolantGenerator = this.mStrategy.nextInterpolantGenerator();
        this.abortIfTimeout("Timeout during proof generation before using " + AutomatonFreeRefinementEngine.getModuleFingerprintString(interpolantGenerator));
        try {
            this.logModule("Using interpolant generator", interpolantGenerator);
            status = interpolantGenerator.getInterpolantComputationStatus();
            if (status == null) {
                this.mLogger.fatal((Object)"No interpolant computation status provided, assuming failure");
                throw new AssertionError((Object)(interpolantGenerator.getClass() + " provided no interpolant computation status"));
            }
            if (status.wasComputationSuccesful()) {
                return interpolantGenerator;
            }
        }
        catch (ToolchainCanceledException tce) {
            throw tce;
        }
        catch (Exception e) {
            if (TraceCheckReasonUnknown.ExceptionHandlingCategory.UNKNOWN.throwException(this.mStrategy.getExceptionBlacklist())) {
                this.mLogger.fatal((Object)("Exception during interpolant generation: " + e.getClass().getSimpleName()));
                throw e;
            }
            this.mLogger.fatal((Object)"Ignoring exception!", (Throwable)e);
            return null;
        }
        switch (status.getStatus()) {
            case ALGORITHM_FAILED: {
                category = TraceCheckReasonUnknown.ExceptionHandlingCategory.KNOWN_IGNORE;
                break;
            }
            case OTHER: {
                category = TraceCheckReasonUnknown.ExceptionHandlingCategory.UNKNOWN;
                break;
            }
            case SMT_SOLVER_CANNOT_INTERPOLATE_INPUT: {
                category = TraceCheckReasonUnknown.ExceptionHandlingCategory.KNOWN_IGNORE;
                break;
            }
            case SMT_SOLVER_CRASH: {
                category = TraceCheckReasonUnknown.ExceptionHandlingCategory.KNOWN_DEPENDING;
                break;
            }
            case TRACE_FEASIBLE: {
                String msg = String.format("Tracecheck %s said UNSAT, interpolant generator %s failed with %s", new Object[]{this.mUsedTraceCheckFingerprint, AutomatonFreeRefinementEngine.getModuleFingerprintString(interpolantGenerator), status.getStatus()});
                throw new IllegalStateException(msg);
            }
            default: {
                throw new AssertionError((Object)("unknown case : " + (Object)((Object)status.getStatus())));
            }
        }
        this.throwIfNecessary(category, status.getException());
        String message = status.getException() == null ? String.valueOf((Object)status.getStatus()) : status.getException().getMessage();
        this.mLogger.warn((Object)("Interpolation failed due to " + (Object)((Object)category) + ": " + message));
        return null;
    }

    private void throwIfNecessary(TraceCheckReasonUnknown.ExceptionHandlingCategory category, Throwable t) {
        boolean throwException = category.throwException(this.mStrategy.getExceptionBlacklist());
        if (throwException) {
            this.mLogger.warn((Object)"Global settings require throwing the following exception");
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new AssertionError((Object)t);
        }
    }

    private void logModule(String msg, Object module) {
        this.mLogger.info("%s %s", new Object[]{msg, AutomatonFreeRefinementEngine.getModuleFingerprintString(module)});
    }

    private static String getModuleFingerprintString(Object obj) {
        return String.format("%s [%s]", obj.getClass().getSimpleName(), obj.hashCode());
    }

    @Override
    public IRefinementEngineResult<L, Collection<QualifiedTracePredicates>> getResult() {
        return new IRefinementEngineResult.BasicRefinementEngineResult<L, List<QualifiedTracePredicates>>(this.mFeasibility, this.mQualifiedTracePredicates, this.mIcfgProgramExecution, this.mSomePerfectSequenceFound, this.mUsedTracePredicates, (Lazy<IHoareTripleChecker>)new Lazy(this::getHoareTripleChecker), (Lazy<IPredicateUnifier>)new Lazy(this::getPredicateUnifier));
    }
}

