/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling;

import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsElement;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class RefinementEngineStatisticsGenerator
implements IStatisticsDataProvider {
    private final ConstructionCache<RefinementEngineStatisticsDefinitions, Set<IStatisticsDataProvider>> mStats = new ConstructionCache(a -> new HashSet());
    private final ConstructionCache<RefinementEngineStatisticsDefinitions, StatisticsData> mStatsAggregated = new ConstructionCache(a -> new StatisticsData());
    private static final StatisticsType<RefinementEngineStatisticsDefinitions> TYPE = new StatisticsType(RefinementEngineStatisticsDefinitions.class);

    public IStatisticsType getBenchmarkType() {
        return TYPE;
    }

    public void finishRefinementEngineRun() {
        for (Map.Entry entry : this.mStats.entrySet()) {
            StatisticsData aggregatedData = (StatisticsData)this.mStatsAggregated.getOrConstruct((Object)((RefinementEngineStatisticsDefinitions)((Object)entry.getKey())));
            for (IStatisticsDataProvider data : (Set)entry.getValue()) {
                aggregatedData.aggregateBenchmarkData(data);
            }
        }
    }

    public void addStatistics(RefinementEngineStatisticsDefinitions defs, IStatisticsDataProvider stats) {
        if (stats == null) {
            return;
        }
        ((Set)this.mStats.getOrConstruct((Object)defs)).add(stats);
    }

    public Object getValue(String key) {
        RefinementEngineStatisticsDefinitions keyEnum = RefinementEngineStatisticsDefinitions.valueOf(key);
        return this.mStatsAggregated.getOrConstruct((Object)keyEnum);
    }

    public Collection<String> getKeys() {
        return TYPE.getKeys();
    }

    public static enum RefinementEngineStatisticsDefinitions implements IStatisticsElement
    {
        TRACE_CHECK(StatisticsData.class, StatisticsType.STATISTICS_DATA_AGGREGATION, StatisticsType.KEY_BEFORE_DATA),
        INVARIANT_SYNTHESIS(StatisticsData.class, StatisticsType.STATISTICS_DATA_AGGREGATION, StatisticsType.KEY_BEFORE_DATA),
        INTERPOLANT_CONSOLIDATION(StatisticsData.class, StatisticsType.STATISTICS_DATA_AGGREGATION, StatisticsType.KEY_BEFORE_DATA),
        ABSTRACT_INTERPRETATION(StatisticsData.class, StatisticsType.STATISTICS_DATA_AGGREGATION, StatisticsType.KEY_BEFORE_DATA),
        PDR(StatisticsData.class, StatisticsType.STATISTICS_DATA_AGGREGATION, StatisticsType.KEY_BEFORE_DATA),
        ACCELERATED_INTERPOLATION(StatisticsData.class, StatisticsType.STATISTICS_DATA_AGGREGATION, StatisticsType.KEY_BEFORE_DATA),
        SIFA(StatisticsData.class, StatisticsType.STATISTICS_DATA_AGGREGATION, StatisticsType.KEY_BEFORE_DATA);

        private final Class<?> mClazz;
        private final Function<Object, Function<Object, Object>> mAggr;
        private final Function<String, Function<Object, String>> mPrettyprinter;

        private RefinementEngineStatisticsDefinitions(Class<?> clazz, Function<Object, Function<Object, Object>> aggr, Function<String, Function<Object, String>> prettyprinter) {
            this.mClazz = clazz;
            this.mAggr = aggr;
            this.mPrettyprinter = prettyprinter;
        }

        public Object aggregate(Object o1, Object o2) {
            return this.mAggr.apply(o1).apply(o2);
        }

        public String prettyprint(Object o) {
            return this.mPrettyprinter.apply(this.name()).apply(o);
        }
    }
}

