/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.xnf;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.xnf.Cnf;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.xnf.Dnf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class XnfUtils {
    private XnfUtils() {
    }

    static <E> Dnf<E> expandConjunctionSingle(Dnf<E> a, Dnf<E> b) {
        Dnf result = new Dnf();
        for (Collection aItem : a) {
            for (Collection bItem : b) {
                ArrayList resultItem = new ArrayList();
                resultItem.addAll(aItem);
                resultItem.addAll(bItem);
                result.add(resultItem);
            }
        }
        return result;
    }

    @SafeVarargs
    public static <E> Dnf<E> and(IUltimateServiceProvider services, Dnf<E> ... dnfs) {
        boolean firstElement = true;
        Dnf<E> expandedDnf = null;
        Dnf<E>[] dnfArray = dnfs;
        int n = dnfs.length;
        int n2 = 0;
        while (n2 < n) {
            Dnf<E> currentDnf = dnfArray[n2];
            if (!services.getProgressMonitorService().continueProcessing()) {
                throw new ToolchainCanceledException(XnfUtils.class, "transforming conjunction of length " + dnfs.length + " to DNF");
            }
            if (firstElement) {
                expandedDnf = currentDnf;
                firstElement = false;
            } else {
                expandedDnf = XnfUtils.expandConjunctionSingle(currentDnf, expandedDnf);
            }
            ++n2;
        }
        return expandedDnf;
    }

    static <E> Dnf<E> expandCnfToDnf(IUltimateServiceProvider services, Cnf<E> cnf) {
        if (cnf.isEmpty()) {
            List empty = Collections.emptyList();
            return new Dnf(empty);
        }
        boolean firstElement = true;
        Dnf expandedDnf = null;
        for (Collection conjunct : cnf) {
            if (!services.getProgressMonitorService().continueProcessing()) {
                throw new ToolchainCanceledException(XnfUtils.class, "transforming CNF with " + cnf.size() + "conjuncts to DNF");
            }
            if (firstElement) {
                expandedDnf = new Dnf();
                for (Object e : conjunct) {
                    ArrayList conjunctSingleton = new ArrayList();
                    conjunctSingleton.add(e);
                    expandedDnf.add(conjunctSingleton);
                }
                firstElement = false;
                continue;
            }
            expandedDnf = XnfUtils.expandCnfToDnfSingle(services, expandedDnf, conjunct);
        }
        assert (expandedDnf != null);
        return expandedDnf;
    }

    static <E> Dnf<E> expandCnfToDnfSingle(IUltimateServiceProvider services, Dnf<E> dnf, Collection<E> conjunct) {
        Dnf result = new Dnf();
        for (Collection disjunct : dnf) {
            for (E item : conjunct) {
                if (!services.getProgressMonitorService().continueProcessing()) {
                    throw new ToolchainCanceledException(XnfUtils.class, "transforming CNF to DNF");
                }
                ArrayList<E> resultItem = new ArrayList<E>();
                resultItem.addAll(disjunct);
                resultItem.add(item);
                result.add(resultItem);
            }
        }
        return result;
    }
}

