/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import java.math.BigInteger;

public final class ArithmeticUtils {
    private ArithmeticUtils() {
    }

    public static BigInteger euclideanMod(BigInteger dividend, BigInteger divisor) {
        return dividend.mod(divisor.abs());
    }

    public static BigInteger euclideanDiv(BigInteger dividend, BigInteger divisor) {
        BigInteger nonEuclideanQuotient = dividend.divide(divisor);
        BigInteger nonEuclideanRemainder = dividend.remainder(divisor);
        BigInteger result = nonEuclideanRemainder.signum() < 0 ? (divisor.signum() < 0 ? nonEuclideanQuotient.add(BigInteger.ONE) : nonEuclideanQuotient.subtract(BigInteger.ONE)) : nonEuclideanQuotient;
        assert (result.multiply(divisor).add(ArithmeticUtils.euclideanMod(dividend, divisor)).equals(dividend)) : "incorrect euclidean division";
        return result;
    }
}

