/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CombinatoricsUtils {
    private CombinatoricsUtils() {
    }

    public static <T> Set<T> iterateAll(Iterator<T> iter) {
        HashSet<T> res = new HashSet<T>();
        while (iter.hasNext()) {
            res.add(iter.next());
        }
        return res;
    }

    public static <T> Set<T> iterateAll(Iterable<T> iter) {
        HashSet<T> res = new HashSet<T>();
        for (T s : iter) {
            res.add(s);
        }
        return res;
    }

    public static <T> Set<List<T>> getCombinations(List<Collection<T>> values) {
        return CombinatoricsUtils.getCombinations(values, values.size());
    }

    private static <T> Set<List<T>> getCombinations(List<Collection<T>> values, int idx) {
        if (idx == 0) {
            ArrayList singleton = new ArrayList();
            HashSet<List<T>> res = new HashSet<List<T>>();
            res.add(singleton);
            return res;
        }
        Set<List<T>> oldCombinations = CombinatoricsUtils.getCombinations(values, idx - 1);
        HashSet<List<T>> res = new HashSet<List<T>>();
        for (T newValue : values.get(idx - 1)) {
            for (List<T> oldCombination : oldCombinations) {
                ArrayList<T> combination = new ArrayList<T>();
                combination.addAll(oldCombination);
                combination.add(newValue);
                res.add(combination);
            }
        }
        return res;
    }
}

