/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ConstructionCache<K, V>
implements Map<K, V> {
    private final Map<K, V> mMap;
    private final IValueConstruction<K, V> mValueComputation;

    public ConstructionCache(IValueConstruction<K, V> valueConstruction, Map<K, V> backing) {
        this.mValueComputation = valueConstruction;
        this.mMap = backing;
    }

    public ConstructionCache(IValueConstruction<K, V> valueConstruction) {
        this(valueConstruction, new HashMap());
    }

    public V getOrConstruct(K key) {
        V value = this.mMap.get(key);
        if (value == null) {
            value = this.mValueComputation.constructValue(key);
            this.mMap.put(key, value);
        }
        return value;
    }

    @Override
    public int size() {
        return this.mMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.mMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.mMap.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.mMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.mMap.putAll(m);
    }

    @Override
    public void clear() {
        this.mMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.mMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.mMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.mMap.entrySet();
    }

    @FunctionalInterface
    public static interface IValueConstruction<K, V> {
        public V constructValue(K var1);
    }
}

