/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class CoreUtil {
    private static final String PLATFORM_LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String OS = System.getProperty("os.name");
    public static final boolean OS_IS_WINDOWS = OS.toLowerCase().indexOf("win") >= 0;
    public static final String WORKING_DIRECTORY = System.getProperty("user.dir");
    private static final String PATHEXT = System.getenv("PATHEXT");

    public static String getPlatformLineSeparator() {
        return PLATFORM_LINE_SEPARATOR;
    }

    public static String getIsoUtcTimestamp() {
        Instant now = Instant.now();
        DateTimeFormatter format = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.of("UTC"));
        return String.valueOf(format.format(now.truncatedTo(ChronoUnit.SECONDS))) + "Z";
    }

    public static String getIsoUtcTimestampWithUtcOffset() {
        ZonedDateTime zdt = ZonedDateTime.now();
        DateTimeFormatter format = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        return format.format(zdt.truncatedTo(ChronoUnit.SECONDS));
    }

    public static String getUpperToCamelCase(String value) {
        if (value == null) {
            return value;
        }
        if (!value.toUpperCase().equals(value)) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        String[] stringArray = value.split("_");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(Character.toUpperCase(s.charAt(0)));
            if (s.length() > 1) {
                sb.append(s.substring(1).toLowerCase());
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String readGitVersion(ClassLoader cl) {
        Properties properties = new Properties();
        try {
            InputStream prop = cl.getResourceAsStream("version.properties");
            if (prop == null) {
                return String.format("%s-%s-m", "?", "?");
            }
            properties.load(prop);
        }
        catch (IOException iOException) {
            return null;
        }
        String branch = properties.getProperty("git.branch", "?").replace('/', '.');
        String fullHash = properties.getProperty("git.commit.id", "?").replace('/', '.');
        String hash = properties.getProperty("git.commit.id.abbrev", "?");
        String dirty = properties.getProperty("git.dirty", "?");
        String actualBranch = fullHash.equals(branch) ? "?" : branch;
        String format = "true".equals(dirty) ? "%s-%s-m" : "%s-%s";
        return String.format(format, actualBranch, hash);
    }

    public static File findExecutableBinaryOnPath(String name) {
        Predicate<File> funLooksLikeExectuable;
        if (OS_IS_WINDOWS) {
            byte[] exeMagicNumber = new byte[]{77, 90};
            funLooksLikeExectuable = f -> CoreUtil.hasMagicNumber(f, exeMagicNumber) && CoreUtil.hasWindowsExecutableExtensionAndName(f, name);
        } else {
            byte[] elfMagicNumber = new byte[]{127, 69, 76, 70};
            funLooksLikeExectuable = f -> f.getName().equals(name) && CoreUtil.hasMagicNumber(f, elfMagicNumber);
        }
        String[] stringArray = System.getenv("PATH").split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String dirname = stringArray[n2];
            File[] files = new File(dirname).listFiles(f -> f.getName().startsWith(name));
            if (files != null) {
                File[] fileArray = files;
                int n3 = files.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file = fileArray[n4];
                    if (file.isFile() && file.canExecute() && funLooksLikeExectuable.test(file)) {
                        return file;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    private static boolean hasMagicNumber(File file, byte[] magicNumber) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileInputStream input = new FileInputStream(file);){
                byte[] firstBytes = new byte[magicNumber.length];
                input.read(firstBytes);
                return Arrays.equals(firstBytes, magicNumber);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean hasWindowsExecutableExtensionAndName(File file, String name) {
        String filename = file.getName();
        if (PATHEXT == null) {
            return name.equalsIgnoreCase(filename);
        }
        String lcName = name.toLowerCase();
        String lcFilename = filename.toLowerCase();
        String[] stringArray = PATHEXT.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            int idx;
            String ext = stringArray[n2];
            String lcExt = ext.toLowerCase();
            if (lcFilename.endsWith(lcExt) && (idx = lcFilename.lastIndexOf(lcExt)) != -1 && lcName.equals(lcFilename.substring(0, idx))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static File writeFile(File file, String content) throws IOException {
        CoreUtil.writeFile((Writer fw) -> {
            Writer writer = fw.append(content);
        }, false, file);
        return file;
    }

    public static File writeFile(String filename, String content) throws IOException {
        return CoreUtil.writeFile(filename, content, false);
    }

    public static File writeFile(String filename, String[] content) throws IOException {
        return CoreUtil.writeFile(filename, content, false);
    }

    public static File appendFile(String filename, String content) throws IOException {
        return CoreUtil.writeFile(filename, content, true);
    }

    public static File appendFile(String filename, String[] content) throws IOException {
        return CoreUtil.writeFile(filename, content, true);
    }

    private static File writeFile(String filename, String[] content, boolean append) throws IOException {
        if (content == null || content.length == 0) {
            return null;
        }
        File file = CoreUtil.createFile(filename);
        IWriterConsumer funWrite = fw -> {
            String[] stringArray2 = content;
            int n = content.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray2[n2];
                fw.append(line);
                fw.append(PLATFORM_LINE_SEPARATOR);
                ++n2;
            }
        };
        CoreUtil.writeFile(funWrite, append, file);
        return file;
    }

    private static File writeFile(String filename, String content, boolean append) throws IOException {
        if (content == null || content.isEmpty()) {
            return null;
        }
        File file = CoreUtil.createFile(filename);
        CoreUtil.writeFile((Writer fw) -> {
            Writer writer = fw.append(content);
        }, append, file);
        return file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeFile(IWriterConsumer funWrite, boolean append, File file) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            FileOutputStream os = new FileOutputStream(file, append);
            try {
                try (BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));){
                    funWrite.consume(fw);
                    ((Writer)fw).close();
                }
                if (os == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (os == null) throw throwable;
                os.close();
                throw throwable;
            }
            os.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static File createFile(String filename) {
        File parentFile;
        File file = new File(filename);
        if (!file.isDirectory() && (parentFile = file.getParentFile()) != null) {
            parentFile.mkdirs();
        }
        return file;
    }

    public static List<String> readFileLineByLine(String filename) throws IOException {
        ArrayList<String> rtr = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(filename)), "UTF8"));){
            String line = br.readLine();
            while (line != null) {
                rtr.add(line);
                line = br.readLine();
            }
            ArrayList<String> arrayList = rtr;
            return arrayList;
        }
    }

    public static void readFileLineByLine(String filename, Consumer<String> consumer) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(filename)), "UTF8"));){
            String line = br.readLine();
            while (line != null) {
                consumer.accept(line);
                line = br.readLine();
            }
        }
    }

    public static String readFile(String filename) throws IOException {
        StringBuilder sb = new StringBuilder();
        CoreUtil.readFileLineByLine(filename).stream().forEach(line -> {
            StringBuilder stringBuilder2 = sb.append((String)line).append(PLATFORM_LINE_SEPARATOR);
        });
        return sb.toString();
    }

    public static String readFile(File file) throws IOException {
        return CoreUtil.readFile(file.getAbsolutePath());
    }

    public static List<String> readFileLineByLine(File file) throws IOException {
        return CoreUtil.readFileLineByLine(file.getAbsolutePath());
    }

    public static String getFileExtension(File file) {
        assert (file != null);
        assert (file.isFile());
        assert (!file.isDirectory());
        String filename = file.getName();
        int i = filename.lastIndexOf(46);
        if (i > 0) {
            return filename.substring(i + 1);
        }
        return "";
    }

    public static <E> Collection<E> where(Collection<E> collection, Predicate<E> predicate) {
        ArrayList<E> rtr = new ArrayList<E>();
        for (E entry : collection) {
            if (!predicate.test(entry)) continue;
            rtr.add(entry);
        }
        return rtr;
    }

    public static <T, E> Set<T> selectDistinct(Collection<E> collection, IReduce<T, E> reducer) {
        HashSet<T> rtr = new HashSet<T>();
        for (E entry : collection) {
            rtr.add(reducer.reduce(entry));
        }
        return rtr;
    }

    public static <T, E> Collection<T> select(Collection<E> collection, IReduce<T, E> reducer) {
        ArrayList<T> rtr = new ArrayList<T>();
        for (E entry : collection) {
            rtr.add(reducer.reduce(entry));
        }
        return rtr;
    }

    public static <E> Collection<E> flattenMapValuesToCollection(Map<?, E> map) {
        ArrayList<E> rtr = new ArrayList<E>();
        for (Map.Entry<?, E> entry : map.entrySet()) {
            rtr.add(entry.getValue());
        }
        return rtr;
    }

    public static <T, E> T reduce(Set<E> collection, IMapReduce<T, E> reducer) {
        Object lastValue = null;
        for (E entry : collection) {
            lastValue = reducer.reduce(lastValue, entry);
        }
        return lastValue;
    }

    public static <T, E> T reduce(Collection<E> collection, IMapReduce<T, E> reducer) {
        Object lastValue = null;
        for (E entry : collection) {
            lastValue = reducer.reduce(lastValue, entry);
        }
        return lastValue;
    }

    public static StringBuilder indentMultilineString(String original, String indentPrefix, boolean forceRemoveLastLinebreak) {
        String[] splitted;
        StringBuilder sb = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        String[] stringArray = splitted = original.split("\\r?\\n");
        int n = splitted.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(indentPrefix).append(s).append(lineSeparator);
            ++n2;
        }
        char last = original.charAt(original.length() - 1);
        if (forceRemoveLastLinebreak || last != '\n' && last != '\r') {
            sb.replace(sb.length() - lineSeparator.length(), sb.length(), "");
        }
        return sb;
    }

    public static String addIndentation(int indentation, String s) {
        StringBuilder sb = new StringBuilder("");
        int i = 0;
        while (i < indentation) {
            sb.append("    ");
            ++i;
        }
        sb.append(s);
        return sb.toString();
    }

    public static String addFileSeparator(String string) {
        if (string.endsWith(System.getProperty("file.separator"))) {
            return string;
        }
        return String.valueOf(string) + System.getProperty("file.separator");
    }

    public static String getCurrentDateTimeAsString() {
        return new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SSS").format(Calendar.getInstance().getTime());
    }

    public static StringBuilder flatten(String original, String separator) {
        String[] splitted;
        StringBuilder sb = new StringBuilder();
        String[] stringArray = splitted = original.split("\\r?\\n");
        int n = splitted.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(s).append(separator);
            ++n2;
        }
        sb.replace(sb.length() - separator.length(), sb.length(), "");
        return sb;
    }

    public static List<File> flattenDirectories(Collection<File> files) {
        ArrayDeque<File> worklist = new ArrayDeque<File>();
        ArrayList<File> rtr = new ArrayList<File>();
        worklist.addAll(files);
        while (!worklist.isEmpty()) {
            File file = (File)worklist.removeFirst();
            if (file.isFile()) {
                rtr.add(file);
                continue;
            }
            worklist.addAll(Arrays.asList(file.listFiles()));
        }
        return rtr;
    }

    public static <E> Collection<E> firstN(Collection<E> collection, int n) {
        ArrayList<E> rtr = new ArrayList<E>(n);
        int i = 1;
        for (E elem : collection) {
            rtr.add(elem);
            if (n < ++i) break;
        }
        return rtr;
    }

    @SafeVarargs
    public static <T> T[] concatAll(T[] first, T[] ... rest) {
        int totalLength = first.length;
        T[][] TArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            T[] array = TArray[n2];
            totalLength += array.length;
            ++n2;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        T[][] TArray2 = rest;
        int n3 = rest.length;
        int n4 = 0;
        while (n4 < n3) {
            T[] array = TArray2[n4];
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
            ++n4;
        }
        return result;
    }

    public static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public static <T extends Comparable<? super T>> boolean isSorted(Iterable<T> iterable) {
        Iterator<T> iter = iterable.iterator();
        if (!iter.hasNext()) {
            return true;
        }
        Comparable last = (Comparable)iter.next();
        while (iter.hasNext()) {
            Comparable current = (Comparable)iter.next();
            int cmp = last.compareTo(current);
            if (cmp > 0) {
                return false;
            }
            last = current;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean isSorted(Iterable<T> iterable, Comparator<T> comparator) {
        Iterator<T> iter = iterable.iterator();
        if (!iter.hasNext()) {
            return true;
        }
        Comparable last = (Comparable)iter.next();
        while (iter.hasNext()) {
            Comparable current = (Comparable)iter.next();
            if (comparator.compare(last, current) >= 0) {
                return false;
            }
            last = current;
        }
        return true;
    }

    public static <K, V> Map<K, V> constructFilteredMap(Map<K, V> map, Collection<K> filter) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (K key : filter) {
            V value = map.get(key);
            if (value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    public static <E> Set<E> constructHashSet(Iterable<E> iterable) {
        HashSet<E> result = new HashSet<E>();
        for (E element : iterable) {
            result.add(element);
        }
        return result;
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return String.valueOf(bytes) + "B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = String.valueOf((si ? "kMGTPE" : "KMGTPE").charAt(exp - 1)) + (si ? "" : "i");
        return String.format("%.1f%sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String humanReadableNumber(long number) {
        if (number < 1000L) {
            return Long.toString(number);
        }
        int exp = (int)(Math.log(number) / Math.log(1000.0));
        String pre = String.valueOf("KMGTPE".charAt(exp - 1));
        return String.format("%.1f%s", (double)number / Math.pow(1000.0, exp), pre);
    }

    public static String join(Collection<?> collection, String delimiter) {
        StringBuilder builder = new StringBuilder();
        Iterator<?> iter = collection.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) break;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static <T> String join(T[] collection, String delimiter) {
        StringBuilder builder = new StringBuilder();
        T[] TArray = collection;
        int n = collection.length;
        int n2 = 0;
        while (n2 < n) {
            T elem = TArray[n2];
            builder.append(elem);
            builder.append(delimiter);
            ++n2;
        }
        return builder.toString();
    }

    public static String humanReadableTime(long time, TimeUnit unit, int decimal) {
        return CoreUtil.humanReadableTime((double)time, unit, decimal);
    }

    public static String humanReadableTime(double time, TimeUnit unit, int decimal) {
        TimeUnit targetUnit = CoreUtil.findLargestTargetUnit(time, unit);
        return CoreUtil.toTimeString(time, unit, targetUnit, decimal);
    }

    public static String toTimeString(double time, TimeUnit sourceUnit, TimeUnit targetUnit, int decimal) {
        String formatString = "%." + decimal + "f%s";
        return String.format(formatString, CoreUtil.convertTimeUnit(time, sourceUnit, targetUnit), CoreUtil.getTimeUnitSymbol(targetUnit));
    }

    public static String toTimeString(double time, TimeUnit unit) {
        return CoreUtil.toTimeString(time, unit, unit, 2);
    }

    public static double convertTimeUnit(double amount, TimeUnit from, TimeUnit to) {
        if (from == to) {
            return amount;
        }
        if (from.ordinal() < to.ordinal()) {
            return amount / (double)from.convert(1L, to);
        }
        return amount * (double)to.convert(1L, from);
    }

    public static TimeUnit findLargestTargetUnit(double amount, TimeUnit unit) {
        switch (unit) {
            case DAYS: {
                return TimeUnit.DAYS;
            }
            case HOURS: {
                if (amount >= 24.0) {
                    return CoreUtil.findLargestTargetUnit(amount / 24.0, TimeUnit.DAYS);
                }
                return TimeUnit.HOURS;
            }
            case MINUTES: {
                if (amount >= 60.0) {
                    return CoreUtil.findLargestTargetUnit(amount / 60.0, TimeUnit.HOURS);
                }
                return TimeUnit.MINUTES;
            }
            case SECONDS: {
                if (amount >= 60.0) {
                    return CoreUtil.findLargestTargetUnit(amount / 60.0, TimeUnit.MINUTES);
                }
                return TimeUnit.SECONDS;
            }
            case MILLISECONDS: {
                if (amount >= 1000.0) {
                    return CoreUtil.findLargestTargetUnit(amount / 1000.0, TimeUnit.SECONDS);
                }
                return TimeUnit.MILLISECONDS;
            }
            case MICROSECONDS: {
                if (amount >= 1000.0) {
                    return CoreUtil.findLargestTargetUnit(amount / 1000.0, TimeUnit.MILLISECONDS);
                }
                return TimeUnit.MICROSECONDS;
            }
            case NANOSECONDS: {
                if (amount >= 1000.0) {
                    return CoreUtil.findLargestTargetUnit(amount / 1000.0, TimeUnit.NANOSECONDS);
                }
                return TimeUnit.NANOSECONDS;
            }
        }
        throw new UnsupportedOperationException("TimeUnit not yet implemented: " + (Object)((Object)unit));
    }

    public static String getTimeUnitSymbol(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u00b5s";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "m";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
        }
        throw new UnsupportedOperationException("TimeUnit not yet implemented: " + (Object)((Object)unit));
    }

    public static <E> Collection<E> filter(Collection<?> iterable, Class<E> clazz) {
        ArrayList filteredList = new ArrayList();
        for (Object e : iterable) {
            if (!clazz.isAssignableFrom(e.getClass())) continue;
            filteredList.add(e);
        }
        return filteredList;
    }

    public static void deleteDirectory(File folder) {
        CoreUtil.deleteDirectoryContents(folder);
        if (!folder.delete()) {
            folder.deleteOnExit();
        }
    }

    public static void deleteDirectoryContents(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    CoreUtil.deleteDirectory(f);
                } else if (!f.delete()) {
                    f.deleteOnExit();
                }
                ++n2;
            }
        }
    }

    public static void deleteDirectoryContentsIf(File folder, FileFilter filter) {
        File[] files = folder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                boolean shouldDelete = filter.accept(f);
                if (f.isDirectory()) {
                    if (shouldDelete) {
                        CoreUtil.deleteDirectory(f);
                    } else {
                        CoreUtil.deleteDirectoryContentsIf(f, filter);
                    }
                } else if (shouldDelete) {
                    f.delete();
                }
                ++n2;
            }
        }
    }

    public static String alphabeticalSequence(int i) {
        return i < 0 ? "" : String.valueOf(CoreUtil.alphabeticalSequence(i / 26 - 1)) + (char)(65 + i % 26);
    }

    public static String getStackTrace(Throwable t) {
        return CoreUtil.getStackTrace("", t);
    }

    public static String getStackTrace(String indent, Throwable t) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = t.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement elem = stackTraceElementArray[n2];
            sb.append(indent);
            sb.append(String.format("%s%n", elem.toString()));
            ++n2;
        }
        return sb.toString();
    }

    public static String repeat(int n, String s) {
        if (n == 0) {
            return "";
        }
        if (n < 0) {
            throw new IllegalArgumentException("n smaller than zero");
        }
        return new String(new char[n]).replace("\u0000", s);
    }

    @FunctionalInterface
    public static interface IMapReduce<T, K> {
        public T reduce(T var1, K var2);
    }

    @FunctionalInterface
    public static interface IReduce<T, K> {
        public T reduce(K var1);
    }

    @FunctionalInterface
    private static interface IWriterConsumer {
        public void consume(Writer var1) throws IOException;
    }
}

