/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DfsBookkeeping<V> {
    private final List<V> mStack = new ArrayList<V>();
    private final Map<V, Pair<Integer, V>> mVisited2LoopHeadIndex = new HashMap<V, Pair<Integer, V>>();

    public boolean isVisited(V node) {
        return this.mVisited2LoopHeadIndex.containsKey(node);
    }

    public boolean hasStarted() {
        return !this.mVisited2LoopHeadIndex.isEmpty();
    }

    public boolean isStackEmpty() {
        return this.mStack.isEmpty();
    }

    public int stackIndexOf(V node) {
        return this.mStack.indexOf(node);
    }

    public boolean push(V node) {
        boolean visitedBefore = this.isVisited(node);
        if (!visitedBefore) {
            this.mVisited2LoopHeadIndex.put(node, null);
        }
        assert (!this.mStack.contains(node)) : "must not infinitely unroll loop";
        this.mStack.add(node);
        return !visitedBefore;
    }

    public V peek() {
        return this.mStack.get(this.mStack.size() - 1);
    }

    private V pop() {
        return this.mStack.remove(this.mStack.size() - 1);
    }

    public boolean backtrack() {
        V oldNode = this.pop();
        assert (this.isVisited(oldNode)) : "stack node must have been visited";
        Pair<Integer, V> loopHead = this.mVisited2LoopHeadIndex.get(oldNode);
        if (loopHead != null && loopHead.getSecond() == oldNode) {
            this.mVisited2LoopHeadIndex.put(oldNode, null);
            loopHead = null;
        }
        if (loopHead != null) {
            assert (!this.mStack.isEmpty()) : "Initial node must not be in a loop (except as loop head)";
            assert (this.validLoopHead(loopHead)) : "Backtracked node's loop head must be higher on the stack";
            this.updateLoopHead(this.peek(), loopHead);
        }
        return loopHead == null;
    }

    public void updateLoopHead(V node, Pair<Integer, V> newLoopHead) {
        assert (this.mStack.contains(node)) : "loop head can only be updated for stack nodes";
        assert (this.isVisited(node)) : "loop head can only be updated for visited nodes";
        assert (this.validLoopHead(newLoopHead)) : "new loop head is invalid";
        Pair<Integer, V> oldLoopHead = this.mVisited2LoopHeadIndex.get(node);
        assert (oldLoopHead == null || this.validLoopHead(oldLoopHead)) : "old loop head has become invalid";
        if (oldLoopHead == null || newLoopHead.getFirst() < oldLoopHead.getFirst()) {
            this.mVisited2LoopHeadIndex.put((Pair<Integer, V>)node, (Pair<Integer, Pair<Integer, V>>)newLoopHead);
        }
    }

    public void backPropagateLoopHead(V current, V successor) {
        Pair<Integer, V> loopHead = this.getStackedLoopHead(successor);
        if (loopHead != null) {
            this.updateLoopHead(current, loopHead);
        }
    }

    private Pair<Integer, V> getStackedLoopHead(V node) {
        int currentIndex = Integer.MAX_VALUE;
        V currentNode = node;
        while (true) {
            assert (currentIndex >= 0) : "negative loop head index";
            assert (this.isVisited(currentNode)) : "encountered unvisited node in loop head chain";
            Pair<Integer, V> loopHead = this.mVisited2LoopHeadIndex.get(currentNode);
            if (loopHead == null || this.validLoopHead(loopHead)) {
                return loopHead;
            }
            V loopHeadNode = loopHead.getSecond();
            if (loopHeadNode == currentNode) {
                return null;
            }
            assert (loopHead.getFirst() < currentIndex) : "loop head index must decrease";
            currentIndex = loopHead.getFirst();
            currentNode = loopHeadNode;
        }
    }

    private boolean validLoopHead(Pair<Integer, V> loopHead) {
        return loopHead.getFirst() < this.mStack.size() && this.mStack.get(loopHead.getFirst()) == loopHead.getSecond();
    }
}

