/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HistogramOfIterable<E> {
    private final Map<E, Integer> mHistogramMap;
    private final Integer[] mVisualizationArray;

    public HistogramOfIterable(Iterable<E> iterable) {
        this.mHistogramMap = HistogramOfIterable.generateHistogramMap(iterable);
        this.mVisualizationArray = HistogramOfIterable.generateVisualizationArray(this.mHistogramMap);
    }

    public static <E> Integer[] generateVisualizationArray(Map<E, Integer> histogramMap) {
        Integer[] result = histogramMap.values().toArray(new Integer[histogramMap.size()]);
        Arrays.sort(result, Collections.reverseOrder());
        return result;
    }

    public String toString() {
        return Arrays.toString((Object[])this.mVisualizationArray);
    }

    public Integer[] getVisualizationArray() {
        return this.mVisualizationArray;
    }

    public int getMax() {
        return HistogramOfIterable.getMaxOfVisualizationArray(Arrays.asList(this.getVisualizationArray()));
    }

    public static int getMaxOfVisualizationArray(List<Integer> visualizationArray) {
        if (visualizationArray.isEmpty()) {
            return 0;
        }
        return visualizationArray.get(0);
    }

    public static <E> Map<E, Integer> generateHistogramMap(Iterable<E> iterable) {
        HashMap<E, Integer> result = new HashMap<E, Integer>();
        for (E e : iterable) {
            if (result.containsKey(e)) {
                result.put(e, (Integer)result.get(e) + 1);
                continue;
            }
            result.put(e, 1);
        }
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.mHistogramMap);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HistogramOfIterable other = (HistogramOfIterable)obj;
        return Objects.equals(this.mHistogramMap, other.mHistogramMap);
    }
}

