/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import java.util.Arrays;

public class LexicographicCounter {
    private final int[] mNumberOfValues;
    private final int[] mCounter;
    private final int mNumberOfValuesProduct;

    public LexicographicCounter(int[] numberOfValues) {
        this.mNumberOfValues = numberOfValues;
        this.mNumberOfValuesProduct = Arrays.stream(this.mNumberOfValues).reduce(1, (x, y) -> x * y);
        this.mCounter = new int[this.mNumberOfValues.length];
    }

    public int[] getCurrentValue() {
        return this.mCounter;
    }

    public void increment() {
        int i = 0;
        while (i < this.mNumberOfValues.length) {
            int n = i;
            this.mCounter[n] = this.mCounter[n] + 1;
            if (this.mCounter[i] < this.mNumberOfValues[i]) {
                return;
            }
            this.mCounter[i] = 0;
            ++i;
        }
    }

    public boolean isZero() {
        boolean result = Arrays.stream(this.mCounter).allMatch(x -> x == 0);
        return result;
    }

    public int getNumberOfValuesProduct() {
        return this.mNumberOfValuesProduct;
    }

    public String toString() {
        return "Current value=" + Arrays.toString(this.mCounter) + ", mNumberOfValues=" + Arrays.toString(this.mNumberOfValues);
    }
}

