/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ReflectionUtil {
    private static final ExposedSecurityManager EXPOSED_SECURITY_MANAGER = new ExposedSecurityManager();

    private ReflectionUtil() {
    }

    public static Class<?> getCallerClass(int callStackDepth) {
        return EXPOSED_SECURITY_MANAGER.getCallerClass(callStackDepth + 1);
    }

    public static String getCallerMethodName(int callStackDepth) {
        StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
        if (callStack.length < callStackDepth) {
            return callStack[callStack.length - 1].getMethodName();
        }
        return callStack[callStackDepth].getMethodName();
    }

    public static String getCallerSignature(int callStackDepth) {
        StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
        StackTraceElement theFrame = callStack.length < callStackDepth ? callStack[callStack.length - 1] : callStack[callStackDepth];
        return String.format("[L%4s] %s.%s", theFrame.getLineNumber(), ReflectionUtil.getCallerClass(callStackDepth).getName(), theFrame.getMethodName());
    }

    public static String getCallerSignatureFiltered(Set<Class<?>> skippedClasses) {
        StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
        int i = 2;
        while (i < callStack.length) {
            StackTraceElement frame = callStack[i];
            Class<?> callingClass = ReflectionUtil.getCallerClass(i);
            if (!skippedClasses.contains(callingClass)) {
                return String.format("[L%4s] %s.%s", frame.getLineNumber(), frame.getClassName(), frame.getMethodName());
            }
            ++i;
        }
        return null;
    }

    public static void supplyCallStackStrings(Consumer<String> consumer) {
        StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
        int i = 0;
        while (i < callStack.length) {
            StackTraceElement theFrame = callStack[i];
            consumer.accept(String.format("[L%-4s] %30.30s %s", theFrame.getLineNumber(), ReflectionUtil.truncateFromLeft(theFrame.getClassName(), 30), theFrame.getMethodName()));
            ++i;
        }
    }

    private static String truncateFromLeft(String s, int length) {
        return s.length() > length ? s.substring(s.length() - length) : s;
    }

    public static <T> Set<Class<? extends T>> getClassesImplementingInterfaceFromFolder(Class<T> interfaceClazz) {
        if (interfaceClazz == null || !interfaceClazz.isInterface()) {
            throw new IllegalArgumentException(interfaceClazz + " does not represent a Java interface");
        }
        return ReflectionUtil.getClassesFromFolder(interfaceClazz).stream().filter(a -> !ReflectionUtil.isAbstractClass(a)).filter(a -> ReflectionUtil.isClassImplementingInterface(a, interfaceClazz)).collect(Collectors.toSet());
    }

    public static <T> Set<Class<? extends T>> getClassesFromFolder(Class<T> anchorClazz) {
        return ReflectionUtil.getClassesFromFolder(anchorClazz, ReflectionUtil.createBundleResourceConverter());
    }

    public static <T> Set<Class<? extends T>> getClassesFromFolder(Class<T> anchorClazz, UrlConverter resourceConverter) {
        if (anchorClazz == null) {
            return Collections.emptySet();
        }
        HashSet<Class<T>> result = new HashSet<Class<T>>();
        String packageName = anchorClazz.getPackage().getName();
        Collection<File> files = ReflectionUtil.getFolderContentsFromClass(anchorClazz, resourceConverter);
        if (files == null) {
            return Collections.emptySet();
        }
        List<ClassLoader> loaders = ReflectionUtil.getClassLoaders(anchorClazz);
        for (File file : files) {
            Class<?> clazz;
            if (!file.getName().endsWith(".class") || (clazz = ReflectionUtil.getClassFromFile(packageName, file, loaders)) == null) continue;
            result.add(clazz);
        }
        return result;
    }

    public static <T> T instantiateClass(Class<T> clazz, Object ... params) {
        ConstructorAndRemainingParameters<T> constructors = ReflectionUtil.getConstructorsForClass(clazz, params);
        return constructors.instantiate();
    }

    public static <T> Supplier<T> getInstanceSupplier(Class<T> clazz, Object ... params) {
        ConstructorAndRemainingParameters constructors = ReflectionUtil.getConstructorsForClass(clazz, params);
        return () -> constructors.instantiate();
    }

    public static boolean isAbstractClass(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isClassImplementingInterface(Class<?> clazzIn, Class<?> interfaceClazz) {
        if (interfaceClazz == null || !interfaceClazz.isInterface()) {
            throw new IllegalArgumentException("interfaceClazz does not represent an interface");
        }
        Class<?> clazz = clazzIn;
        while (clazz != null) {
            Class<?>[] implementedInterfaces;
            Class<?>[] classArray = implementedInterfaces = clazz.getInterfaces();
            int n = implementedInterfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interFace = classArray[n2];
                if (interFace.equals(interfaceClazz)) {
                    return true;
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static boolean isSubclassOfClass(Class<?> clazzIn, Class<?> superClazz) {
        if (superClazz == null) {
            throw new IllegalArgumentException("superClazz is null");
        }
        if (Modifier.isFinal(superClazz.getModifiers())) {
            return false;
        }
        if (clazzIn == null) {
            return true;
        }
        return superClazz.isAssignableFrom(clazzIn);
    }

    public static File getClassFolder(Class<?> clazz, UrlConverter resourceConverter) {
        String name = clazz.getPackage().getName();
        ClassLoader loader = ReflectionUtil.getClassLoader(clazz);
        URL url = loader.getResource(name);
        return ReflectionUtil.tryConvertUrlToFile(loader, url, resourceConverter);
    }

    public static List<Field> instanceFields(Class<? extends Object> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz.getSuperclass() != null) {
            Arrays.stream(clazz.getDeclaredFields()).filter(ReflectionUtil::isIncluded).forEach(fields::add);
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static List<Field> instanceFields(Object obj) {
        if (obj == null) {
            return Collections.emptyList();
        }
        Class<?> clazz = obj.getClass();
        return ReflectionUtil.instanceFields(clazz);
    }

    public static Map<String, Field> instanceName2Fields(Class<? extends Object> clazz) {
        return ReflectionUtil.instanceFields(clazz).stream().collect(Collectors.toMap(Field::getName, f -> f));
    }

    public static Map<String, Field> instanceName2Fields(Object obj) {
        if (obj == null) {
            return Collections.emptyMap();
        }
        Class<?> clazz = obj.getClass();
        return ReflectionUtil.instanceName2Fields(clazz);
    }

    public static String instanceFieldsToString(Object obj) {
        if (obj == null) {
            return "NULL";
        }
        List<Field> fields = ReflectionUtil.instanceFields(obj);
        return fields.stream().filter(a -> !a.getName().startsWith("$")).filter(a -> !ReflectionUtil.isExcluded(a)).map(a -> ReflectionUtil.fieldToString(obj, a)).collect(Collectors.joining(", "));
    }

    private static boolean isExcluded(Field f) {
        Reflected annot = f.getAnnotation(Reflected.class);
        return annot != null && annot.excluded();
    }

    private static boolean isIncluded(Field f) {
        return !ReflectionUtil.isExcluded(f);
    }

    public static String fieldPrettyName(Field f) {
        Reflected annot = f.getAnnotation(Reflected.class);
        if (annot != null && !"".equals(annot.prettyName())) {
            return annot.prettyName();
        }
        return f.getName();
    }

    public static String fieldToString(Object obj, Field f) {
        String val;
        try {
            f.setAccessible(true);
            val = String.valueOf(f.get(obj));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            val = "IArE";
        }
        catch (IllegalAccessException illegalAccessException) {
            val = "IAcE";
        }
        return String.format("%s=%s", ReflectionUtil.fieldPrettyName(f), val);
    }

    public static Object access(Object obj, Field f) {
        try {
            f.setAccessible(true);
            return f.get(obj);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static String printableStackTrace() {
        return Arrays.toString(Thread.currentThread().getStackTrace());
    }

    private static UrlConverter createBundleResourceConverter() {
        try {
            List<ClassLoader> loaders = ReflectionUtil.getClassLoaders(ReflectionUtil.class);
            for (ClassLoader loader : loaders) {
                Class<?> clazz = ReflectionUtil.getClassFromQualifiedName("de.uni_freiburg.informatik.ultimate.core.util.RcpUtils", loader);
                if (clazz == null) continue;
                Method method = clazz.getMethod("getBundleProtocolResolver", new Class[0]);
                return (UrlConverter)method.invoke(null, new Object[0]);
            }
            throw new ReflectionUtilException("Could not extract Class<?> from qualified name de.uni_freiburg.informatik.ultimate.core.util.RcpUtils");
        }
        catch (ReflectionUtilException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return null;
        }
    }

    private static <T> ConstructorAndRemainingParameters<T> getConstructorsForClass(Class<T> clazz, Object ... params) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        try {
            Object[] newParams;
            Constructor<?>[] constructors = clazz.getDeclaredConstructors();
            if (constructors.length == 0) {
                throw new ReflectionUtilException("Cannot instantiate class " + clazz.toString() + " because it has no constructors");
            }
            if (clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
                Class<?> enclosingClazz = clazz.getEnclosingClass();
                ConstructorAndRemainingParameters<?> enclosingClazzConstructor = ReflectionUtil.getConstructorsForClass(enclosingClazz, params);
                Object enclosingClazzInstance = enclosingClazzConstructor.instantiate();
                Object[] remainingParams = enclosingClazzConstructor.mUnusedParameters;
                if (remainingParams == null || remainingParams.length == 0) {
                    newParams = new Object[]{enclosingClazzInstance};
                } else {
                    newParams = new Object[remainingParams.length + 1];
                    newParams[0] = enclosingClazzInstance;
                    System.arraycopy(remainingParams, 0, newParams, 1, remainingParams.length);
                }
            } else {
                newParams = params;
            }
            List constructorCandidates = Arrays.stream(constructors).filter(a -> a.getParameterCount() <= newParams.length).collect(Collectors.toList());
            if (constructorCandidates.isEmpty()) {
                throw new ReflectionUtilException("Cannot instantiate class " + clazz.toString() + " because there is no constructor that takes " + newParams.length + " arguments");
            }
            int maxMatch = -1;
            Constructor candidateConstructor = null;
            for (Constructor current : constructorCandidates) {
                Parameter[] parameters = current.getParameters();
                int matched = 0;
                Parameter[] parameterArray = parameters;
                int n = parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> suppliedType;
                    Class<?> wrappedAvailableType;
                    Parameter parameter = parameterArray[n2];
                    Class<?> availableType = parameter.getType();
                    if ((newParams[matched] != null || availableType.isPrimitive()) && !(wrappedAvailableType = ReflectionUtil.toWrapperClazz(availableType)).isAssignableFrom(suppliedType = newParams[matched].getClass())) {
                        matched = -1;
                        break;
                    }
                    ++matched;
                    ++n2;
                }
                if (matched <= maxMatch) continue;
                maxMatch = matched;
                candidateConstructor = current;
            }
            if (candidateConstructor == null) {
                throw new ReflectionUtilException("Cannot instantiate class " + clazz.toString() + " because I did not find a valid constructor");
            }
            Object[] usedParams = new Object[maxMatch];
            Object[] remainingParams = new Object[newParams.length - maxMatch];
            System.arraycopy(newParams, 0, usedParams, 0, maxMatch);
            System.arraycopy(newParams, maxMatch, remainingParams, 0, newParams.length - maxMatch);
            return new ConstructorAndRemainingParameters<T>(candidateConstructor, clazz, usedParams, remainingParams);
        }
        catch (SecurityException e) {
            throw new ReflectionUtilException("Cannot instantiate class " + clazz.toString() + " because I am not allowed to access it", e);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError("Cannot instantiate class " + clazz.toString() + " because the parameters do not match", e);
        }
    }

    private static Collection<File> getFilesFromDirectoryResource(ClassLoader loader, URL url, UrlConverter resourceConverter) {
        File dirFile = ReflectionUtil.tryConvertUrlToFile(loader, url, resourceConverter);
        if (dirFile == null) {
            return Collections.emptyList();
        }
        return CoreUtil.flattenDirectories(Collections.singleton(dirFile));
    }

    private static File tryConvertUrlToFile(ClassLoader loader, URL url, UrlConverter resourceConverter) {
        String protocol = url.getProtocol();
        if ("file".equals(protocol)) {
            try {
                return new File(url.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
        if (!"bundleresource".equals(protocol)) {
            throw new UnsupportedOperationException("unknown protocol " + protocol);
        }
        if (resourceConverter == null) {
            throw new AssertionError((Object)"Someone supplied a bundleresource resource but we do not have a converter -- check if this deployable is built correctly (maybe de.uni_freiburg.informatik.ultimate.core is missing?)");
        }
        try {
            URL fileUrl = resourceConverter.convert(url);
            return new File(fileUrl.getFile());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static Class<?> getClassFromFile(String packageName, File file, Collection<ClassLoader> loaders) {
        String qualifiedName = ReflectionUtil.getQualifiedNameFromFile(packageName, file);
        if (loaders.isEmpty()) {
            return ReflectionUtil.getClassFromQualifiedName(qualifiedName);
        }
        for (ClassLoader loader : loaders) {
            Class<?> clazz = ReflectionUtil.getClassFromQualifiedName(qualifiedName, loader);
            if (clazz == null) continue;
            return clazz;
        }
        throw new ReflectionUtilException("Could not extract Class<?> from qualified name " + qualifiedName);
    }

    private static Class<?> getClassFromQualifiedName(String qualifiedName) {
        try {
            return Class.forName(qualifiedName);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionUtilException("Could not extract Class<?> from qualified name " + qualifiedName, e);
        }
    }

    private static Class<?> getClassFromQualifiedName(String qualifiedName, ClassLoader loader) {
        try {
            return Class.forName(qualifiedName, true, loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static String getQualifiedNameFromFile(String packageName, File file) {
        assert (file != null);
        assert (file.getName().endsWith(".class"));
        String fullname = file.getAbsolutePath();
        String filenameWithoutSuffix = fullname.substring(0, fullname.length() - 6);
        String knownPath = ReflectionUtil.getPathFromPackageName(packageName);
        int validAfter = filenameWithoutSuffix.indexOf(knownPath);
        assert (validAfter != -1);
        return filenameWithoutSuffix.substring(validAfter).replace(File.separatorChar, '.');
    }

    private static String getPathFromPackageName(String packageName) {
        return packageName.replace(".", File.separator);
    }

    private static ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader loader = clazz.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
            while (loader != null && loader.getParent() != null) {
                loader = loader.getParent();
            }
        }
        return loader;
    }

    private static List<ClassLoader> getClassLoaders(Class<?> clazz) {
        ArrayList<ClassLoader> rtr = new ArrayList<ClassLoader>();
        ClassLoader loader = clazz.getClassLoader();
        while (loader != null) {
            rtr.add(loader);
            loader = loader.getParent();
        }
        loader = ClassLoader.getSystemClassLoader();
        while (loader != null) {
            rtr.add(loader);
            loader = loader.getParent();
        }
        return rtr;
    }

    private static Collection<File> getFolderContentsFromClass(Class<?> clazz, UrlConverter resourceConverter) {
        Enumeration<URL> resourceUrlsIter;
        if (clazz == null) {
            return null;
        }
        ClassLoader loader = ReflectionUtil.getClassLoader(clazz);
        if (loader == null) {
            return Collections.emptyList();
        }
        String packageName = clazz.getPackage().getName();
        String packagePath = ReflectionUtil.getPathFromPackageName(packageName);
        try {
            resourceUrlsIter = loader.getResources(packagePath);
        }
        catch (IOException e) {
            throw new ReflectionUtilException("Classloader " + loader.toString() + " could not load resource " + packagePath, e);
        }
        ArrayList<File> rtr = new ArrayList<File>();
        while (resourceUrlsIter.hasMoreElements()) {
            URL resourceUrl = resourceUrlsIter.nextElement();
            rtr.addAll(ReflectionUtil.getFilesFromDirectoryResource(loader, resourceUrl, resourceConverter));
        }
        return rtr;
    }

    private static Class<?> toWrapperClazz(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        throw new UnsupportedOperationException("Not yet implemented: wrapper for " + clazz);
    }

    private static final class ConstructorAndRemainingParameters<T> {
        private final Constructor<T> mConstructor;
        private final Class<T> mClazz;
        private final Object[] mMatchedParameters;
        private final Object[] mUnusedParameters;

        private ConstructorAndRemainingParameters(Constructor<T> constructor, Class<T> clazz, Object[] matchedParameters, Object[] remainingParameters) {
            this.mConstructor = constructor;
            this.mClazz = clazz;
            this.mMatchedParameters = matchedParameters;
            this.mUnusedParameters = remainingParameters;
        }

        public T instantiate() {
            assert (this.mConstructor.getParameterCount() == this.mMatchedParameters.length) : "Wrong length";
            try {
                return this.mConstructor.newInstance(this.mMatchedParameters);
            }
            catch (IllegalAccessException | InstantiationException | SecurityException e) {
                throw new ReflectionUtilException("Cannot instantiate class " + this.mClazz.toString() + " because I am not allowed to access it", e);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError("Cannot instantiate class " + this.mClazz.toString() + " because the parameters do not match", e);
            }
            catch (InvocationTargetException e) {
                throw new ReflectionUtilException("Cannot instantiate class " + this.mClazz.toString() + " because the constructor threw an exception", e);
            }
        }
    }

    private static final class ExposedSecurityManager
    extends SecurityManager {
        private ExposedSecurityManager() {
        }

        public Class<?> getCallerClass(int callStackDepth) {
            return this.getClassContext()[callStackDepth];
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Reflected {
        public boolean excluded() default false;

        public String prettyName() default "";
    }

    private static final class ReflectionUtilException
    extends RuntimeException {
        private static final long serialVersionUID = -5821955867584671607L;

        public ReflectionUtilException(String message) {
            super(message);
        }

        public ReflectionUtilException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @FunctionalInterface
    public static interface UrlConverter {
        public URL convert(URL var1) throws IOException;
    }
}

