/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import java.util.HashMap;
import java.util.Map;

public class TgfBuilder<N> {
    private final StringBuilder mTgfNodes = new StringBuilder();
    private final StringBuilder mTgfEdges = new StringBuilder();
    private final Map<N, Integer> mNodeToId = new HashMap<N, Integer>();

    public TgfBuilder<N> addEdge(N sourceNode, Object edgeLabel, N targetNode) {
        this.mTgfEdges.append(this.nodeId(sourceNode)).append(' ').append(this.nodeId(targetNode)).append(' ').append(TgfBuilder.labelOf(edgeLabel)).append('\n');
        return this;
    }

    public TgfBuilder<N> addDisconnectedNode(N node) {
        this.nodeId(node);
        return this;
    }

    private int nodeId(N node) {
        return this.mNodeToId.computeIfAbsent(node, this::computeNewNodeIdAndAddToTgf);
    }

    private int computeNewNodeIdAndAddToTgf(N node) {
        int id = this.mNodeToId.size();
        this.mTgfNodes.append(id).append(' ').append(TgfBuilder.labelOf(node)).append('\n');
        return id;
    }

    private static String labelOf(Object nodeOrEdge) {
        return nodeOrEdge.toString().replace('\n', '@');
    }

    public String toString() {
        return this.mTgfNodes + "#\n" + this.mTgfEdges;
    }

    public void reset() {
        this.mTgfNodes.setLength(0);
        this.mTgfEdges.setLength(0);
        this.mNodeToId.clear();
    }
}

