/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.HashDeque;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.LinkedHashRelation;
import de.uni_freiburg.informatik.ultimate.util.scc.DefaultSccComputation;
import de.uni_freiburg.informatik.ultimate.util.scc.SccComputation;
import de.uni_freiburg.informatik.ultimate.util.scc.StronglyConnectedComponent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class TransitiveClosure {
    private TransitiveClosure() {
    }

    public static <NODE, LABEL> Map<NODE, Set<LABEL>> computeClosure(ILogger logger, Set<NODE> allNodes, Function<NODE, Set<LABEL>> initialLabeling, SccComputation.ISuccessorProvider<NODE> graphSuccessorProvider) {
        int numberOfAllNodes = allNodes.size();
        Set<NODE> startNodes = allNodes;
        DefaultSccComputation<NODE> dssc = new DefaultSccComputation<NODE>(logger, graphSuccessorProvider, numberOfAllNodes, startNodes);
        LinkedHashRelation<StronglyConnectedComponent, Object> sccToLabel = new LinkedHashRelation<StronglyConnectedComponent, Object>();
        for (StronglyConnectedComponent scc : dssc.getSCCs()) {
            for (Object procInfo : scc.getNodes()) {
                for (LABEL modGlobal : initialLabeling.apply(procInfo)) {
                    sccToLabel.addPair(scc, modGlobal);
                }
            }
        }
        HashDeque<Object> frontier = new HashDeque<Object>();
        frontier.addAll(dssc.getRootComponents());
        while (!frontier.isEmpty()) {
            StronglyConnectedComponent currentScc = (StronglyConnectedComponent)frontier.pollFirst();
            Set currentSccModGlobals = sccToLabel.getImage(currentScc);
            Iterator<StronglyConnectedComponent> callers = dssc.getComponentsSuccessorsProvider().getSuccessors(currentScc);
            while (callers.hasNext()) {
                StronglyConnectedComponent caller = callers.next();
                assert (!caller.equals(currentScc)) : "graph not irreflexive, but must be acyclic";
                frontier.add(caller);
                for (Object currentSccModGlobal : currentSccModGlobals) {
                    sccToLabel.addPair(caller, currentSccModGlobal);
                }
            }
        }
        HashMap closedProcToModGlobals = new HashMap();
        for (NODE procInfo : allNodes) {
            Set currModClause = sccToLabel.getImage((StronglyConnectedComponent)dssc.getNodeToComponents().get(procInfo));
            closedProcToModGlobals.put(procInfo, currModClause);
        }
        return closedProcToModGlobals;
    }
}

