/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.csv;

import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderTransformer;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class CsvProviderAggregator<T>
implements ICsvProviderTransformer<T> {
    private final Map<String, Aggregation> mColumn2aggregation;
    private final String mCountColumnTitle;

    public CsvProviderAggregator(Map<String, Aggregation> column2aggregation) {
        this(column2aggregation, null);
    }

    public CsvProviderAggregator(Map<String, Aggregation> column2aggregation, String countColumnTitle) {
        this.mColumn2aggregation = column2aggregation;
        this.mCountColumnTitle = countColumnTitle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ICsvProvider<T> transform(ICsvProvider<T> csv) {
        ArrayList<String> columnTitlesEnhanced;
        List<String> rowHeaders = csv.getRowHeaders();
        int rows = rowHeaders.size();
        ArrayList<String> columnTitles = new ArrayList<String>();
        if (rows == 0) {
            return new SimpleCsvProvider(columnTitles);
        }
        int columnsOld = csv.getColumnTitles().size();
        boolean[] useColumn = new boolean[columnsOld];
        int index = 0;
        for (String columnTitle : csv.getColumnTitles()) {
            Aggregation aggregation = this.mColumn2aggregation.get(columnTitle);
            if (aggregation == null) {
                System.err.println("Ignoring column " + columnTitle + " which was not specified.");
                this.mColumn2aggregation.put(columnTitle, Aggregation.IGNORE);
            } else if (aggregation != Aggregation.IGNORE) {
                columnTitles.add(columnTitle);
                useColumn[index] = true;
            }
            ++index;
        }
        columnTitles.trimToSize();
        this.isCountColumnFresh(columnTitles);
        List<T> aggRow = this.filter(csv.getRow(0), useColumn, columnTitles.size());
        int i = 1;
        while (i < rows) {
            List<T> row = csv.getRow(i);
            List<T> filteredRow = this.filter(row, useColumn, columnTitles.size());
            this.aggregateRows(aggRow, filteredRow, columnTitles, i);
            ++i;
        }
        if (this.mCountColumnTitle != null) {
            columnTitlesEnhanced = new ArrayList(columnTitles.size() + 1);
            int i2 = 0;
            while (i2 < columnTitles.size()) {
                columnTitlesEnhanced.add(columnTitles.get(i2));
                ++i2;
            }
            columnTitlesEnhanced.add(this.mCountColumnTitle);
            if (csv.getRow(0).isEmpty() || !(csv.getRow(0).get(0) instanceof String)) throw new IllegalArgumentException("Aggregation with adding a count column only works if the CSV has type String.");
            aggRow.add(Integer.toString(rowHeaders.size()));
        } else {
            columnTitlesEnhanced = columnTitles;
        }
        SimpleCsvProvider<T> result = new SimpleCsvProvider<T>(columnTitlesEnhanced);
        String rowHeader = rowHeaders.get(0);
        result.addRow(rowHeader, aggRow);
        return result;
    }

    private void aggregateRows(List<T> aggregatedRow, List<T> singleRow, List<String> columnTitles, int numberOfAggregationsSoFar) {
        ListIterator<T> aggIt = aggregatedRow.listIterator();
        ListIterator<T> singleIt = singleRow.listIterator();
        ListIterator<String> columnTitlesIt = columnTitles.listIterator();
        int i = 0;
        while (i < aggregatedRow.size()) {
            T aggEntry = aggIt.next();
            T singleEntry = singleIt.next();
            String columnTitle = columnTitlesIt.next();
            Aggregation agg = this.mColumn2aggregation.get(columnTitle);
            assert (agg != null);
            switch (agg) {
                case AVERAGE: {
                    aggIt.set(this.getAverage(aggEntry, singleEntry, numberOfAggregationsSoFar));
                    break;
                }
                case SUM: {
                    aggIt.set(this.getSum(aggEntry, singleEntry, numberOfAggregationsSoFar));
                    break;
                }
                case IGNORE: {
                    assert (false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown aggregation mode: " + (Object)((Object)agg));
                }
            }
            ++i;
        }
    }

    private List<T> filter(List<T> row, boolean[] useColumn, int length) {
        int i = 0;
        ArrayList<T> result = new ArrayList<T>(length);
        for (T entry : row) {
            assert (i < useColumn.length);
            if (useColumn[i]) {
                result.add(entry);
            }
            ++i;
        }
        return result;
    }

    private T getAverage(T aggEntryRaw, T singleEntryRaw, int numberOfSamples) {
        double aggEntry = Double.parseDouble(aggEntryRaw.toString());
        double singleEntry = Double.parseDouble(singleEntryRaw.toString());
        double result = aggEntry + 1.0 / (double)(numberOfSamples + 1) * (singleEntry - aggEntry);
        return this.getTypeFromDouble(result, aggEntryRaw);
    }

    private T getSum(T aggEntryRaw, T singleEntryRaw, int numberOfSamples) {
        double aggEntry = Double.parseDouble(aggEntryRaw.toString());
        double singleEntry = Double.parseDouble(singleEntryRaw.toString());
        double result = aggEntry + singleEntry;
        return this.getTypeFromDouble(result, aggEntryRaw);
    }

    private T getTypeFromDouble(Double d, T typeSample) {
        if (typeSample instanceof Double) {
            return (T)d;
        }
        if (typeSample instanceof String) {
            return (T)BigDecimal.valueOf(d).toPlainString();
        }
        throw new IllegalArgumentException("Received data not of type Double but of type " + typeSample.getClass().toGenericString());
    }

    private void isCountColumnFresh(ArrayList<String> columnTitles) {
        if (this.mCountColumnTitle != null && columnTitles.contains(this.mCountColumnTitle)) {
            throw new IllegalArgumentException();
        }
    }

    public static enum Aggregation {
        AVERAGE,
        SUM,
        IGNORE;

    }
}

