/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.csv;

import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderTransformer;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class CsvProviderColumnFilter<T>
implements ICsvProviderTransformer<T> {
    private final Predicate<String> mPredicate;

    public CsvProviderColumnFilter(Predicate<String> predicate) {
        this.mPredicate = predicate;
    }

    @Override
    public ICsvProvider<T> transform(ICsvProvider<T> csvProvider) {
        List<String> oldColumnTitles = csvProvider.getColumnTitles();
        ArrayList<String> newColumnTitles = new ArrayList<String>(oldColumnTitles.size());
        boolean[] retainedColumnsMask = new boolean[oldColumnTitles.size()];
        Iterator<String> colIt = oldColumnTitles.iterator();
        int i = 0;
        while (i < retainedColumnsMask.length) {
            String oldColumnTitle = colIt.next();
            if (this.mPredicate.test(oldColumnTitle)) {
                newColumnTitles.add(oldColumnTitle);
                retainedColumnsMask[i] = true;
            }
            ++i;
        }
        newColumnTitles.trimToSize();
        if (newColumnTitles.size() == oldColumnTitles.size()) {
            return csvProvider;
        }
        SimpleCsvProvider result = new SimpleCsvProvider(newColumnTitles);
        int i2 = 0;
        while (i2 < csvProvider.getRowHeaders().size()) {
            ArrayList<T> newRow = new ArrayList<T>();
            List<T> row = csvProvider.getRow(i2);
            Iterator<T> rowIt = row.iterator();
            int j = 0;
            while (j < row.size()) {
                T elem = rowIt.next();
                if (retainedColumnsMask[j]) {
                    newRow.add(elem);
                }
                ++j;
            }
            result.addRow(newRow);
            ++i2;
        }
        return result;
    }

    public static class NameFilter
    implements Predicate<String> {
        private final Collection<String> mFilterNames;

        public NameFilter(Collection<String> allowedNames) {
            this.mFilterNames = allowedNames;
        }

        @Override
        public boolean test(String name) {
            return this.mFilterNames.contains(name);
        }
    }
}

