/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.csv;

import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderTransformer;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CsvProviderColumnSwapper<T>
implements ICsvProviderTransformer<T> {
    private final Map<String, Integer> mArchetypeColumnTitle2index;
    private final List<String> mArchetypeColumnTitles;

    public CsvProviderColumnSwapper(List<String> archetypeColumnTitles) {
        this(CsvProviderColumnSwapper.list2map(archetypeColumnTitles), archetypeColumnTitles);
    }

    public CsvProviderColumnSwapper(Map<String, Integer> archetypeColumnTitle2index) {
        this(archetypeColumnTitle2index, CsvProviderColumnSwapper.map2list(archetypeColumnTitle2index));
    }

    private CsvProviderColumnSwapper(Map<String, Integer> archetypeColumnTitle2index, List<String> archetypeColumnTitles) {
        this.mArchetypeColumnTitle2index = archetypeColumnTitle2index;
        this.mArchetypeColumnTitles = archetypeColumnTitles;
    }

    private static final Map<String, Integer> list2map(List<String> archetypeColumnTitles) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Iterator<String> iterator = archetypeColumnTitles.iterator();
        int i = 0;
        while (i < archetypeColumnTitles.size()) {
            map.put(iterator.next(), i);
            ++i;
        }
        return map;
    }

    private static final List<String> map2list(Map<String, Integer> archetypeColumnTitle2index) {
        ArrayList<String> result = new ArrayList<String>(archetypeColumnTitle2index.size());
        for (Map.Entry<String, Integer> entry : archetypeColumnTitle2index.entrySet()) {
            int index = entry.getValue();
            if (index < 0 || index >= result.size()) {
                throw new IllegalArgumentException("Illegal index, value was " + index + ", allowed range was [0, " + (result.size() - 1) + "].");
            }
            result.set(index, entry.getKey());
        }
        return result;
    }

    @Override
    public ICsvProvider<T> transform(ICsvProvider<T> csvProvider) {
        List<String> oldColumnTitles = csvProvider.getColumnTitles();
        int[] new2oldIndex = new int[this.mArchetypeColumnTitle2index.size()];
        int oldIndex = 0;
        boolean swapNeeded = false;
        for (String columnTitle : oldColumnTitles) {
            int newIndex = this.mArchetypeColumnTitle2index.get(columnTitle);
            if (oldIndex != newIndex) {
                swapNeeded = true;
            }
            new2oldIndex[newIndex] = oldIndex++;
        }
        if (!swapNeeded) {
            return csvProvider;
        }
        SimpleCsvProvider result = new SimpleCsvProvider(new ArrayList<String>(this.mArchetypeColumnTitles));
        int i = 0;
        while (i < csvProvider.getRowHeaders().size()) {
            Object[] oldRow = csvProvider.getRow(i).toArray();
            ArrayList<Object> newRow = new ArrayList<Object>(oldRow.length);
            int j = 0;
            while (j < oldRow.length) {
                newRow.add(oldRow[new2oldIndex[j]]);
                ++j;
            }
            ++i;
        }
        return result;
    }
}

