/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.csv;

import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderTransformer;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Predicate;

public class CsvProviderPartition<T> {
    private Collection<ICsvProvider<T>> mCsvs;

    public CsvProviderPartition(Collection<ICsvProvider<T>> csvPartition) {
        this.mCsvs = csvPartition;
    }

    public CsvProviderPartition(ICsvProvider<T> csv, String column) {
        this.mCsvs = this.groupByColumnKeyAndThreshold(csv, column, null);
    }

    public CsvProviderPartition(ICsvProvider<T> csv, String column, int[] thresholds) {
        this.mCsvs = this.groupByColumnKeyAndThreshold(csv, column, thresholds);
    }

    public Iterable<ICsvProvider<T>> getCsvs() {
        return this.mCsvs;
    }

    public int size() {
        return this.mCsvs.size();
    }

    public ICsvProvider<T> toCsvProvider() {
        if (this.mCsvs.isEmpty()) {
            return new SimpleCsvProvider(Collections.emptyList());
        }
        SimpleCsvProvider<T> result = new SimpleCsvProvider<T>(this.mCsvs.iterator().next().getColumnTitles());
        for (ICsvProvider<T> csv : this.mCsvs) {
            int numberOfRows = csv.getRowHeaders().size();
            int i = 0;
            while (i < numberOfRows) {
                result.addRow(csv.getRowHeaders().get(i), csv.getRow(i));
                ++i;
            }
        }
        return result;
    }

    public CsvProviderPartition<T> copy() {
        ArrayList<ICsvProvider<T>> partitionCopy = new ArrayList<ICsvProvider<T>>();
        for (ICsvProvider<T> csv : this.mCsvs) {
            SimpleCsvProvider<T> csvCopy = new SimpleCsvProvider<T>(csv.getColumnTitles());
            partitionCopy.add(csvCopy);
            int numberOfRows = csv.getRowHeaders().size();
            int i = 0;
            while (i < numberOfRows) {
                csvCopy.addRow(new ArrayList<T>(csv.getRow(i)));
                ++i;
            }
        }
        return new CsvProviderPartition<T>(partitionCopy);
    }

    public void transform(ICsvProviderTransformer<T> transformer) {
        ArrayList<ICsvProvider<T>> transformedCsvs = new ArrayList<ICsvProvider<T>>(this.mCsvs.size());
        for (ICsvProvider<T> csv : this.mCsvs) {
            transformedCsvs.add(transformer.transform(csv));
        }
        this.mCsvs = transformedCsvs;
    }

    public void filterGroups(Predicate<ICsvProvider<T>> predicate) {
        ArrayList<ICsvProvider<T>> filteredCsvs = new ArrayList<ICsvProvider<T>>(this.mCsvs.size());
        for (ICsvProvider<T> csv : this.mCsvs) {
            if (!predicate.test(csv)) continue;
            filteredCsvs.add(csv);
        }
        if (filteredCsvs.size() < this.mCsvs.size()) {
            this.mCsvs = filteredCsvs;
        }
    }

    private List<ICsvProvider<T>> groupByColumnKeyAndThreshold(ICsvProvider<T> csv, String column, int[] thresholds) {
        TreeMap bin2group;
        HashMap key2group;
        int columnIndex = csv.getColumnTitles().indexOf(column);
        if (columnIndex == -1) {
            throw new IllegalArgumentException("The CSV key does not exist: " + column);
        }
        if (thresholds == null) {
            key2group = new HashMap();
            bin2group = null;
        } else {
            key2group = null;
            bin2group = new TreeMap();
        }
        int numberOfRows = csv.getRowHeaders().size();
        int i = 0;
        while (i < numberOfRows) {
            String rowTitle;
            SimpleCsvProvider<T> group;
            List<T> row = csv.getRow(i);
            T entry = row.get(columnIndex);
            assert (thresholds == null || entry instanceof Integer);
            int bin = this.getBin(entry, thresholds);
            ICsvProvider<T> iCsvProvider = group = thresholds == null ? (SimpleCsvProvider<T>)key2group.get(entry) : (ICsvProvider)bin2group.get(bin);
            if (group == null) {
                group = new SimpleCsvProvider<T>(csv.getColumnTitles());
                if (thresholds == null) {
                    key2group.put(entry, group);
                    rowTitle = entry.toString();
                } else {
                    bin2group.put(bin, group);
                    String lower = bin == 0 ? "(-\\infty" : "[" + Integer.toString(thresholds[bin - 1]);
                    String upper = bin == thresholds.length ? "\\infty)" : String.valueOf(Integer.toString(thresholds[bin])) + "]";
                    rowTitle = "$n \\in " + lower + "; " + upper + "$";
                }
            } else {
                List<String> rowHeaders = group.getRowHeaders();
                rowTitle = rowHeaders.isEmpty() ? entry.toString() : (rowHeaders.get(0) == null ? entry.toString() : rowHeaders.get(0));
            }
            group.addRow(rowTitle, new ArrayList<T>(row));
            ++i;
        }
        ArrayList<ICsvProvider<T>> result = new ArrayList<ICsvProvider<T>>();
        Collection csvs = thresholds == null ? key2group.values() : bin2group.values();
        for (ICsvProvider group : csvs) {
            result.add(group);
        }
        return result;
    }

    private int getBin(T entryRaw, int[] thresholds) {
        if (thresholds == null) {
            return 0;
        }
        int entry = Integer.parseInt(entryRaw.toString());
        int i = 0;
        while (i < thresholds.length) {
            if (entry < thresholds[i]) {
                return i;
            }
            ++i;
        }
        return thresholds.length;
    }

    public class AllEntriesNonNullFilter
    implements Predicate<ICsvProvider<T>> {
        @Override
        public boolean test(ICsvProvider<T> csv) {
            int numberOfRows = csv.getRowHeaders().size();
            int i = 0;
            while (i < numberOfRows) {
                List row = csv.getRow(i);
                for (Object entry : row) {
                    if (entry != null && !"null".equals(entry.toString())) continue;
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

