/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.csv;

import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderTransformer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.ListIterator;

public class CsvProviderRounding<T>
implements ICsvProviderTransformer<T> {
    private final int mPlaces;

    public CsvProviderRounding(int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        this.mPlaces = places;
    }

    @Override
    public ICsvProvider<T> transform(ICsvProvider<T> csvProvider) {
        List<String> rowTitles = csvProvider.getRowHeaders();
        int i = 0;
        while (i < rowTitles.size()) {
            ListIterator<T> rowIt = csvProvider.getRow(i).listIterator();
            while (rowIt.hasNext()) {
                T entry = rowIt.next();
                if (entry instanceof Double) {
                    this.replaceDouble(rowIt, entry);
                    continue;
                }
                if (!(entry instanceof String)) continue;
                this.replaceString(rowIt, entry);
            }
            ++i;
        }
        return csvProvider;
    }

    private void replaceDouble(ListIterator<T> rowIt, T entry) {
        rowIt.set(this.round(new BigDecimal((Double)entry)));
    }

    private void replaceString(ListIterator<T> rowIt, T entry) {
        try {
            String rounded = this.round(new BigDecimal((String)entry)).toString();
            String result = this.mPlaces == 0 ? rounded.substring(0, rounded.length() - 2) : rounded;
            rowIt.set(result);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private Double round(BigDecimal bigDecimal) {
        BigDecimal rounded = bigDecimal.setScale(this.mPlaces, RoundingMode.HALF_UP);
        return rounded.doubleValue();
    }
}

