/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.csv;

import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderTransformer;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class CsvProviderRowFilter<T>
implements ICsvProviderTransformer<T> {
    private final Predicate<Pair<List<T>, List<String>>> mPredicate;

    public CsvProviderRowFilter(Predicate<Pair<List<T>, List<String>>> predicate) {
        this.mPredicate = predicate;
    }

    @Override
    public ICsvProvider<T> transform(ICsvProvider<T> csvProvider) {
        List<String> oldColumnTitles = csvProvider.getColumnTitles();
        SimpleCsvProvider<T> result = new SimpleCsvProvider<T>(oldColumnTitles);
        int i = 0;
        while (i < csvProvider.getRowHeaders().size()) {
            List<T> row = csvProvider.getRow(i);
            if (this.mPredicate.test(new Pair<List<T>, List<String>>(row, oldColumnTitles))) {
                result.addRow(row);
            }
            ++i;
        }
        return result;
    }

    public static class AllEntriesNonNullFilter<T>
    implements Predicate<Pair<List<T>, List<String>>> {
        @Override
        public boolean test(Pair<List<T>, List<String>> pair) {
            List<T> row = pair.getFirst();
            for (T entry : row) {
                if (entry != null && !"null".equals(entry.toString())) continue;
                return false;
            }
            return true;
        }
    }

    public static class AllowedValuesRowFilter<T>
    implements Predicate<Pair<List<T>, List<String>>> {
        private final Map<String, Set<T>> mColumn2allowedValues;

        public AllowedValuesRowFilter(Map<String, Set<T>> column2allowedValues) {
            this.mColumn2allowedValues = column2allowedValues;
        }

        @Override
        public boolean test(Pair<List<T>, List<String>> pair) {
            List<T> rowValues = pair.getFirst();
            int size = pair.getSecond().size();
            Iterator<String> iterator = pair.getSecond().iterator();
            int i = 0;
            while (i < size) {
                String columnTitle = iterator.next();
                Set<T> allowedValues = this.mColumn2allowedValues.get(columnTitle);
                if (allowedValues != null && this.isForbiddenValue(rowValues.get(i), allowedValues)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected boolean isForbiddenValue(T value, Set<T> allowedValues) {
            return !allowedValues.contains(value);
        }
    }

    public static class DisallowedValuesRowFilter<T>
    extends AllowedValuesRowFilter<T> {
        public DisallowedValuesRowFilter(Map<String, Set<T>> column2disallowedValues) {
            super(column2disallowedValues);
        }

        @Override
        protected boolean isForbiddenValue(T value, Set<T> allowedValues) {
            return !super.isForbiddenValue(value, allowedValues);
        }
    }
}

