/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.csv;

import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderTransformer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;

public class CsvProviderScale
implements ICsvProviderTransformer<String> {
    private final Map<String, Pair<Double, ScaleMode>> mColumn2Scale;

    public CsvProviderScale(Map<String, Pair<Double, ScaleMode>> column2Scale) {
        this.mColumn2Scale = column2Scale;
    }

    @Override
    public ICsvProvider<String> transform(ICsvProvider<String> csv) {
        int col = -1;
        int rows = csv.getRowHeaders().size();
        for (String columnTitle : csv.getColumnTitles()) {
            ++col;
            Pair<Double, ScaleMode> scale = this.mColumn2Scale.get(columnTitle);
            if (scale == null) continue;
            int i = 0;
            while (i < rows) {
                BigDecimal oldVal = new BigDecimal(csv.getRow(i).get(col));
                double newVal = CsvProviderScale.computeScale(oldVal, scale);
                csv.getRow(i).set(col, Double.toString(newVal));
                ++i;
            }
        }
        return csv;
    }

    private static double computeScale(BigDecimal oldVal, Pair<Double, ScaleMode> scale) {
        double result;
        switch (scale.getSecond()) {
            case DIV_INT: {
                BigDecimal divisor = BigDecimal.valueOf(scale.getFirst());
                if (divisor == BigDecimal.ZERO) {
                    result = Double.NaN;
                    break;
                }
                BigDecimal divRes = oldVal.divide(divisor, RoundingMode.HALF_UP);
                BigDecimal asInt = divRes.setScale(0, RoundingMode.HALF_UP);
                result = asInt.doubleValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown scale mode: " + (Object)((Object)scale.getSecond()));
            }
        }
        return result;
    }

    public static enum ScaleMode {
        DIV_INT;

    }
}

