/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.csv;

import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CsvUtils {
    public static <T extends ICsvProvider<?>, K extends ICsvProvider<?>> K convertComplete(T provider, IExplicitConverter<T, K> converter) {
        return (K)((ICsvProvider)converter.convert(provider));
    }

    public static <T, K> ICsvProvider<K> convertPerValue(ICsvProvider<T> provider, IExplicitConverter<T, K> converter) {
        SimpleCsvProvider rtr = new SimpleCsvProvider(provider.getColumnTitles());
        List<String> rowTitles = provider.getRowHeaders();
        List<List<T>> table = provider.getTable();
        int i = 0;
        while (i < table.size()) {
            List<T> oldrow = table.get(i);
            ArrayList<K> newrow = new ArrayList<K>();
            for (T oldentry : oldrow) {
                newrow.add(converter.convert(oldentry));
            }
            String rowTitle = rowTitles.get(i);
            rtr.addRow(rowTitle, newrow);
            ++i;
        }
        return rtr;
    }

    public static <T> ICsvProvider<T> flatten(ICsvProvider<T> provider, String headerSeparator) {
        ArrayList<String> newHeader = new ArrayList<String>();
        ArrayList<T> newRow = new ArrayList<T>();
        List<List<T>> currentMap = provider.getTable();
        int i = 0;
        while (i < provider.getColumnTitles().size()) {
            String currentColumnHeader = provider.getColumnTitles().get(i);
            int j = 0;
            while (j < provider.getRowHeaders().size()) {
                String currentRowHeader = provider.getRowHeaders().get(j);
                newHeader.add(String.valueOf(currentColumnHeader) + headerSeparator + currentRowHeader);
                newRow.add(currentMap.get(j).get(i));
                ++j;
            }
            ++i;
        }
        SimpleCsvProvider<T> rtr = new SimpleCsvProvider<T>(newHeader);
        rtr.addRow(newRow);
        return rtr;
    }

    public static <T> ICsvProvider<T> projectColumn(ICsvProvider<T> provider, String columnTitle) {
        return CsvUtils.projectColumn(provider, Collections.singleton(columnTitle));
    }

    public static <T> ICsvProvider<T> projectColumn(ICsvProvider<T> provider, String[] columnsToKeep) {
        return CsvUtils.projectColumn(provider, Arrays.asList(columnsToKeep));
    }

    public static <T> ICsvProvider<T> projectColumn(ICsvProvider<T> provider, Collection<String> newColumnTitles) {
        SimpleCsvProvider newProvider = new SimpleCsvProvider(new ArrayList<String>(newColumnTitles));
        if (provider.isEmpty()) {
            return newProvider;
        }
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (String newColumnTitle : newColumnTitles) {
            int newIdx = -1;
            int i = 0;
            while (i < provider.getColumnTitles().size()) {
                String oldColumnTitle = provider.getColumnTitles().get(i);
                if (oldColumnTitle.equals(newColumnTitle)) {
                    newIdx = i;
                    break;
                }
                ++i;
            }
            indexList.add(newIdx);
        }
        int rowIndex = 0;
        for (String rowTitle : provider.getRowHeaders()) {
            ArrayList<T> newRow = new ArrayList<T>();
            Iterator iterator = indexList.iterator();
            while (iterator.hasNext()) {
                int cellIndex = (Integer)iterator.next();
                if (cellIndex == -1) {
                    newRow.add(null);
                    continue;
                }
                newRow.add(provider.getRow(rowIndex).get(cellIndex));
            }
            ++rowIndex;
            newProvider.addRow(rowTitle, newRow);
        }
        return newProvider;
    }

    public static <T> ICsvProvider<T> addColumn(ICsvProvider<T> provider, String columnTitle, int index, List<T> values) {
        if (index < 0 || index > provider.getColumnTitles().size()) {
            throw new IllegalArgumentException();
        }
        List<String> oldTitles = provider.getColumnTitles();
        ArrayList<String> newTitles = new ArrayList<String>();
        int i = 0;
        int j = 0;
        while (i < oldTitles.size() + 1) {
            if (i == index) {
                newTitles.add(i, columnTitle);
            } else {
                newTitles.add(i, oldTitles.get(j));
                ++j;
            }
            ++i;
        }
        SimpleCsvProvider newProvider = new SimpleCsvProvider(newTitles);
        int k = 0;
        for (List<T> oldRow : provider.getTable()) {
            ArrayList<T> newRow = new ArrayList<T>();
            int i2 = 0;
            int j2 = 0;
            while (i2 < newTitles.size()) {
                if (i2 == index) {
                    newRow.add(i2, values.get(k));
                } else {
                    newRow.add(i2, oldRow.get(j2));
                    ++j2;
                }
                ++i2;
            }
            newProvider.addRow(provider.getRowHeaders().get(k), newRow);
            ++k;
        }
        return newProvider;
    }

    public static <T> ICsvProvider<T> transpose(ICsvProvider<T> provider) {
        if (provider == null || provider.isEmpty()) {
            throw new IllegalArgumentException("provider may not be null or empty");
        }
        ArrayList<String> newColumnTitles = new ArrayList<String>(provider.getRowHeaders());
        SimpleCsvProvider rtr = new SimpleCsvProvider(newColumnTitles);
        ArrayList<String> newRowTitles = new ArrayList<String>(provider.getColumnTitles());
        int i = 0;
        for (String newRowTitle : newRowTitles) {
            ArrayList<T> newRow = new ArrayList<T>();
            for (List<T> oldRow : provider.getTable()) {
                newRow.add(oldRow.get(i));
            }
            rtr.addRow(newRowTitle, newRow);
            ++i;
        }
        return rtr;
    }

    public static ICsvProvider<Object> concatenateRowsUnchecked(ICsvProvider<?> a, ICsvProvider<?> b) {
        return CsvUtils.concatenateRows(a, b);
    }

    public static <T> ICsvProvider<T> concatenateRows(ICsvProvider<T> providerA, ICsvProvider<T> providerB) {
        List<String> resultColumns;
        List<String> providerAColumns = providerA.getColumnTitles();
        List<String> providerBColumns = providerB.getColumnTitles();
        ArrayList<Integer> additionalColumnForProviderA = new ArrayList<Integer>();
        ArrayList<Integer> additionalColumnForProviderB = new ArrayList<Integer>();
        if (providerAColumns.isEmpty()) {
            resultColumns = providerBColumns;
        } else if (providerBColumns.isEmpty()) {
            resultColumns = providerBColumns;
        } else {
            resultColumns = new ArrayList<String>();
            int pAindex = 0;
            int pBindex = 0;
            while (pAindex < providerAColumns.size() || pBindex < providerBColumns.size()) {
                String currentPACol = null;
                if (pAindex < providerAColumns.size()) {
                    currentPACol = providerAColumns.get(pAindex);
                }
                String currentPBCol = null;
                if (pBindex < providerBColumns.size()) {
                    currentPBCol = providerBColumns.get(pBindex);
                }
                if (currentPACol != null && currentPACol.equals(currentPBCol)) {
                    resultColumns.add(currentPACol);
                    ++pAindex;
                    ++pBindex;
                    continue;
                }
                if (pAindex < providerAColumns.size() && !providerBColumns.contains(currentPACol)) {
                    if (pBindex < providerBColumns.size() && !providerAColumns.contains(currentPBCol) && currentPBCol.compareTo(currentPACol) < 0) {
                        resultColumns.add(currentPBCol);
                        additionalColumnForProviderA.add(pAindex);
                        ++pBindex;
                        continue;
                    }
                    resultColumns.add(currentPACol);
                    additionalColumnForProviderB.add(pBindex);
                    ++pAindex;
                    continue;
                }
                if (pBindex < providerBColumns.size() && !providerAColumns.contains(currentPBCol)) {
                    resultColumns.add(currentPBCol);
                    additionalColumnForProviderA.add(pAindex);
                    ++pBindex;
                    continue;
                }
                throw new IllegalArgumentException("unable to merge, both providers have similar columns but in different order");
            }
        }
        SimpleCsvProvider<T> result = new SimpleCsvProvider<T>(resultColumns);
        int rowIndex = 0;
        for (String rowTitle : providerA.getRowHeaders()) {
            List<T> p1Row = providerA.getRow(rowIndex);
            result.addRow(rowTitle, CsvUtils.insertNullElements(p1Row, additionalColumnForProviderA));
            ++rowIndex;
        }
        rowIndex = 0;
        for (String rowTitle : providerB.getRowHeaders()) {
            List<T> p2Row = providerB.getRow(rowIndex);
            result.addRow(rowTitle, CsvUtils.insertNullElements(p2Row, additionalColumnForProviderB));
            ++rowIndex;
        }
        return result;
    }

    public static <T, K extends ICsvProvider<T>> ICsvProvider<T> concatenateRows(List<K> csvProviders) {
        ICsvProvider result = new SimpleCsvProvider(new ArrayList<String>());
        for (ICsvProvider csvProvider : csvProviders) {
            result = CsvUtils.concatenateRows(result, csvProvider);
        }
        return result;
    }

    private static <T> List<T> insertNullElements(List<T> array, List<Integer> additionalNullValuePositions) {
        LinkedList<T> result = new LinkedList<T>(array);
        int i = additionalNullValuePositions.size() - 1;
        while (i >= 0) {
            result.add(additionalNullValuePositions.get(i), null);
            --i;
        }
        return result;
    }

    public static <T> ICsvProvider<T> constructCvsProviderFromMap(Map<String, T> map) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        SimpleCsvProvider scp = new SimpleCsvProvider(keys);
        ArrayList<T> values = new ArrayList<T>();
        for (String key : keys) {
            values.add(map.get(key));
        }
        scp.addRow(values);
        return scp;
    }

    public static <T> StringBuilder toHTML(ICsvProvider<T> provider, StringBuilder currentBuilder, boolean withHTMLHeaders, IExplicitConverter<T, String> cellDecorator) {
        if (currentBuilder == null) {
            currentBuilder = new StringBuilder();
        }
        if (cellDecorator == null) {
            cellDecorator = new IExplicitConverter<T, String>(){

                @Override
                public String convert(T something) {
                    if (something == null) {
                        return "-";
                    }
                    return something.toString();
                }
            };
        }
        String linebreak = System.getProperty("line.separator");
        if (withHTMLHeaders) {
            currentBuilder.append("<html><body>").append(linebreak);
        }
        currentBuilder.append("<table style=\"width:100%\">").append(linebreak);
        if (CsvUtils.hasRowHeaders(provider)) {
            List<String> columnHeaders = provider.getColumnTitles();
            currentBuilder.append("<tr><th></th>");
            for (String header : columnHeaders) {
                currentBuilder.append("<th>").append(header).append("</th>");
            }
            currentBuilder.append("</tr>").append(linebreak);
            List<String> rowHeaders = provider.getRowHeaders();
            List<List<T>> rows = provider.getTable();
            int i = 0;
            while (i < rows.size()) {
                currentBuilder.append("<tr><td>");
                currentBuilder.append(rowHeaders.get(i));
                currentBuilder.append("</td>");
                for (T cell : rows.get(i)) {
                    currentBuilder.append("<td>").append((String)cellDecorator.convert(cell)).append("</td>");
                }
                currentBuilder.append("</tr>").append(linebreak);
                ++i;
            }
        } else {
            List<String> columnHeaders = provider.getColumnTitles();
            currentBuilder.append("<tr>");
            for (String header : columnHeaders) {
                currentBuilder.append("<th>").append(header).append("</th>");
            }
            currentBuilder.append("</tr>").append(linebreak);
            List<List<T>> rows = provider.getTable();
            int i = 0;
            while (i < rows.size()) {
                currentBuilder.append("<tr>");
                for (T cell : rows.get(i)) {
                    currentBuilder.append("<td>").append((String)cellDecorator.convert(cell)).append("</td>");
                }
                currentBuilder.append("</tr>").append(linebreak);
                ++i;
            }
        }
        currentBuilder.append("</table>").append(linebreak);
        if (withHTMLHeaders) {
            currentBuilder.append("</body></html>").append(linebreak);
        }
        return currentBuilder;
    }

    private static <T> boolean hasRowHeaders(ICsvProvider<T> provider) {
        List<String> rowHeaders = provider.getRowHeaders();
        if (rowHeaders == null || rowHeaders.isEmpty()) {
            return false;
        }
        for (String header : rowHeaders) {
            if (header == null || header.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static interface IExplicitConverter<T, K> {
        public K convert(T var1);
    }
}

