/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.csv;

import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleCsvProvider<T>
implements ICsvProvider<T> {
    private List<String> mColumnTitles;
    private final List<String> mRowTitles;
    private final List<List<T>> mTable;

    public SimpleCsvProvider(List<String> columnTitles) {
        this.mColumnTitles = columnTitles;
        this.mTable = new ArrayList<List<T>>();
        this.mRowTitles = new ArrayList<String>();
    }

    @Override
    public List<String> getColumnTitles() {
        return this.mColumnTitles;
    }

    @Override
    public List<List<T>> getTable() {
        ArrayList<List<T>> rtr = new ArrayList<List<T>>();
        for (List<T> x : this.mTable) {
            rtr.add(new ArrayList<T>(x));
        }
        return rtr;
    }

    @Override
    public List<String> getRowHeaders() {
        return this.mRowTitles;
    }

    @Override
    public void addRow(String rowName, List<T> values) {
        if (values == null || values.size() != this.mColumnTitles.size()) {
            throw new IllegalArgumentException("values are invalid (either null or not the same length as the number of columns of this CsvProvider");
        }
        this.mRowTitles.add(rowName);
        this.mTable.add(values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        int maxLength = 0;
        for (String rowTitle : this.mRowTitles) {
            if (rowTitle == null || rowTitle.length() <= maxLength) continue;
            maxLength = rowTitle.length();
        }
        int i = 0;
        while (i < maxLength + 1) {
            sb.append(" ");
            ++i;
        }
        for (String s : this.mColumnTitles) {
            sb.append(s).append(",");
        }
        if (sb.length() >= 2) {
            sb.replace(sb.length() - 2, sb.length(), "");
        }
        sb.append(lineSeparator);
        i = 0;
        while (i < this.mTable.size()) {
            List<T> row = this.mTable.get(i);
            String rowTitle = this.mRowTitles.get(i);
            if (rowTitle == null) {
                rowTitle = "";
            }
            SimpleCsvProvider.checkForSeparators(rowTitle, ",", lineSeparator);
            sb.append(rowTitle);
            int j = 0;
            while (j < maxLength + 1 - rowTitle.length()) {
                sb.append(" ");
                ++j;
            }
            for (T value : row) {
                String cellString = String.valueOf(value);
                SimpleCsvProvider.checkForSeparators(cellString, ",", lineSeparator);
                sb.append(cellString).append(", ");
            }
            if (sb.length() >= 2) {
                sb.replace(sb.length() - 2, sb.length(), "");
            }
            sb.append(lineSeparator);
            ++i;
        }
        return sb.toString();
    }

    @Override
    public StringBuilder toCsv(StringBuilder sb, String cellSeparator, boolean printColHeader) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        boolean printRowHeaderColumn = this.hasRowHeaders();
        String lineSeparator = System.getProperty("line.separator");
        String separator = ",";
        if (cellSeparator != null && !cellSeparator.isEmpty()) {
            separator = cellSeparator;
        }
        if (printRowHeaderColumn) {
            sb.append(separator);
        }
        if (printColHeader) {
            for (String s : this.mColumnTitles) {
                if (s == null || s.isEmpty()) {
                    sb.append("NOTITLE").append(separator);
                    continue;
                }
                SimpleCsvProvider.checkForSeparators(s, separator, lineSeparator);
                sb.append(s).append(separator);
            }
            if (sb.length() >= separator.length()) {
                sb.replace(sb.length() - separator.length(), sb.length(), "");
            }
            sb.append(lineSeparator);
        }
        int i = 0;
        while (i < this.mTable.size()) {
            List<T> row = this.mTable.get(i);
            String rowTitle = this.mRowTitles.get(i);
            if (printRowHeaderColumn) {
                if (rowTitle == null) {
                    rowTitle = "";
                }
                SimpleCsvProvider.checkForSeparators(rowTitle, separator, lineSeparator);
                sb.append(rowTitle).append(separator);
            }
            for (T value : row) {
                String cellString = String.valueOf(value);
                cellString = cellString.replace(lineSeparator, "").replace(separator, "");
                SimpleCsvProvider.checkForSeparators(cellString, separator, lineSeparator);
                sb.append(cellString).append(separator);
            }
            if (sb.length() >= separator.length()) {
                sb.replace(sb.length() - separator.length(), sb.length(), "");
            }
            sb.append(lineSeparator);
            ++i;
        }
        return sb;
    }

    private static void checkForSeparators(String cellString, String cellSeparator, String lineSeparator) {
        if (cellString.contains(cellSeparator)) {
            throw new IllegalArgumentException("The following cell contains the character that is used to separate cells: " + cellString);
        }
        if (cellString.contains(lineSeparator)) {
            throw new IllegalArgumentException("The following cell contains the character that is used to separate lines: " + cellString);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.mTable.isEmpty();
    }

    @Override
    public void addRow(List<T> values) {
        this.addRow(null, values);
    }

    @Override
    public List<T> getRow(int index) {
        if (index < 0 || index >= this.mTable.size()) {
            return null;
        }
        return this.mTable.get(index);
    }

    @Override
    public void renameColumnTitle(String oldName, String newName) {
        ArrayList<String> names = new ArrayList<String>();
        for (String title : this.getColumnTitles()) {
            if (title.equals(oldName)) {
                names.add(newName);
                continue;
            }
            names.add(title);
        }
        this.mColumnTitles = names;
    }

    private boolean hasRowHeaders() {
        for (String rowTitle : this.mRowTitles) {
            if (rowTitle == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getRowCount() {
        return this.mTable.size();
    }

    public static SimpleCsvProvider<Object> constructCsvProviderReflectively(Object instance) {
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        ArrayList<String> columnTitles = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        Field[] fieldArray = instance.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(CsvColumn.class)) {
                try {
                    Object value = field.get(instance);
                    CsvColumn annot = field.getAnnotation(CsvColumn.class);
                    String name = annot.value();
                    columnTitles.add(name);
                    values.add(value);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            ++n2;
        }
        if (values.isEmpty()) {
            return new SimpleCsvProvider<Object>(Collections.emptyList());
        }
        SimpleCsvProvider<Object> csvProvider = new SimpleCsvProvider<Object>(columnTitles);
        csvProvider.addRow(values);
        return csvProvider;
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CsvColumn {
        public String value();
    }
}

