/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BidirectionalMap<K, V>
extends HashMap<K, V> {
    private static final long serialVersionUID = -7727684030243112324L;
    private final BidirectionalMap<V, K> mInverse;

    public BidirectionalMap() {
        this.mInverse = new BidirectionalMap(new HashMap(), this);
    }

    public BidirectionalMap(BidirectionalMap<K, V> biMap) {
        super(biMap);
        this.mInverse = new BidirectionalMap<K, V>(biMap.mInverse, this);
    }

    private BidirectionalMap(HashMap<K, V> map, BidirectionalMap<V, K> inverse) {
        super(map);
        this.mInverse = inverse;
    }

    public BidirectionalMap<V, K> inverse() {
        return this.mInverse;
    }

    @Override
    public void clear() {
        this.clearAsymmetric();
        this.mInverse.clearAsymmetric();
    }

    private void clearAsymmetric() {
        super.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mInverse.containsKey(value);
    }

    @Override
    public V put(K key, V value) {
        K oldKey = this.mInverse.putAsymmetric(value, key);
        this.removeAsymmetric(oldKey);
        V oldValue = this.putAsymmetric(key, value);
        this.mInverse.removeAsymmetric(oldValue);
        return oldValue;
    }

    public V putAsymmetric(K key, V value) {
        return super.put(key, value);
    }

    @Override
    public V remove(Object key) {
        V removedValue = this.removeAsymmetric(key);
        this.mInverse.removeAsymmetric(removedValue);
        return removedValue;
    }

    public V removeAsymmetric(Object key) {
        return super.remove(key);
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    @Override
    public Set<V> values() {
        return this.mInverse.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }
}

