/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import de.uni_freiburg.informatik.ultimate.util.LazyInt;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.ILattice;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import java.util.AbstractCollection;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public final class BitSubSet<E>
extends AbstractCollection<E> {
    private final Factory<E> mFactory;
    private final BitSet mBitSet;
    private final LazyInt mHash;

    private BitSubSet(Factory<E> factory, BitSet bitset) {
        this.mFactory = factory;
        this.mBitSet = bitset;
        this.mHash = new LazyInt(this.mBitSet::hashCode);
    }

    @Override
    public boolean contains(Object o) {
        Integer index = this.mFactory.getIndex(o);
        return index != null && this.mBitSet.get(index);
    }

    @Override
    public boolean containsAll(BitSubSet<?> c) {
        assert (c.mFactory == this.mFactory) : "Cannot compare sets from different universes";
        BitSet diff = BitSet.valueOf(c.mBitSet.toLongArray());
        diff.andNot(this.mBitSet);
        return diff.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new BitSubSetIterator(this.mFactory.mElements, this.mBitSet);
    }

    @Override
    public int size() {
        return this.mBitSet.cardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.mBitSet.isEmpty();
    }

    @Override
    public int hashCode() {
        return this.mHash.get();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof BitSubSet) {
            BitSubSet b = (BitSubSet)o;
            if (b.mFactory == this.mFactory) {
                return b.mBitSet.equals(this.mBitSet);
            }
        }
        return super.equals(o);
    }

    private static class BitSubSetIterator<E>
    implements Iterator<E> {
        private final Object[] mElements;
        private final BitSet mBitSet;
        private int mIndex;

        public BitSubSetIterator(Object[] elements, BitSet bitset) {
            this.mElements = elements;
            this.mBitSet = bitset;
        }

        @Override
        public boolean hasNext() {
            return this.mIndex < this.mBitSet.length();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.mIndex = this.mBitSet.nextSetBit(this.mIndex);
            Object elem = this.mElements[this.mIndex];
            ++this.mIndex;
            return (E)elem;
        }
    }

    public static class Factory<E>
    implements ILattice<BitSubSet<E>> {
        private static final String LEFT_NOT_CREATED_BY_FACTORY = "Operand 'left' not created by this factory";
        private static final String RIGHT_NOT_CREATED_BY_FACTORY = "Operand 'right' not created by this factory";
        private final Object[] mElements;
        private final Map<E, Integer> mIndexMap;
        private BitSubSet<E> mUniverse;
        private BitSubSet<E> mEmpty;

        public Factory(Set<E> universe) {
            this.mElements = universe.stream().sorted(Comparator.comparing(Objects::hashCode)).toArray();
            this.mIndexMap = new HashMap<E, Integer>(universe.size());
            int i = 0;
            while (i < this.mElements.length) {
                this.mIndexMap.put(this.mElements[i], i);
                ++i;
            }
        }

        public BitSubSet<E> valueOf(Set<E> set) {
            BitSet bitset = new BitSet(this.mElements.length);
            for (E elem : set) {
                int index = this.getIndex(elem);
                bitset.set(index);
            }
            return new BitSubSet(this, bitset);
        }

        public BitSubSet<E> universe() {
            if (this.mUniverse == null) {
                BitSet bitset = new BitSet(this.mElements.length);
                this.flip(bitset);
                this.mUniverse = new BitSubSet(this, bitset);
            }
            return this.mUniverse;
        }

        public BitSubSet<E> empty() {
            if (this.mEmpty == null) {
                this.mEmpty = new BitSubSet(this, new BitSet());
            }
            return this.mEmpty;
        }

        public BitSubSet<E> complement(BitSubSet<E> operand) {
            assert (operand.mFactory == this) : "operand not created by this factory";
            BitSet bitset = Factory.copy(operand.mBitSet);
            this.flip(bitset);
            return new BitSubSet(this, bitset);
        }

        public BitSubSet<E> union(BitSubSet<E> left, BitSubSet<E> right) {
            assert (left.mFactory == this) : "Operand 'left' not created by this factory";
            assert (right.mFactory == this) : "Operand 'right' not created by this factory";
            if (right.isEmpty()) {
                return left;
            }
            if (left.isEmpty()) {
                return right;
            }
            BitSet union = Factory.copy(left.mBitSet);
            union.or(right.mBitSet);
            return new BitSubSet(this, union);
        }

        public BitSubSet<E> intersection(BitSubSet<E> left, BitSubSet<E> right) {
            assert (left.mFactory == this) : "Operand 'left' not created by this factory";
            assert (right.mFactory == this) : "Operand 'right' not created by this factory";
            if (right.isEmpty()) {
                return right;
            }
            if (left.isEmpty()) {
                return left;
            }
            BitSet inter = Factory.copy(left.mBitSet);
            inter.and(right.mBitSet);
            return new BitSubSet(this, inter);
        }

        public BitSubSet<E> difference(BitSubSet<E> left, BitSubSet<E> right) {
            assert (left.mFactory == this) : "Operand 'left' not created by this factory";
            assert (right.mFactory == this) : "Operand 'right' not created by this factory";
            if (left.isEmpty() || right.isEmpty()) {
                return left;
            }
            BitSet diff = Factory.copy(left.mBitSet);
            diff.andNot(right.mBitSet);
            return new BitSubSet(this, diff);
        }

        private void flip(BitSet bitset) {
            if (this.mElements.length == 0) {
                return;
            }
            bitset.flip(0, this.mElements.length);
        }

        private static BitSet copy(BitSet bitset) {
            return (BitSet)bitset.clone();
        }

        private final Integer getIndex(Object element) {
            return this.mIndexMap.get(element);
        }

        @Override
        public IPartialComparator.ComparisonResult compare(BitSubSet<E> o1, BitSubSet<E> o2) {
            assert (o1.mFactory == this && o2.mFactory == this) : "operand not created by this factory";
            if (o1.equals(o2)) {
                return IPartialComparator.ComparisonResult.EQUAL;
            }
            if (o2.containsAll(o1)) {
                return IPartialComparator.ComparisonResult.STRICTLY_SMALLER;
            }
            if (o1.containsAll(o2)) {
                return IPartialComparator.ComparisonResult.STRICTLY_GREATER;
            }
            return IPartialComparator.ComparisonResult.INCOMPARABLE;
        }

        @Override
        public BitSubSet<E> getBottom() {
            return this.empty();
        }

        @Override
        public BitSubSet<E> getTop() {
            return this.universe();
        }

        @Override
        public BitSubSet<E> supremum(BitSubSet<E> h1, BitSubSet<E> h2) {
            return this.union(h1, h2);
        }

        @Override
        public BitSubSet<E> infimum(BitSubSet<E> h1, BitSubSet<E> h2) {
            return this.intersection(h1, h2);
        }
    }
}

