/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.math.BigInteger;
import java.util.function.Function;

public class BitvectorConstant {
    private final BigInteger mValue;
    private final BigInteger mIndex;

    public BitvectorConstant(BigInteger value, BigInteger index) {
        this.mValue = BitvectorConstant.computeUnifiedValue(value, index);
        this.mIndex = index;
    }

    public BitvectorConstant(BigInteger value, String index) {
        BigInteger indexAsBi = new BigInteger(index);
        this.mValue = BitvectorConstant.computeUnifiedValue(value, indexAsBi);
        this.mIndex = indexAsBi;
    }

    private static BigInteger computeUnifiedValue(BigInteger value, BigInteger index) {
        return value.mod(new BigInteger("2").pow(index.intValueExact()));
    }

    public BigInteger getValue() {
        return this.mValue;
    }

    public BigInteger getIndex() {
        return this.mIndex;
    }

    public String getStringIndex() {
        return this.mIndex.toString();
    }

    public boolean isZero() {
        return this.mValue.signum() == 0;
    }

    public boolean isOne() {
        return this.mValue.equals(BigInteger.ONE);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.mIndex == null ? 0 : this.mIndex.hashCode());
        result = 31 * result + (this.mValue == null ? 0 : this.mValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitvectorConstant other = (BitvectorConstant)obj;
        if (this.mIndex == null ? other.mIndex != null : !this.mIndex.equals(other.mIndex)) {
            return false;
        }
        return !(this.mValue == null ? other.mValue != null : !this.mValue.equals(other.mValue));
    }

    public String toString() {
        return "(_ bv" + this.mValue + " " + this.mIndex + ")";
    }

    public static BitvectorConstant maxValue(int index) {
        return new BitvectorConstant(BigInteger.valueOf(2L).pow(index).subtract(BigInteger.valueOf(1L)), BigInteger.valueOf(index));
    }

    public static BitvectorConstant maxValue(BigInteger index) {
        return new BitvectorConstant(BigInteger.valueOf(2L).pow(index.intValueExact()).subtract(BigInteger.valueOf(1L)), index);
    }

    public static BitvectorConstant bvadd(BitvectorConstant bv1, BitvectorConstant bv2) {
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bv1, bv2, x -> y -> x.add((BigInteger)y));
    }

    public static BitvectorConstant bvsub(BitvectorConstant bv1, BitvectorConstant bv2) {
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bv1, bv2, x -> y -> x.subtract((BigInteger)y));
    }

    public static BitvectorConstant bvmul(BitvectorConstant bv1, BitvectorConstant bv2) {
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bv1, bv2, x -> y -> x.multiply((BigInteger)y));
    }

    public static BitvectorConstant bvudiv(BitvectorConstant bv1, BitvectorConstant bv2) {
        if (bv2.getValue().signum() == 0) {
            return BitvectorConstant.maxValue(bv1.getIndex());
        }
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bv1, bv2, x -> y -> x.divide((BigInteger)y));
    }

    public static BitvectorConstant bvurem(BitvectorConstant bv1, BitvectorConstant bv2) {
        if (bv2.getValue().signum() == 0) {
            return bv1;
        }
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bv1, bv2, x -> y -> x.remainder((BigInteger)y));
    }

    public static BitvectorConstant bvsdiv(BitvectorConstant bv1, BitvectorConstant bv2) {
        if (BitvectorConstant.toSignedInt(bv2.getValue(), bv2.getIndex()).signum() == 0) {
            return BitvectorConstant.bvudiv(bv1, bv2);
        }
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bv1, bv2, x -> y -> BitvectorConstant.toSignedInt(x, bv1.getIndex()).divide(BitvectorConstant.toSignedInt(y, bv2.getIndex())));
    }

    public static BitvectorConstant bvsrem(BitvectorConstant bv1, BitvectorConstant bv2) {
        if (BitvectorConstant.toSignedInt(bv2.getValue(), bv2.getIndex()).signum() == 0) {
            return BitvectorConstant.bvurem(bv1, bv2);
        }
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bv1, bv2, x -> y -> BitvectorConstant.toSignedInt(x, bv1.getIndex()).remainder(BitvectorConstant.toSignedInt(y, bv2.getIndex())));
    }

    public static BitvectorConstant bvsmod(BitvectorConstant bv1, BitvectorConstant bv2) {
        BigInteger bigInt1 = BitvectorConstant.toSignedInt(bv1.getValue(), bv1.getIndex());
        BigInteger bigInt2 = BitvectorConstant.toSignedInt(bv2.getValue(), bv2.getIndex());
        BitvectorConstant uts1 = bv1;
        BitvectorConstant uts2 = bv2;
        if (bigInt1.signum() == -1) {
            uts1 = BitvectorConstant.bvneg(uts1);
        }
        if (bigInt2.signum() == -1) {
            uts2 = BitvectorConstant.bvneg(uts2);
        }
        BitvectorConstant bvurem = BitvectorConstant.bvurem(uts1, uts2);
        if (bigInt1.signum() == -1 && bigInt2.signum() == 1) {
            return BitvectorConstant.bvadd(BitvectorConstant.bvneg(bvurem), bv2);
        }
        if (bigInt1.signum() == 1 && bigInt2.signum() == -1) {
            return BitvectorConstant.bvadd(bvurem, bv2);
        }
        if (bigInt1.signum() == -1 && bigInt2.signum() == -1) {
            return BitvectorConstant.bvneg(bvurem);
        }
        return bvurem;
    }

    public static BitvectorConstant bvand(BitvectorConstant bv1, BitvectorConstant bv2) {
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bv1, bv2, x -> y -> x.and((BigInteger)y));
    }

    public static BitvectorConstant bvor(BitvectorConstant bv1, BitvectorConstant bv2) {
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bv1, bv2, x -> y -> x.or((BigInteger)y));
    }

    public static BitvectorConstant bvxor(BitvectorConstant bv1, BitvectorConstant bv2) {
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bv1, bv2, x -> y -> x.xor((BigInteger)y));
    }

    public static BitvectorConstant bvshl(BitvectorConstant bv1, BitvectorConstant bv2) {
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bv1, bv2, x -> y -> x.shiftLeft(y.intValueExact()));
    }

    public static BitvectorConstant bvlshr(BitvectorConstant bv1, BitvectorConstant bv2) {
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bv1, bv2, x -> y -> x.shiftRight(y.intValueExact()));
    }

    public static BitvectorConstant bvashr(BitvectorConstant bv1, BitvectorConstant bv2) {
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bv1, bv2, x -> y -> BitvectorConstant.toSignedInt(x, bv1.getIndex()).shiftRight(y.intValueExact()));
    }

    public static BitvectorConstant bvnot(BitvectorConstant bv) {
        return new BitvectorConstant(bv.getValue().not(), bv.getIndex());
    }

    public static BitvectorConstant bvneg(BitvectorConstant bv) {
        return new BitvectorConstant(BitvectorConstant.toSignedInt(bv.getValue(), bv.getIndex()).negate(), bv.getIndex());
    }

    public static BitvectorConstant similarIndexBvOp_BitvectorResult(BitvectorConstant bv1, BitvectorConstant bv2, Function<BigInteger, Function<BigInteger, BigInteger>> fun) {
        if (bv1.getIndex().equals(bv2.getIndex())) {
            return new BitvectorConstant(fun.apply(bv1.getValue()).apply(bv2.getValue()), bv1.getIndex());
        }
        throw new IllegalArgumentException("incompatible indices " + bv1.getIndex() + " " + bv2.getIndex());
    }

    public static Boolean comparison(BitvectorConstant bv1, BitvectorConstant bv2, Function<BigInteger, Function<BigInteger, Boolean>> fun) {
        if (bv1.getIndex().equals(bv2.getIndex())) {
            return fun.apply(bv1.getValue()).apply(bv2.getValue());
        }
        throw new IllegalArgumentException("incompatible indices " + bv1.getIndex() + " " + bv2.getIndex());
    }

    public static boolean bvult(BitvectorConstant bv1, BitvectorConstant bv2) {
        return BitvectorConstant.comparison(bv1, bv2, x -> y -> x.compareTo((BigInteger)y) < 0);
    }

    public static boolean bvule(BitvectorConstant bv1, BitvectorConstant bv2) {
        return BitvectorConstant.comparison(bv1, bv2, x -> y -> x.compareTo((BigInteger)y) <= 0);
    }

    public static boolean bvugt(BitvectorConstant bv1, BitvectorConstant bv2) {
        return BitvectorConstant.comparison(bv1, bv2, x -> y -> x.compareTo((BigInteger)y) > 0);
    }

    public static boolean bvuge(BitvectorConstant bv1, BitvectorConstant bv2) {
        return BitvectorConstant.comparison(bv1, bv2, x -> y -> x.compareTo((BigInteger)y) >= 0);
    }

    public static boolean bvslt(BitvectorConstant bv1, BitvectorConstant bv2) {
        return BitvectorConstant.comparison(bv1, bv2, x -> y -> BitvectorConstant.toSignedInt(x, bv1.getIndex()).compareTo(BitvectorConstant.toSignedInt(y, bv2.getIndex())) < 0);
    }

    public static boolean bvsle(BitvectorConstant bv1, BitvectorConstant bv2) {
        return BitvectorConstant.comparison(bv1, bv2, x -> y -> BitvectorConstant.toSignedInt(x, bv1.getIndex()).compareTo(BitvectorConstant.toSignedInt(y, bv2.getIndex())) <= 0);
    }

    public static boolean bvsgt(BitvectorConstant bv1, BitvectorConstant bv2) {
        return BitvectorConstant.comparison(bv1, bv2, x -> y -> BitvectorConstant.toSignedInt(x, bv1.getIndex()).compareTo(BitvectorConstant.toSignedInt(y, bv2.getIndex())) > 0);
    }

    public static boolean bvsge(BitvectorConstant bv1, BitvectorConstant bv2) {
        return BitvectorConstant.comparison(bv1, bv2, x -> y -> BitvectorConstant.toSignedInt(x, bv1.getIndex()).compareTo(BitvectorConstant.toSignedInt(y, bv2.getIndex())) >= 0);
    }

    public static BitvectorConstant concat(BitvectorConstant bv1, BitvectorConstant bv2) {
        BigInteger concatSize = bv1.getIndex().add(bv2.getIndex());
        BigInteger concatValue = bv1.getValue().multiply(BigInteger.TWO.pow(bv2.getIndex().intValue())).add(bv2.getValue());
        return new BitvectorConstant(concatValue, concatSize);
    }

    public static BitvectorConstant extract(BitvectorConstant bv, int upperIndex, int lowerIndex) {
        int resultIndex = upperIndex + 1 - lowerIndex;
        String binaryString = BitvectorConstant.bvToBinaryString(bv);
        String extractedBinaryString = resultIndex < binaryString.length() ? binaryString.substring(binaryString.length() - 1 - upperIndex, binaryString.length() - lowerIndex) : binaryString;
        BigInteger extractedValue = BitvectorConstant.binaryStringToBv(extractedBinaryString);
        return new BitvectorConstant(extractedValue, BigInteger.valueOf(resultIndex));
    }

    private static BigInteger binaryStringToBv(String extractedBinaryString) {
        return new BigInteger(extractedBinaryString, 2);
    }

    private static String bvToBinaryString(BitvectorConstant bv) {
        String number = bv.getValue().toString(2);
        String leadingZeros = new String(new char[bv.getIndex().intValueExact() - number.length()]).replace('\u0000', '0');
        String result = String.valueOf(leadingZeros) + number;
        assert (result.length() == bv.getIndex().intValueExact());
        return result;
    }

    public static BitvectorConstant zero_extend(BitvectorConstant bv, BigInteger indexExtension) {
        return new BitvectorConstant(bv.getValue(), bv.getIndex().add(indexExtension));
    }

    public static BitvectorConstant sign_extend(BitvectorConstant bv, BigInteger indexExtension) {
        BigInteger signed = bv.toSignedInt();
        return new BitvectorConstant(signed, bv.getIndex().add(indexExtension));
    }

    public static BigInteger toSignedInt(BigInteger bvValue, BigInteger bvIndex) {
        BigInteger firstNegative = new BigInteger("2").pow(bvIndex.intValueExact() - 1);
        if (bvValue.compareTo(firstNegative) < 0) {
            return bvValue;
        }
        BigInteger biggestUnsigned = new BigInteger("2").pow(bvIndex.intValueExact());
        return bvValue.subtract(biggestUnsigned);
    }

    public BigInteger toSignedInt() {
        return BitvectorConstant.toSignedInt(this.mValue, this.mIndex);
    }

    public static BitvectorConstantOperationResult apply(BvOp sbo, BitvectorConstant ... operands) {
        if (operands == null) {
            throw new IllegalArgumentException("No operands");
        }
        if (operands.length != sbo.getArity()) {
            throw new IllegalArgumentException("Operation " + (Object)((Object)sbo) + " has arity " + sbo.getArity() + " but " + operands.length + " operands given");
        }
        switch (sbo) {
            case bvadd: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvadd(operands[0], operands[1]));
            }
            case bvand: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvand(operands[0], operands[1]));
            }
            case bvashr: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvashr(operands[0], operands[1]));
            }
            case bvlshr: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvlshr(operands[0], operands[1]));
            }
            case bvmul: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvmul(operands[0], operands[1]));
            }
            case bvneg: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvneg(operands[0]));
            }
            case bvnot: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvnot(operands[0]));
            }
            case bvor: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvor(operands[0], operands[1]));
            }
            case bvsdiv: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvsdiv(operands[0], operands[1]));
            }
            case bvsge: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvsge(operands[0], operands[1]));
            }
            case bvsgt: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvsgt(operands[0], operands[1]));
            }
            case bvshl: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvshl(operands[0], operands[1]));
            }
            case bvsle: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvsle(operands[0], operands[1]));
            }
            case bvslt: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvslt(operands[0], operands[1]));
            }
            case bvsrem: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvsrem(operands[0], operands[1]));
            }
            case bvsub: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvsub(operands[0], operands[1]));
            }
            case bvudiv: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvudiv(operands[0], operands[1]));
            }
            case bvuge: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvuge(operands[0], operands[1]));
            }
            case bvugt: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvugt(operands[0], operands[1]));
            }
            case bvule: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvule(operands[0], operands[1]));
            }
            case bvult: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvult(operands[0], operands[1]));
            }
            case bvurem: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvurem(operands[0], operands[1]));
            }
            case bvxor: {
                return new BitvectorConstantOperationResult(BitvectorConstant.bvxor(operands[0], operands[1]));
            }
        }
        throw new UnsupportedOperationException("Operation currently unsupported: " + (Object)((Object)sbo));
    }

    public static final class BitvectorConstantOperationResult {
        private final BitvectorConstant mBvResult;
        private final Boolean mBooleanResult;

        public BitvectorConstantOperationResult(BitvectorConstant result) {
            this.mBvResult = result;
            this.mBooleanResult = null;
        }

        public BitvectorConstantOperationResult(boolean result) {
            this.mBvResult = null;
            this.mBooleanResult = result;
        }

        public boolean isBoolean() {
            return this.mBooleanResult != null;
        }

        public boolean getBooleanResult() {
            return this.mBooleanResult;
        }

        public BitvectorConstant getBvResult() {
            return this.mBvResult;
        }
    }

    public static enum BvOp {
        sign_extend(2, false, false),
        zero_extend(2, false, false),
        extract(3, false, false),
        concat(2, false, false),
        bvadd(2, false, true),
        bvsub(2, false, false),
        bvmul(2, false, true),
        bvudiv(2, false, false),
        bvurem(2, false, false),
        bvsdiv(2, false, false),
        bvsrem(2, false, false),
        bvsmod(2, false, false),
        bvand(2, false, true),
        bvor(2, false, true),
        bvxor(2, false, true),
        bvnot(1, false, true),
        bvneg(1, false, true),
        bvshl(2, false, false),
        bvlshr(2, false, false),
        bvashr(2, false, false),
        bvult(2, true, false),
        bvule(2, true, false),
        bvugt(2, true, false),
        bvuge(2, true, false),
        bvslt(2, true, false),
        bvsle(2, true, false),
        bvsgt(2, true, false),
        bvsge(2, true, false);

        private final int mArity;
        private final boolean mIsBoolean;
        private final boolean mIsAssociative;

        private BvOp(int arity, boolean isBoolean, boolean isAssoc) {
            this.mArity = arity;
            this.mIsBoolean = isBoolean;
            this.mIsAssociative = isAssoc;
        }

        public int getArity() {
            return this.mArity;
        }

        public boolean isBoolean() {
            return this.mIsBoolean;
        }

        public boolean isCommutative() {
            return this.mIsAssociative;
        }
    }

    public static enum ExtendOperation {
        sign_extend(BvOp.sign_extend),
        zero_extend(BvOp.zero_extend);

        private final BvOp mBvOp;

        private ExtendOperation(BvOp bvop) {
            this.mBvOp = bvop;
        }

        public BvOp getBvOp() {
            return this.mBvOp;
        }
    }
}

