/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public final class CrossProducts {
    private CrossProducts() {
    }

    public static List<int[]> crossProduct(int[][] input) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        CrossProducts.crossProductHelper(result, input, new int[input.length], 0);
        return result;
    }

    public static <T> List<List<T>> crossProductOfSets(List<Set<T>> input) {
        ArrayList<List<Object>> result = new ArrayList<List<T>>();
        result.add(new ArrayList());
        for (Set<T> nwscs : input) {
            ArrayList newResult = new ArrayList();
            for (List list : result) {
                for (T nwsc : nwscs) {
                    ArrayList<T> newIndex = new ArrayList<T>(list);
                    newIndex.add(nwsc);
                    newResult.add(newIndex);
                }
            }
            result = newResult;
        }
        return result;
    }

    public static <T> List<List<T>> crossProduct(List<List<T>> input) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        ArrayList<Object> output = new ArrayList<Object>(input.size());
        int i = 0;
        while (i < input.size()) {
            output.add(null);
            ++i;
        }
        CrossProducts.crossProductHelper(result, input, output, 0);
        return result;
    }

    private static void crossProductHelper(List<int[]> result, int[][] input, int[] output, int offset) {
        if (offset == output.length) {
            result.add((int[])output.clone());
        } else {
            int[] nArray = input[offset];
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int v;
                output[offset] = v = nArray[n2];
                CrossProducts.crossProductHelper(result, input, output, offset + 1);
                ++n2;
            }
        }
    }

    private static <T> void crossProductHelper(List<List<T>> result, List<List<T>> input, ArrayList<T> output, int offset) {
        if (offset == output.size()) {
            result.add(output.stream().filter(a -> a != null).collect(Collectors.toList()));
        } else {
            for (T v : input.get(offset)) {
                output.set(offset, v);
                CrossProducts.crossProductHelper(result, input, output, offset + 1);
            }
        }
    }

    public static <T> List<int[]> subArrays(int[] input, int combinationNum) {
        assert (combinationNum <= input.length);
        ArrayList<int[]> result = new ArrayList<int[]>();
        CrossProducts.sublistHelper(result, input, new int[combinationNum], 0, 0);
        return result;
    }

    public static <T> List<T[]> subArrays(T[] input, int combinationNum, T[] intermediateArray) {
        assert (input != null && combinationNum <= input.length);
        assert (intermediateArray != null && intermediateArray.length == combinationNum);
        ArrayList<T[]> result = new ArrayList<T[]>();
        CrossProducts.sublistHelper(result, input, intermediateArray, 0, 0);
        return result;
    }

    private static void sublistHelper(List<int[]> result, int[] input, int[] output, int offsetInput, int offsetOutput) {
        if (offsetOutput == output.length) {
            result.add((int[])output.clone());
        } else {
            int todo = output.length - offsetOutput;
            int i = offsetInput;
            while (i <= input.length - todo) {
                output[offsetOutput] = input[i];
                CrossProducts.sublistHelper(result, input, output, i + 1, offsetOutput + 1);
                ++i;
            }
        }
    }

    private static <T> void sublistHelper(List<T[]> result, T[] input, T[] output, int offsetInput, int offsetOutput) {
        if (offsetOutput == output.length) {
            result.add((Object[])output.clone());
        } else {
            int todo = output.length - offsetOutput;
            int i = offsetInput;
            while (i <= input.length - todo) {
                output[offsetOutput] = input[i];
                CrossProducts.sublistHelper(result, input, output, i + 1, offsetOutput + 1);
                ++i;
            }
        }
    }

    public static <E> HashRelation<E, E> binarySelectiveCrossProduct(Collection<E> set, boolean returnReflexivePairs, boolean returnSymmetricPairs) {
        HashRelation<E, E> result = new HashRelation<E, E>();
        Iterator<E> it1 = set.iterator();
        int i = 0;
        while (i < set.size()) {
            E el1 = it1.next();
            Iterator<E> it2 = set.iterator();
            int bound = returnSymmetricPairs ? set.size() : i + 1;
            int j = 0;
            while (j < bound) {
                if (j == i && !returnReflexivePairs) {
                    it2.next();
                } else {
                    E el2 = it2.next();
                    result.addPair(el1, el2);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static <E> HashRelation<E, E> binarySelectiveCrossProduct(Collection<E> set, boolean returnSymmetricPairs, BiPredicate<E, E> pairSelector) {
        HashRelation<E, E> result = new HashRelation<E, E>();
        Iterator<E> it1 = set.iterator();
        int i = 0;
        while (i < set.size()) {
            E el1 = it1.next();
            Iterator<E> it2 = set.iterator();
            int bound = returnSymmetricPairs ? set.size() : i + 1;
            int j = 0;
            while (j < bound) {
                E el2Next = it2.next();
                if (pairSelector.test(el1, el2Next)) {
                    E el2 = el2Next;
                    result.addPair(el1, el2);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static List<List<Integer>> crossProductOfSetsOfFirstNaturalNumbers(List<Integer> exclusiveBounds) {
        ArrayList firstN = new ArrayList();
        for (Integer b : exclusiveBounds) {
            ArrayList<Integer> fn = new ArrayList<Integer>();
            int i = 0;
            while (i < b) {
                fn.add(i);
                ++i;
            }
            firstN.add(fn);
        }
        return CrossProducts.crossProduct(firstN);
    }

    public static <E> List<List<E>> crossProductNTimes(int n, Set<E> baseSet) {
        ArrayList nTimesBaseSet = new ArrayList();
        int i = 0;
        while (i < n) {
            nTimesBaseSet.add(baseSet);
            ++i;
        }
        return CrossProducts.crossProductOfSets(nTimesBaseSet);
    }
}

