/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DataStructureUtils {
    private DataStructureUtils() {
    }

    public static <T> Set<T> intersection(Set<T> set1, Set<T> set2) {
        Set<T> smaller;
        Set<T> larger;
        if (set1.size() > set2.size()) {
            larger = set1;
            smaller = set2;
        } else {
            larger = set2;
            smaller = set1;
        }
        return smaller.stream().filter(larger::contains).collect(Collectors.toSet());
    }

    public static <T> Set<T> intersection(List<Set<T>> inputSets) {
        Collections.sort(inputSets, (o1, o2) -> o1.size() - o2.size());
        Iterator<Set<T>> it = inputSets.iterator();
        HashSet result = new HashSet(it.next());
        while (it.hasNext()) {
            result.retainAll((Collection)it.next());
        }
        return result;
    }

    public static <T> Optional<T> getSomeCommonElement(Set<T> set1, Set<T> set2) {
        Set<T> smaller;
        Set<T> larger;
        if (set1.isEmpty() || set2.isEmpty()) {
            return Optional.empty();
        }
        if (set1.size() > set2.size()) {
            larger = set1;
            smaller = set2;
        } else {
            larger = set2;
            smaller = set1;
        }
        return smaller.stream().filter(larger::contains).findFirst();
    }

    public static <T> Set<T> difference(Set<T> a, Set<T> b) {
        if (a.isEmpty()) {
            return Collections.emptySet();
        }
        if (b.isEmpty()) {
            return new HashSet<T>(a);
        }
        return a.stream().filter(elem -> !b.contains(elem)).collect(Collectors.toSet());
    }

    @SafeVarargs
    public static <T> Set<T> toSet(T ... elems) {
        if (elems == null || elems.length == 0) {
            return Collections.emptySet();
        }
        return new HashSet<T>(Arrays.asList(elems));
    }

    public static <T> Set<T> union(Set<T> a, Set<T> b) {
        Set<T> rtr = DataStructureUtils.getFreshSet(a, a.size() + b.size());
        rtr.addAll(b);
        return rtr;
    }

    @SafeVarargs
    public static <T> Set<T> union(Set<T> ... a) {
        if (a.length == 0) {
            return Collections.emptySet();
        }
        int size = Arrays.stream(a).mapToInt(Set::size).sum();
        Set<T> rtr = DataStructureUtils.getFreshSet(a[0], size);
        Arrays.stream(a).forEach(rtr::addAll);
        return rtr;
    }

    public static <T> Set<T> getFreshSet(Set<T> oldSet) {
        return DataStructureUtils.getFreshSet(oldSet, oldSet.size());
    }

    public static <T> Set<T> getFreshSet(Set<T> oldSet, int capacity) {
        HashSet<T> rtr = new HashSet<T>(capacity);
        rtr.addAll(oldSet);
        return rtr;
    }

    public static <T> boolean haveNonEmptyIntersection(Set<T> set1, Set<T> set2) {
        Set<T> smaller;
        Set<T> larger;
        if (set1.size() > set2.size()) {
            larger = set1;
            smaller = set2;
        } else {
            larger = set2;
            smaller = set1;
        }
        return smaller.stream().anyMatch(larger::contains);
    }

    public static <T> boolean haveEmptyIntersection(Set<T> set1, Set<T> set2) {
        return !DataStructureUtils.haveNonEmptyIntersection(set1, set2);
    }

    public static <E> String prettyPrint(Set<E> set) {
        StringBuilder sb = new StringBuilder();
        sb.append("Set: \n");
        String sep = "";
        for (E e : set) {
            sb.append(sep);
            sb.append(String.format("\t%s", e));
            sep = "\n";
        }
        return sb.toString();
    }

    public static <K, V> String prettyPrint(Map<K, V> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("Map: \n");
        String sep = "";
        for (Map.Entry<K, V> en : map.entrySet()) {
            sb.append(sep);
            sb.append(String.format("\t%-80s : \t %s", en.getKey(), en.getValue()));
            sep = "\n";
        }
        return sb.toString();
    }

    public static <K1, K2, V> String prettyPrint(NestedMap2<K1, K2, V> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("NestedMap2: \n");
        String sep = "";
        for (Triple<K1, K2, V> en : map.entrySet()) {
            sb.append(sep);
            sb.append(String.format("\t%-80s : \t %-40s : \t %s", en.getFirst(), en.getSecond(), en.getThird()));
            sep = "\n";
        }
        return sb.toString();
    }

    public static <T> T[] concat(T[] a1, T[] a2) {
        if (a1 == null) {
            return a2;
        }
        if (a2 == null) {
            return a1;
        }
        if (a1.length == 0) {
            return a2;
        }
        if (a2.length == 0) {
            return a1;
        }
        Object[] dest = (Object[])Array.newInstance(a1.getClass().getComponentType(), a1.length + a2.length);
        System.arraycopy(a1, 0, dest, 0, a1.length);
        System.arraycopy(a2, 0, dest, a1.length, a2.length);
        return dest;
    }

    public static <T> List<T> concat(List<T> a1, List<T> a2) {
        if (a1 == null) {
            return a2;
        }
        if (a2 == null) {
            return a1;
        }
        if (a1.isEmpty()) {
            return a2;
        }
        if (a2.isEmpty()) {
            return a1;
        }
        ArrayList<T> rtr = new ArrayList<T>(a1.size() + a2.size() + 1);
        rtr.addAll(a1);
        rtr.addAll(a2);
        return rtr;
    }

    public static <T> Collection<Set<T>> powerSet(Set<T> baseSet) {
        ArrayList<Set<T>> result = new ArrayList<Set<T>>();
        ArrayList<T> baseList = new ArrayList<T>(baseSet);
        double pow = Math.pow(2.0, baseSet.size());
        int bin = 0;
        while ((double)bin < pow) {
            HashSet subset = new HashSet();
            char[] binS = Integer.toBinaryString(bin).toCharArray();
            int pos = 0;
            while (pos < binS.length) {
                if (binS[pos] == '1') {
                    subset.add(baseList.get(pos + baseSet.size() - binS.length));
                } else assert (binS[pos] == '0');
                ++pos;
            }
            result.add(subset);
            ++bin;
        }
        return result;
    }

    public static <K, V> Map<V, K> constructReverseMapping(Map<K, V> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public static <E> boolean isDifferent(Set<E> a, Set<E> b) {
        if (a.isEmpty() && b.isEmpty()) {
            return false;
        }
        if (a.size() != b.size()) {
            return true;
        }
        return a.stream().anyMatch(e -> !b.contains(e));
    }

    public static <T> boolean differenceIsEmpty(T[] a, T[] b) {
        if (a == null || a.length == 0) {
            return true;
        }
        if (b == null || b.length == 0) {
            return false;
        }
        HashSet<T> setB = new HashSet<T>(Arrays.asList(b));
        int i = 0;
        while (i < a.length) {
            if (!setB.contains(a[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static <T> List<List<T>> crossProduct(List<List<T>> prefix, List<List<T>> suffix) {
        if (prefix.isEmpty()) {
            return suffix;
        }
        if (suffix.isEmpty()) {
            return prefix;
        }
        ArrayList<List<T>> rtr = new ArrayList<List<T>>(prefix.size() * suffix.size());
        for (List<T> p : prefix) {
            for (List<T> s : suffix) {
                rtr.add(DataStructureUtils.concat(p, s));
            }
        }
        return rtr;
    }

    public static <E> E getOneAndOnly(Iterable<E> elements, String thing) {
        Iterator<E> iterator = elements.iterator();
        assert (iterator.hasNext()) : "Must have at least one " + thing;
        E elem = iterator.next();
        assert (!iterator.hasNext()) : "Only one " + thing + " allowed";
        return elem;
    }

    public static <E> Optional<E> getOnly(Iterable<E> elements, String errMsg) {
        Iterator<E> iterator = elements.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        E elem = iterator.next();
        assert (!iterator.hasNext()) : errMsg;
        return Optional.of(elem);
    }

    public static <E> Stream<E> filteredCast(Stream<?> s, Class<E> c) {
        return s.filter(a -> c.isAssignableFrom(a.getClass())).map(c::cast);
    }

    public static <T> Set<T> asSet(Stream<T> stream) {
        Object[] elements = stream.toArray();
        return Set.of(elements);
    }
}

