/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

public class Doubleton<E> {
    private final E mOneElement;
    private final E mOtherElement;

    public Doubleton(E oneElement, E otherElement) {
        if (oneElement == null || otherElement == null) {
            throw new IllegalArgumentException();
        }
        this.mOneElement = oneElement;
        this.mOtherElement = otherElement;
    }

    public E getOneElement() {
        return this.mOneElement;
    }

    public E getOtherElement() {
        return this.mOtherElement;
    }

    public E[] toArray() {
        Object[] result = new Object[]{this.mOneElement, this.mOtherElement};
        return result;
    }

    public int hashCode() {
        return this.mOneElement.hashCode() + this.mOtherElement.hashCode();
    }

    public boolean equals(Object obj) {
        boolean equalSameOrder;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Doubleton other = (Doubleton)obj;
        boolean bl = equalSameOrder = this.getOneElement().equals(other.getOneElement()) && this.getOtherElement().equals(other.getOtherElement());
        if (equalSameOrder) {
            return true;
        }
        boolean equalSwappedOrder = this.getOneElement().equals(other.getOtherElement()) && this.getOtherElement().equals(other.getOneElement());
        return equalSwappedOrder;
    }

    public String toString() {
        return "[" + this.mOneElement + ", " + this.mOtherElement + "]";
    }
}

