/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import de.uni_freiburg.informatik.ultimate.core.model.models.IDirectedGraph;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.function.Function;
import java.util.stream.Stream;

public class GraphToTgf<N> {
    private final StringBuilder mTgfNodes = new StringBuilder();
    private final StringBuilder mTgfEdges = new StringBuilder();
    private final Map<N, Integer> mVisitedNodeToId = new HashMap<N, Integer>();
    private final Queue<N> mWorklist = new ArrayDeque<N>();
    private final Function<N, Object> mLabelOf;
    private final Function<N, Collection<N>> mSuccessorsOf;
    private final Function<N, Collection<N>> mPredecessorsOf;

    public GraphToTgf(Function<N, Collection<N>> successorsOf, Function<N, Collection<N>> predecessorsOf, Function<N, Object> nodeToLabel) {
        this.mSuccessorsOf = successorsOf;
        this.mPredecessorsOf = predecessorsOf;
        this.mLabelOf = nodeToLabel;
    }

    public static <GN extends IDirectedGraph<GN, ?>> GraphToTgf<GN> graph(Function<GN, Object> labelOf) {
        return new GraphToTgf<IDirectedGraph>(IDirectedGraph::getOutgoingNodes, IDirectedGraph::getIncomingNodes, labelOf);
    }

    public static <GN extends IDirectedGraph<GN, ?>> GraphToTgf<GN> graph(GN startingNode) {
        return GraphToTgf.graph(Object::toString).includeComponentOf((Function<IDirectedGraph, Object>)startingNode);
    }

    public String getTgf() {
        return this.mTgfNodes + "#\n" + this.mTgfEdges;
    }

    public GraphToTgf<N> includeComponentOf(N startingNode) {
        if (this.isUnvisited(startingNode)) {
            this.visit(startingNode);
        }
        while (!this.mWorklist.isEmpty()) {
            N current = this.mWorklist.remove();
            this.visitNeighbors(current);
            this.addEdges(current);
        }
        return this;
    }

    public GraphToTgf<N> includeComponentsOf(Collection<N> nodes) {
        for (N node : nodes) {
            this.includeComponentOf(node);
        }
        return this;
    }

    private void visitNeighbors(N node) {
        Stream.concat(this.mPredecessorsOf.apply(node).stream(), this.mSuccessorsOf.apply(node).stream()).filter(this::isUnvisited).forEach(this::visit);
    }

    private int visit(N node) {
        int id = this.mVisitedNodeToId.size();
        this.mVisitedNodeToId.put(node, id);
        this.mTgfNodes.append(id).append(' ').append(this.mLabelOf.apply(node)).append("\n");
        this.mWorklist.add(node);
        return id;
    }

    private void addEdges(N source) {
        int sourceId = this.idOf(source);
        this.mPredecessorsOf.apply(source).forEach(target -> this.addEdge(sourceId, this.idOf(target), "backward"));
        this.mSuccessorsOf.apply(source).forEach(target -> this.addEdge(sourceId, this.idOf(target), "forward"));
    }

    private void addEdge(int source, int target, String label) {
        this.mTgfEdges.append(source).append(' ').append(target).append(" ").append(label).append("\n");
    }

    private int idOf(N node) {
        return this.mVisitedNodeToId.get(node);
    }

    private boolean isUnvisited(N node) {
        return !this.mVisitedNodeToId.containsKey(node);
    }
}

