/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class HashDeque<E>
implements Deque<E> {
    private final Deque<E> mDeque = new ArrayDeque();
    private final Set<E> mSet = new HashSet();

    @Override
    public E pop() {
        E node = this.mDeque.pop();
        this.mSet.remove(node);
        return node;
    }

    @Override
    public void push(E node) {
        if (this.mSet.add(node)) {
            this.mDeque.push(node);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.mSet.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.mDeque.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.mDeque.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.mSet.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean rtr = false;
        for (E elem : c) {
            if (!this.mSet.add(elem)) continue;
            this.mDeque.add(elem);
            rtr = true;
        }
        return rtr;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean rtr = this.mSet.removeAll(c);
        this.mDeque.removeAll(c);
        return rtr;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean rtr = this.mSet.retainAll(c);
        this.mDeque.retainAll(c);
        return rtr;
    }

    @Override
    public void clear() {
        this.mSet.clear();
        this.mDeque.clear();
    }

    @Override
    public void addFirst(E e) {
        if (this.mSet.add(e)) {
            this.mDeque.addFirst(e);
        }
    }

    @Override
    public void addLast(E e) {
        if (this.mSet.add(e)) {
            this.mDeque.addLast(e);
        }
    }

    @Override
    public boolean offerFirst(E e) {
        if (this.mSet.add(e)) {
            return this.mDeque.offerFirst(e);
        }
        return false;
    }

    @Override
    public boolean offerLast(E e) {
        if (this.mSet.add(e)) {
            return this.mDeque.offerLast(e);
        }
        return false;
    }

    @Override
    public E removeFirst() {
        E rtr = this.mDeque.removeFirst();
        this.mSet.remove(rtr);
        return rtr;
    }

    @Override
    public E removeLast() {
        E rtr = this.mDeque.removeLast();
        this.mSet.remove(rtr);
        return rtr;
    }

    @Override
    public E pollFirst() {
        E rtr = this.mDeque.pollFirst();
        if (rtr != null) {
            this.mSet.remove(rtr);
        }
        return rtr;
    }

    @Override
    public E pollLast() {
        E rtr = this.mDeque.pollLast();
        if (rtr != null) {
            this.mSet.remove(rtr);
        }
        return rtr;
    }

    @Override
    public E getFirst() {
        return this.mDeque.getFirst();
    }

    @Override
    public E getLast() {
        return this.mDeque.getLast();
    }

    @Override
    public E peekFirst() {
        return this.mDeque.peekFirst();
    }

    @Override
    public E peekLast() {
        return this.mDeque.peekLast();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        if (this.mSet.remove(o)) {
            return this.mDeque.removeFirstOccurrence(o);
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        if (this.mSet.remove(o)) {
            return this.mDeque.removeLastOccurrence(o);
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        if (this.mSet.add(e)) {
            return this.mDeque.add(e);
        }
        return false;
    }

    @Override
    public boolean offer(E e) {
        if (this.mSet.add(e)) {
            return this.mDeque.offer(e);
        }
        return false;
    }

    @Override
    public E remove() {
        E rtr = this.mDeque.remove();
        this.mSet.remove(rtr);
        return rtr;
    }

    @Override
    public E poll() {
        E rtr = this.mDeque.poll();
        this.mSet.remove(rtr);
        return rtr;
    }

    @Override
    public E element() {
        return this.mDeque.element();
    }

    @Override
    public E peek() {
        return this.mDeque.peek();
    }

    @Override
    public boolean remove(Object o) {
        if (this.mSet.remove(o)) {
            return this.mDeque.remove(o);
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return this.mSet.contains(o);
    }

    @Override
    public int size() {
        return this.mSet.size();
    }

    @Override
    public Iterator<E> iterator() {
        return this.mDeque.iterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.mDeque.descendingIterator();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.mDeque == null ? 0 : this.mDeque.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashDeque other = (HashDeque)obj;
        return !(this.mDeque == null ? other.mDeque != null : !this.mDeque.equals(other.mDeque));
    }

    public String toString() {
        return this.mDeque.toString();
    }
}

