/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;

public class HashedPriorityQueue<E>
implements Queue<E>,
Set<E>,
Collection<E> {
    private final Queue<E> mQueue;
    private final Set<E> mSet;

    public HashedPriorityQueue(Comparator<E> comp) {
        this.mQueue = new PriorityQueue<E>(comp);
        this.mSet = new HashSet();
    }

    public E find(Object obj) {
        if (obj == null) {
            return null;
        }
        int hash = obj.hashCode();
        for (Object current : this.mQueue) {
            if (current.hashCode() != hash) continue;
            return current;
        }
        return null;
    }

    @Override
    public boolean remove(Object successor) {
        if (this.mSet.remove(successor)) {
            this.mQueue.remove(successor);
            return true;
        }
        return false;
    }

    @Override
    public E poll() {
        E rtr = this.mQueue.poll();
        this.mSet.remove(rtr);
        return rtr;
    }

    @Override
    public boolean isEmpty() {
        return this.mQueue.isEmpty();
    }

    @Override
    public boolean add(E elem) {
        if (this.mSet.add(elem)) {
            this.mQueue.add(elem);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object obj) {
        return this.mSet.contains(obj);
    }

    public String toString() {
        return CoreUtil.join(this.mQueue, ", ");
    }

    @Override
    public int size() {
        return this.mSet.size();
    }

    @Override
    public Iterator<E> iterator() {
        return this.mQueue.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.mQueue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.mQueue.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.mSet.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (this.mSet.addAll(c)) {
            this.mQueue.addAll(c);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.mSet.removeAll(c)) {
            this.mQueue.removeAll(c);
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.mSet.retainAll(c)) {
            this.mQueue.retainAll(c);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.mSet.clear();
        this.mQueue.clear();
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    @Override
    public E remove() {
        E removed = this.mQueue.remove();
        this.mSet.remove(removed);
        return removed;
    }

    @Override
    public E element() {
        return this.mQueue.element();
    }

    @Override
    public E peek() {
        return this.mQueue.peek();
    }
}

