/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.util.AbstractSequentialList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public final class ImmutableList<X>
extends AbstractSequentialList<X> {
    private static final ImmutableList NIL = new ImmutableList();
    private final int mSize;
    private final X mHead;
    private final ImmutableList<X> mTail;

    private ImmutableList() {
        this.mSize = 0;
        this.mHead = null;
        this.mTail = null;
    }

    public ImmutableList(X head, ImmutableList<X> tail) {
        this.mSize = tail.mSize + 1;
        this.mHead = head;
        this.mTail = Objects.requireNonNull(tail);
    }

    @SafeVarargs
    public ImmutableList(X ... elements) {
        this(Arrays.stream(elements).iterator());
    }

    public ImmutableList(Collection<X> elements) {
        this(elements.iterator());
    }

    private ImmutableList(Iterator<X> it) {
        if (it.hasNext()) {
            this.mHead = it.next();
            this.mTail = it.hasNext() ? new ImmutableList<X>(it) : ImmutableList.empty();
            this.mSize = this.mTail.mSize + 1;
        } else {
            this.mHead = null;
            this.mTail = null;
            this.mSize = 0;
        }
    }

    public static <X> ImmutableList<X> empty() {
        return NIL;
    }

    public static <X> ImmutableList<X> singleton(X elem) {
        return new ImmutableList<X>(elem, ImmutableList.empty());
    }

    public X getHead() {
        if (this.mSize == 0) {
            throw new NoSuchElementException();
        }
        return this.mHead;
    }

    public ImmutableList<X> getTail() {
        if (this.mSize == 0) {
            throw new UnsupportedOperationException();
        }
        return this.mTail;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImmutableList) {
            ImmutableList other = (ImmutableList)o;
            if (this.mSize != other.mSize) {
                return false;
            }
            if (this.mTail == other.mTail) {
                return Objects.equals(this.mHead, other.mHead);
            }
        }
        return super.equals(o);
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public boolean add(X e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends X> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends X> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public X set(int index, X element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, X element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public X remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<X> listIterator(int index) {
        if (index < 0 || index > this.mSize) {
            throw new IndexOutOfBoundsException();
        }
        int currentIndex = index;
        ImmutableList<X> current = this;
        while (currentIndex > 0) {
            current = current.mTail;
            --currentIndex;
        }
        return new ConsListIterator<X>(current, currentIndex);
    }

    private static final class ConsListIterator<X>
    implements ListIterator<X> {
        private ImmutableList<X> mCurrent;
        private int mIndex;

        public ConsListIterator(ImmutableList<X> list, int index) {
            this.mCurrent = list;
            this.mIndex = index;
        }

        @Override
        public boolean hasNext() {
            return this.mCurrent != null && this.mCurrent.mSize > 0;
        }

        @Override
        public X next() {
            if (this.mCurrent == null || this.mCurrent.mSize == 0) {
                throw new NoSuchElementException();
            }
            Object elem = this.mCurrent.mHead;
            this.mCurrent = this.mCurrent.mTail;
            ++this.mIndex;
            return elem;
        }

        @Override
        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public X previous() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int nextIndex() {
            return this.mIndex;
        }

        @Override
        public int previousIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(X e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(X e) {
            throw new UnsupportedOperationException();
        }
    }
}

