/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class ImmutableSet<E>
implements Set<E> {
    private static final String ERROR_MSG = "Set is immutable";
    private static final ImmutableSet EMPTY_SET = new ImmutableSet(Collections.emptySet());
    private final Set<E> mUnderlying;
    private int mHash;
    private boolean mHashCached;

    private ImmutableSet(Set<E> underlying) {
        this.mUnderlying = Objects.requireNonNull(underlying);
    }

    public static <E> ImmutableSet<E> empty() {
        return EMPTY_SET;
    }

    public static <E> ImmutableSet<E> singleton(E elem) {
        return ImmutableSet.of(Collections.singleton(elem));
    }

    public static <E> ImmutableSet<E> of(Set<E> set) {
        if (set.isEmpty()) {
            return ImmutableSet.empty();
        }
        if (set instanceof ImmutableSet) {
            return (ImmutableSet)set;
        }
        return new ImmutableSet<E>(set);
    }

    public static <E> ImmutableSet<E> copyOf(Collection<E> set) {
        if (set.isEmpty()) {
            return ImmutableSet.empty();
        }
        if (set instanceof ImmutableSet) {
            return (ImmutableSet)set;
        }
        return new ImmutableSet<E>(new HashSet<E>(set));
    }

    public static <E> ImmutableSet<E> orderedCopyOf(Collection<E> set) {
        if (set.isEmpty()) {
            return ImmutableSet.empty();
        }
        if (set instanceof ImmutableSet) {
            return (ImmutableSet)set;
        }
        return new ImmutableSet<E>(new LinkedHashSet<E>(set));
    }

    public static <T> Collector<T, ?, ImmutableSet<T>> collector() {
        return ImmutableSet.collector(Collectors.toSet(), new Collector.Characteristics[]{Collector.Characteristics.UNORDERED}, true);
    }

    public static <T, A extends Set<T>> Collector<T, A, ImmutableSet<T>> collector(Collector<T, A, Set<T>> coll) {
        EnumSet<Collector.Characteristics> characteristics = EnumSet.noneOf(Collector.Characteristics.class);
        if (coll.characteristics().contains((Object)Collector.Characteristics.UNORDERED)) {
            characteristics.add(Collector.Characteristics.UNORDERED);
        }
        if (coll.characteristics().contains((Object)Collector.Characteristics.CONCURRENT)) {
            characteristics.add(Collector.Characteristics.CONCURRENT);
        }
        boolean elideFinish = coll.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH);
        return ImmutableSet.collector(coll, (Collector.Characteristics[])characteristics.toArray(Collector.Characteristics[]::new), elideFinish);
    }

    private static <T, A extends Set<T>> Collector<T, A, ImmutableSet<T>> collector(Collector<T, A, Set<T>> coll, Collector.Characteristics[] characteristics, boolean elideFinish) {
        Function<Set<Object>, ImmutableSet> finisher = elideFinish ? ImmutableSet::of : coll.finisher().andThen(ImmutableSet::of);
        return Collector.of(coll.supplier(), coll.accumulator(), coll.combiner(), finisher, characteristics);
    }

    @Override
    public boolean contains(Object o) {
        return this.mUnderlying.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.mUnderlying.containsAll(c);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof ImmutableSet) {
            ImmutableSet other = (ImmutableSet)obj;
            if (this.mHashCached && other.mHashCached && this.mHash != other.mHash) {
                return false;
            }
            return this.mUnderlying.equals(other.mUnderlying);
        }
        return this.mUnderlying.equals(obj);
    }

    @Override
    public int hashCode() {
        if (!this.mHashCached) {
            this.mHash = this.mUnderlying.hashCode();
            this.mHashCached = true;
        }
        assert (this.mUnderlying.hashCode() == this.mHash) : "Immutable set was modified";
        return this.mHash;
    }

    @Override
    public boolean isEmpty() {
        return this.mUnderlying.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<E> it = this.mUnderlying.iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public E next() {
                return it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException(ImmutableSet.ERROR_MSG);
            }
        };
    }

    @Override
    public int size() {
        return this.mUnderlying.size();
    }

    @Override
    public Object[] toArray() {
        return this.mUnderlying.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.mUnderlying.toArray(a);
    }

    public String toString() {
        return this.mUnderlying.toString();
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException(ERROR_MSG);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException(ERROR_MSG);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(ERROR_MSG);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException(ERROR_MSG);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException(ERROR_MSG);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        throw new UnsupportedOperationException(ERROR_MSG);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException(ERROR_MSG);
    }
}

