/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class IteratorConcatenation<E>
implements Iterator<E> {
    private final List<Iterator<E>> mIterators;
    private int mCurrent;
    private E mNext;

    public IteratorConcatenation(List<Iterator<E>> iterators) {
        this.mIterators = iterators;
        this.mCurrent = 0;
        this.mNext = this.mIterators.isEmpty() ? null : this.getNext();
    }

    @SafeVarargs
    public IteratorConcatenation(Iterator<E> ... iterators) {
        this(Arrays.asList(iterators));
    }

    private E getNext() {
        Iterator<E> currentIterator = this.mIterators.get(this.mCurrent);
        while (!currentIterator.hasNext() && this.mCurrent + 1 < this.mIterators.size()) {
            ++this.mCurrent;
            currentIterator = this.mIterators.get(this.mCurrent);
        }
        if (currentIterator.hasNext()) {
            return currentIterator.next();
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.mNext != null;
    }

    @Override
    public E next() {
        E result = this.mNext;
        this.mNext = this.getNext();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("IteratorConcatenation is not modifiable");
    }
}

