/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MultiElementCounter<E> {
    private final Map<E, Integer> mCounter = new HashMap<E, Integer>();

    public Integer increment(E element) {
        Integer lastIndex = this.mCounter.get(element);
        Integer newIndex = lastIndex == null ? Integer.valueOf(1) : Integer.valueOf(lastIndex + 1);
        this.mCounter.put(element, newIndex);
        return newIndex;
    }

    public Integer increment(E element, int k) {
        Integer lastIndex = this.mCounter.get(element);
        Integer newIndex = lastIndex == null ? Integer.valueOf(k) : Integer.valueOf(lastIndex + k);
        this.mCounter.put(element, newIndex);
        return newIndex;
    }

    public Integer getNumber(E elem) {
        Integer number = this.mCounter.get(elem);
        if (number == null) {
            return 0;
        }
        return number;
    }

    public Set<E> getElements() {
        return this.mCounter.keySet();
    }

    public static <E> MultiElementCounter<E> add(MultiElementCounter<E> mec1, MultiElementCounter<E> mec2) {
        HashSet<E> allElems = new HashSet<E>(mec1.getElements());
        allElems.addAll(mec2.getElements());
        MultiElementCounter result = new MultiElementCounter();
        for (Object elem : allElems) {
            int sum = mec1.getNumber(elem) + mec2.getNumber(elem);
            result.increment(elem, sum);
        }
        return result;
    }

    public String toString() {
        return String.valueOf(this.mCounter);
    }
}

